/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.highlighter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import jnpad.GUIUtilities;
import jnpad.config.Config;
import jnpad.text.highlighter.IHighlightPainter;

public class SearchHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter
implements IHighlightPainter {
    private Color _color;
    private Color _borderColor;

    public SearchHighlightPainter() {
        super(Config.SEARCH_HIGHLIGHTER_COLOR.getValue());
        this.configure(1);
    }

    @Override
    public void configure(int cfg) {
        if ((cfg & 1) != 0) {
            this.setColor(Config.SEARCH_HIGHLIGHTER_COLOR.getValue());
            this.setBorderColor(Config.SEARCH_HIGHLIGHTER_BORDER_COLOR.getValue());
        }
    }

    @Override
    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        if (color != null) {
            this._color = color;
        }
    }

    public Color getBorderColor() {
        return this._borderColor;
    }

    public void setBorderColor(Color color) {
        if (color != null) {
            this._borderColor = color;
        }
    }

    @Override
    public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
        Rectangle r = this.getDrawingArea(offs0, offs1, bounds, view);
        if (r == null) {
            return null;
        }
        Color color = this.getColor();
        g.setColor(color == null ? c.getSelectionColor() : color);
        g.fillRect(r.x, r.y, r.width, r.height);
        Color borderColor = this.getBorderColor();
        if (borderColor != null) {
            GUIUtilities.drawBorder(g, borderColor, r.x, r.y, r.width, r.height);
        }
        return r;
    }

    private Rectangle getDrawingArea(int offs0, int offs1, Shape bounds, View view) {
        if (offs0 == view.getStartOffset() && offs1 == view.getEndOffset()) {
            Rectangle alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            return alloc;
        }
        try {
            Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
            return shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

