/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import jnpad.config.Configurable;
import jnpad.text.TextBundle;
import jnpad.text.syntax.ASN1Scheme;
import jnpad.text.syntax.CPPScheme;
import jnpad.text.syntax.CScheme;
import jnpad.text.syntax.JavaScheme;
import jnpad.text.syntax.PlainScheme;
import jnpad.text.syntax.PropertiesScheme;

public abstract class Scheme
implements Configurable,
Serializable {
    private static final long serialVersionUID = -8902741649205093510L;
    protected boolean mini;

    public Scheme(boolean mini) {
        this.mini = mini;
    }

    public static Scheme getScheme(String contentType, boolean mini) {
        if ("text/properties".equals(contentType)) {
            return new PropertiesScheme(mini);
        }
        if ("text/java".equals(contentType)) {
            return new JavaScheme(mini);
        }
        if ("text/c".equals(contentType)) {
            return new CScheme(mini);
        }
        if ("text/cpp".equals(contentType)) {
            return new CPPScheme(mini);
        }
        if ("text/asn1".equals(contentType)) {
            return new ASN1Scheme(mini);
        }
        return new PlainScheme(mini);
    }

    public abstract Color getSelectedTextColor();

    public abstract Color getTextColor();

    public abstract void setTextColor(Color var1);

    public abstract Font getTextFont();

    public abstract void setTextFont(Font var1);

    public String getDisplayName() {
        return Scheme.getDisplayName(this.getContentType());
    }

    public static String getDisplayName(String contentType) {
        if ("text/java".equals(contentType)) {
            return "Java";
        }
        if ("text/properties".equals(contentType)) {
            return TextBundle.getString("Scheme.properties", new Object[0]);
        }
        if ("text/c".equals(contentType)) {
            return "C";
        }
        if ("text/cpp".equals(contentType)) {
            return "C++";
        }
        if ("text/asn1".equals(contentType)) {
            return "ASN.1";
        }
        return TextBundle.getString("Scheme.text", new Object[0]);
    }

    public abstract String getContentType();

    public abstract String[] getStartComment();

    public abstract String[] getEndComment();

    public abstract String[] getStartMultilineComment();

    public abstract String[] getEndMultilineComment();

    public static boolean hasCLikeSyntax(String contentType) {
        return "text/java".equals(contentType) || "text/c".equals(contentType) || "text/cpp".equals(contentType);
    }

    public boolean hasCLikeSyntax() {
        return Scheme.hasCLikeSyntax(this.getContentType());
    }
}

