/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Segment;
import javax.swing.undo.CannotRedoException;
import jnpad.JNPadFrame;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.search.SearchContext;
import jnpad.text.Buffer;
import jnpad.text.CompletionPopup;
import jnpad.text.CompletionUtilities;
import jnpad.text.EditPane;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextAction;
import jnpad.text.JNPadTextArea;
import jnpad.text.Scheme;
import jnpad.text.TextUtilities;
import jnpad.util.Utilities;

public final class JNPadTextActions {
    public static final String ACTION_NAME_UNDO = "jnpad-text-undo";
    public static final String ACTION_NAME_REDO = "jnpad-text-redo";
    public static final String ACTION_NAME_COPY_LINE = "jnpad-text-copy-line";
    public static final String ACTION_NAME_CUT_LINE = "jnpad-text-cut-line";
    public static final String ACTION_NAME_DELETE_PARAGRAPH = "jnpad-text-delete-paragraph";
    public static final String ACTION_NAME_DELETION_BEGIN_PARAGRAPH = "jnpad-text-deletion-begin-paragraph";
    public static final String ACTION_NAME_DELETION_END_PARAGRAPH = "jnpad-text-deletion-end-paragraph";
    public static final String ACTION_NAME_DELETE_LINE = "jnpad-text-delete-line";
    public static final String ACTION_NAME_DELETION_BEGIN_LINE = "jnpad-text-deletion-begin-line";
    public static final String ACTION_NAME_DELETION_END_LINE = "jnpad-text-deletion-end-line";
    public static final String ACTION_NAME_DELETE_WORD = "jnpad-text-delete-word";
    public static final String ACTION_NAME_HIGHLIGHT_ALL_OCCURRENCES = "jnpad-text-highlight-all-occurrences";
    public static final String ACTION_NAME_CLEAR_ALL_OCCURRENCES = "jnpad-text-clear-all-occurrences";
    public static final String ACTION_NAME_NEXT_OCCURRENCE = "jnpad-text-next-occurrence";
    public static final String ACTION_NAME_PREVIOUS_OCCURRENCE = "jnpad-text-previous-occurrence";
    public static final String ACTION_NAME_RIGHT_INDENT = "jnpad-text-right-indent";
    public static final String ACTION_NAME_LEFT_INDENT = "jnpad-text-left-indent";
    public static final String ACTION_NAME_INCREASE_FONT = "jnpad-text-increase-font";
    public static final String ACTION_NAME_DECREASE_FONT = "jnpad-text-decrease-font";
    public static final String ACTION_NAME_TOGGLE_TEXT_MODE = "jnpad-text-toggle-text-mode";
    public static final String ACTION_NAME_CAPS_LOCK = "jnpad-text-caps-lock";
    public static final String ACTION_NAME_NUM_LOCK = "jnpad-text-num-lock";
    public static final String ACTION_NAME_COMPLETE_WORD = "jnpad-text-complete-word";
    public static final String ACTION_NAME_COMPLETE_WORD_ALL = "jnpad-text-complete-word-all";
    public static final String ACTION_NAME_TABS_TO_SPACES = "jnpad-text-tabs-to-spaces";
    public static final String ACTION_NAME_SPACES_TO_TABS = "jnpad-text-spaces-to-tabs";
    private HashMap<Object, Action> actions;
    private Keymap keymap;
    Action undoAction;
    Action redoAction;
    Action selectWordAction;
    Action deleteParagraphAction;
    Action deletionBeginParagraphAction;
    Action deletionEndParagraphAction;
    Action deleteLineAction;
    Action deletionBeginLineAction;
    Action deletionEndLineAction;
    Action deleteWordAction;
    Action copyLineAction;
    Action cutLineAction;
    Action highlightAllOccurrencesAction;
    Action clearAllOccurrencesAction;
    Action nextOccurrenceAction;
    Action previousOccurrenceAction;
    Action rightIndentAction;
    Action leftIndentAction;
    Action increaseFontAction;
    Action decreaseFontAction;
    Action insertBreakAction;
    Action toggleTextModeAction;
    Action capsLockAction;
    Action numLockAction;
    Action spacesToTabsAction;
    Action tabsToSpacesAction;
    Action completeWordAction;
    Action completeWordAllAction;
    private static JNPadTextActions instance;
    private Action[] overrideActions;
    private static final Logger LOGGER;

    static {
        LOGGER = Logger.getLogger(JNPadTextActions.class.getName());
    }

    public static JNPadTextActions getActions(JTextComponent textComponent) {
        if (instance == null) {
            instance = new JNPadTextActions(textComponent);
        }
        if (textComponent != null) {
            textComponent.setKeymap(JNPadTextActions.instance.keymap);
            instance.overrideActions(textComponent);
        }
        return instance;
    }

    private void overrideActions(JTextComponent textComponent) {
        Action[] actionArray = this.overrideActions;
        int n = this.overrideActions.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            textComponent.getActionMap().put(action.getValue("Name"), action);
            ++n2;
        }
    }

    private JNPadTextActions(JTextComponent textComponent) {
        Keymap origKeymap = textComponent.getKeymap();
        this.keymap = JTextComponent.addKeymap("jNPad map", origKeymap);
        this.createActionTable(textComponent);
        if (!Accelerators.isUsingCompositeShortcuts()) {
            JNPadTextActions.add(this.keymap, "jnpad-undo.shortcut", Accelerators.UNDO, this.undoAction);
            JNPadTextActions.add(this.keymap, "jnpad-redo.shortcut", Accelerators.REDO, this.redoAction);
            JNPadTextActions.add(this.keymap, "jnpad-select-line.shortcut", Accelerators.SELECT_LINE, this.get("select-line"));
            JNPadTextActions.add(this.keymap, "jnpad-selection-begin-line.shortcut", Accelerators.SELECTION_BEGIN_LINE, this.get("selection-begin-line"));
            JNPadTextActions.add(this.keymap, "jnpad-selection-end-line.shortcut", Accelerators.SELECTION_END_LINE, this.get("selection-end-line"));
            JNPadTextActions.add(this.keymap, "jnpad-select-paragraph.shortcut", Accelerators.SELECT_PARAGRAPH, this.get("select-paragraph"));
            JNPadTextActions.add(this.keymap, "jnpad-selection-begin-paragraph.shortcut", Accelerators.SELECTION_BEGIN_PARAGRAPH, this.get("selection-begin-paragraph"));
            JNPadTextActions.add(this.keymap, "jnpad-selection-end-paragraph.shortcut", Accelerators.SELECTION_END_PARAGRAPH, this.get("selection-end-paragraph"));
            JNPadTextActions.add(this.keymap, "jnpad-select-word.shortcut", Accelerators.SELECT_WORD, this.selectWordAction);
            JNPadTextActions.add(this.keymap, "jnpad-delete-line.shortcut", Accelerators.DELETE_LINE, this.deleteLineAction);
            JNPadTextActions.add(this.keymap, "jnpad-deletion-begin-line.shortcut", Accelerators.DELETION_BEGIN_LINE, this.deletionBeginLineAction);
            JNPadTextActions.add(this.keymap, "jnpad-deletion-end-line.shortcut", Accelerators.DELETION_END_LINE, this.deletionEndLineAction);
            JNPadTextActions.add(this.keymap, "jnpad-delete-paragraph.shortcut", Accelerators.DELETE_PARAGRAPH, this.deleteParagraphAction);
            JNPadTextActions.add(this.keymap, "jnpad-deletion-begin-paragraph.shortcut", Accelerators.DELETION_BEGIN_PARAGRAPH, this.deletionBeginParagraphAction);
            JNPadTextActions.add(this.keymap, "jnpad-deletion-end-paragraph.shortcut", Accelerators.DELETION_END_PARAGRAPH, this.deletionEndParagraphAction);
            JNPadTextActions.add(this.keymap, "jnpad-delete-word.shortcut", Accelerators.DELETE_WORD, this.deleteWordAction);
            JNPadTextActions.add(this.keymap, "jnpad-copy-line.shortcut", Accelerators.COPY_LINE, this.copyLineAction);
            JNPadTextActions.add(this.keymap, "jnpad-cut-line.shortcut", Accelerators.CUT_LINE, this.cutLineAction);
            JNPadTextActions.add(this.keymap, "jnpad-highlight-all-occurrences.shortcut", Accelerators.HIGHLIGHT_ALL_OCCURRENCES, this.highlightAllOccurrencesAction);
            JNPadTextActions.add(this.keymap, "jnpad-clear-all-occurrences.shortcut", Accelerators.CLEAR_ALL_OCCURRENCES, this.clearAllOccurrencesAction);
            JNPadTextActions.add(this.keymap, "jnpad-next-occurrence.shortcut", Accelerators.NEXT_OCCURRENCE, this.nextOccurrenceAction);
            JNPadTextActions.add(this.keymap, "jnpad-previous-occurrence.shortcut", Accelerators.PREVIOUS_OCCURRENCE, this.previousOccurrenceAction);
            JNPadTextActions.add(this.keymap, "jnpad-right-indent.shortcut", Accelerators.RIGHT_INDENT, this.rightIndentAction);
            JNPadTextActions.add(this.keymap, "jnpad-left-indent", Accelerators.LEFT_INDENT, this.leftIndentAction);
            JNPadTextActions.add(this.keymap, "jnpad-increase-font.shortcut", Accelerators.INCREASE_FONT, this.increaseFontAction);
            JNPadTextActions.add(this.keymap, "jnpad-decrease-font.shortcut", Accelerators.DECREASE_FONT, this.decreaseFontAction);
            JNPadTextActions.add(this.keymap, "jnpad-complete-word.shortcut", Accelerators.COMPLETE_WORD, this.completeWordAction);
            JNPadTextActions.add(this.keymap, "jnpad-complete-word-all.shortcut", Accelerators.COMPLETE_WORD_ALL, this.completeWordAllAction);
            JNPadTextActions.add(this.keymap, "jnpad-spaces-to-tabs.shortcut", Accelerators.SPACES_TO_TABS, this.spacesToTabsAction);
            JNPadTextActions.add(this.keymap, "jnpad-tabs-to-spaces.shortcut", Accelerators.TABS_TO_SPACES, this.tabsToSpacesAction);
        }
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), this.insertBreakAction);
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 0), this.toggleTextModeAction);
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(20, 0), this.capsLockAction);
        this.keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(144, 0), this.numLockAction);
    }

    private static void add(Keymap keymap, String key, KeyStroke def, Action action) {
        if (Config.isUsingCustomShortcuts()) {
            KeyStroke ks = Accelerators.getPropAccelerator(key, null);
            if (ks != null) {
                keymap.addActionForKeyStroke(ks, action);
            }
        } else {
            keymap.addActionForKeyStroke(Accelerators.getPropAccelerator(key, def), action);
        }
    }

    public Action get(String name) {
        return this.actions.get(name);
    }

    private void createActionTable(JTextComponent textComponent) {
        Action action;
        Action[] textActions = textComponent.getActions();
        this.insertBreakAction = new InsertBreakAction();
        this.selectWordAction = new SelectWordAction();
        this.overrideActions = new Action[]{this.insertBreakAction, this.selectWordAction, new NextWordAction(false), new NextWordAction(true), new PreviousWordAction(false), new PreviousWordAction(true), new EndWordAction(false), new EndWordAction(true), new BeginWordAction(false), new BeginWordAction(true)};
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.deleteLineAction = new DeleteLineAction();
        this.deletionBeginLineAction = new DeletionBeginLineAction();
        this.deletionEndLineAction = new DeletionEndLineAction();
        this.deleteParagraphAction = new DeleteParagraphAction();
        this.deletionBeginParagraphAction = new DeletionBeginParagraphAction();
        this.deletionEndParagraphAction = new DeletionEndParagraphAction();
        this.deleteWordAction = new DeleteWordAction();
        this.copyLineAction = new CopyLineAction();
        this.cutLineAction = new CutLineAction();
        this.highlightAllOccurrencesAction = new HighlightAllOccurrencesAction();
        this.clearAllOccurrencesAction = new ClearAllOccurrencesAction();
        this.nextOccurrenceAction = new NextOccurrenceAction();
        this.previousOccurrenceAction = new PreviousOccurrenceAction();
        this.rightIndentAction = new RightIndentAction();
        this.leftIndentAction = new LeftIndentAction();
        this.increaseFontAction = new IncreaseFontAction();
        this.decreaseFontAction = new DecreaseFontAction();
        this.toggleTextModeAction = new ToggleTextModeAction();
        this.capsLockAction = new CapsLockAction();
        this.numLockAction = new NumLockAction();
        this.tabsToSpacesAction = new TabsToSpacesAction();
        this.spacesToTabsAction = new SpacesToTabsAction();
        this.completeWordAction = new CompleteWordAction();
        this.completeWordAllAction = new CompleteWordAllAction();
        Action[] myActions = new Action[]{this.undoAction, this.redoAction, this.deleteLineAction, this.deletionBeginLineAction, this.deletionEndLineAction, this.deleteParagraphAction, this.deletionBeginParagraphAction, this.deletionEndParagraphAction, this.deleteWordAction, this.copyLineAction, this.cutLineAction, this.highlightAllOccurrencesAction, this.clearAllOccurrencesAction, this.nextOccurrenceAction, this.previousOccurrenceAction, this.rightIndentAction, this.leftIndentAction, this.increaseFontAction, this.decreaseFontAction, this.toggleTextModeAction, this.capsLockAction, this.numLockAction, this.tabsToSpacesAction, this.spacesToTabsAction, this.completeWordAction, this.completeWordAllAction};
        this.actions = new HashMap();
        Action[] actionArray = textActions;
        int n = textActions.length;
        int n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            this.actions.put(action.getValue("Name"), action);
            ++n2;
        }
        actionArray = this.overrideActions;
        n = this.overrideActions.length;
        n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            this.actions.put(action.getValue("Name"), action);
            ++n2;
        }
        actionArray = myActions;
        n = myActions.length;
        n2 = 0;
        while (n2 < n) {
            action = actionArray[n2];
            this.actions.put(action.getValue("Name"), action);
            ++n2;
        }
    }

    public void setUndoEnabled(boolean b) {
        this.undoAction.setEnabled(b);
    }

    public void setRedoEnabled(boolean b) {
        this.redoAction.setEnabled(b);
    }

    public void setEditable(boolean editable) {
        for (Object key : this.actions.keySet()) {
            Action a = this.actions.get(key);
            if (!(a instanceof IEditAction)) continue;
            a.setEnabled(editable);
        }
    }

    static class BeginWordAction
    extends JNPadTextActionWithOrWithoutSelection {
        private static final long serialVersionUID = -816193758794410697L;

        BeginWordAction(boolean withSelection) {
            super(withSelection ? "selection-begin-word" : "caret-begin-word", withSelection);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadTextArea textArea = this.getTextArea(e);
                if (textArea != null) {
                    String delimiters = textArea.getDelimiters();
                    int offs = textArea.getCaretPosition();
                    String text = textArea.getDocument().getText(0, offs);
                    while (offs > 0) {
                        char chPrev = text.charAt(offs - 1);
                        if (delimiters.indexOf(chPrev) >= 0 || Character.isWhitespace(chPrev) || --offs == 0) break;
                        char ch = text.charAt(offs);
                        chPrev = text.charAt(offs - 1);
                        if (delimiters.indexOf(ch) >= 0 || delimiters.indexOf(chPrev) >= 0 || Character.isWhitespace(ch) || Character.isWhitespace(chPrev)) break;
                    }
                    this.moveCaret(textArea, offs);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class CapsLockAction
    extends JNPadTextAction {
        private static final long serialVersionUID = -174260352478116902L;

        CapsLockAction() {
            super(JNPadTextActions.ACTION_NAME_CAPS_LOCK);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                try {
                    jNPad.getStatusBar().setCapsLockIndicatorEnabled(jNPad.getToolkit().getLockingKeyState(20));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class ClearAllOccurrencesAction
    extends JNPadTextAction {
        private static final long serialVersionUID = -3505149505020895583L;

        ClearAllOccurrencesAction() {
            super(JNPadTextActions.ACTION_NAME_CLEAR_ALL_OCCURRENCES);
            this.setEnabled(Config.OCCURRENCES_HIGHLIGHTER_VISIBLE.getValue());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                EditPane editPane = jNPad.getActiveEditPane();
                if (editPane != null) {
                    editPane.clearAllOccurrences();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class CompleteWordAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = -8404878066287152329L;

        CompleteWordAction() {
            super(JNPadTextActions.ACTION_NAME_COMPLETE_WORD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                JNPadTextArea textArea = jNPad.getActiveTextArea();
                if (textArea != null) {
                    String word = CompletionUtilities.getWord(textArea, textArea.getCaretPosition());
                    if (Utilities.isBlankString(word)) {
                        return;
                    }
                    jNPad.showWaitCursor();
                    TreeSet<String> completions = new TreeSet<String>();
                    int wordLen = word.length();
                    CompletionUtilities.set(textArea, word, wordLen, textArea.getDelimiters(), completions);
                    if (completions.size() > 1) {
                        int endIndex = String.valueOf(completions.first()).length();
                        for (String completion : completions) {
                            endIndex = Math.min(endIndex, CompletionUtilities.getDivergentIndex(String.valueOf(completions.first()), String.valueOf(completion)));
                        }
                        jNPad.hideWaitCursor();
                        if (endIndex > wordLen) {
                            textArea.insert(String.valueOf(completions.first()).substring(wordLen, endIndex), textArea.getCaretPosition());
                        } else {
                            new CompletionPopup(textArea, word, completions.toArray(new String[completions.size()]));
                        }
                    } else {
                        jNPad.hideWaitCursor();
                        if (completions.size() == 1) {
                            textArea.insert(String.valueOf(completions.first()).substring(wordLen), textArea.getCaretPosition());
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class CompleteWordAllAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = 8081149527394287826L;

        CompleteWordAllAction() {
            super(JNPadTextActions.ACTION_NAME_COMPLETE_WORD_ALL);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                JNPadTextArea textArea = jNPad.getActiveTextArea();
                if (textArea != null) {
                    String word = CompletionUtilities.getWord(textArea, textArea.getCaretPosition());
                    if (Utilities.isBlankString(word)) {
                        return;
                    }
                    TreeSet<String> completions = new TreeSet<String>();
                    int wordLen = word.length();
                    jNPad.showWaitCursor();
                    JNPadTextArea[] jNPadTextAreaArray = jNPad.getViewer().getTextAreas();
                    int n = jNPadTextAreaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JNPadTextArea etxarea = jNPadTextAreaArray[n2];
                        CompletionUtilities.set(etxarea, word, wordLen, textArea.getDelimiters(), completions);
                        ++n2;
                    }
                    if (completions.size() > 1) {
                        int endIndex = String.valueOf(completions.first()).length();
                        for (String completion : completions) {
                            endIndex = Math.min(endIndex, CompletionUtilities.getDivergentIndex(String.valueOf(completions.first()), String.valueOf(completion)));
                        }
                        jNPad.hideWaitCursor();
                        if (endIndex > wordLen) {
                            textArea.insert(String.valueOf(completions.first()).substring(wordLen, endIndex), textArea.getCaretPosition());
                        } else {
                            new CompletionPopup(textArea, word, completions.toArray(new String[completions.size()]));
                        }
                    } else {
                        jNPad.hideWaitCursor();
                        if (completions.size() == 1) {
                            textArea.insert(String.valueOf(completions.first()).substring(wordLen), textArea.getCaretPosition());
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    class CopyLineAction
    extends JNPadTextAction {
        private static final long serialVersionUID = -1763465116999117170L;

        CopyLineAction() {
            super(JNPadTextActions.ACTION_NAME_COPY_LINE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Buffer buffer = null;
            try {
                try {
                    JTextComponent target;
                    JNPadFrame jNPad = this.getJNPadParent(e);
                    buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.beginCompoundEdit();
                    }
                    if ((target = this.getTextComponent(e)) != null) {
                        JNPadTextActions.this.get("select-line").actionPerformed(e);
                        JNPadTextActions.this.get("copy-to-clipboard").actionPerformed(e);
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    if (buffer != null) {
                        buffer.endCompoundEdit();
                    }
                }
            }
            finally {
                if (buffer != null) {
                    buffer.endCompoundEdit();
                }
            }
        }
    }

    class CutLineAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = -8555512203267088983L;

        CutLineAction() {
            super(JNPadTextActions.ACTION_NAME_CUT_LINE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Buffer buffer = null;
            try {
                try {
                    JTextComponent target;
                    JNPadFrame jNPad = this.getJNPadParent(e);
                    buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.beginCompoundEdit();
                    }
                    if ((target = this.getTextComponent(e)) != null) {
                        JNPadTextActions.this.get("select-line").actionPerformed(e);
                        JNPadTextActions.this.get("cut-to-clipboard").actionPerformed(e);
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    if (buffer != null) {
                        buffer.endCompoundEdit();
                    }
                }
            }
            finally {
                if (buffer != null) {
                    buffer.endCompoundEdit();
                }
            }
        }
    }

    static class DecreaseFontAction
    extends JNPadTextAction {
        private static final long serialVersionUID = -6358470088719501208L;

        DecreaseFontAction() {
            super(JNPadTextActions.ACTION_NAME_DECREASE_FONT);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JTextComponent target = this.getTextComponent(e);
                if (target != null) {
                    Font font = target.getFont();
                    Font newFont = font.deriveFont((float)(font.getSize() - 1));
                    JNPadFrame jNPad = this.getJNPadParent(e);
                    Buffer buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.setEditorFont(newFont);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    class DeleteLineAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = 3635891954489427968L;

        DeleteLineAction() {
            super(JNPadTextActions.ACTION_NAME_DELETE_LINE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Buffer buffer = null;
            try {
                try {
                    JTextComponent target;
                    JNPadFrame jNPad = this.getJNPadParent(e);
                    buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.beginCompoundEdit();
                    }
                    if ((target = this.getTextComponent(e)) != null) {
                        JNPadTextActions.this.get("select-line").actionPerformed(e);
                        JNPadTextActions.this.get("delete-next").actionPerformed(e);
                        int lineCount = TextUtilities.getNumberOfLines(target.getDocument());
                        int lineNumbr = TextUtilities.getLineNumber(target.getDocument(), target.getCaretPosition());
                        if (lineNumbr < lineCount - 1) {
                            JNPadTextActions.this.get("delete-next").actionPerformed(e);
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    if (buffer != null) {
                        buffer.endCompoundEdit();
                    }
                }
            }
            finally {
                if (buffer != null) {
                    buffer.endCompoundEdit();
                }
            }
        }
    }

    class DeleteParagraphAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = -2003966419296180385L;

        DeleteParagraphAction() {
            super(JNPadTextActions.ACTION_NAME_DELETE_PARAGRAPH);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Buffer buffer = null;
            try {
                try {
                    JTextComponent target;
                    JNPadFrame jNPad = this.getJNPadParent(e);
                    buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.beginCompoundEdit();
                    }
                    if ((target = this.getTextComponent(e)) != null) {
                        JNPadTextActions.this.get("select-paragraph").actionPerformed(e);
                        JNPadTextActions.this.get("delete-next").actionPerformed(e);
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    if (buffer != null) {
                        buffer.endCompoundEdit();
                    }
                }
            }
            finally {
                if (buffer != null) {
                    buffer.endCompoundEdit();
                }
            }
        }
    }

    class DeleteWordAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = -6227149433396832606L;

        DeleteWordAction() {
            super(JNPadTextActions.ACTION_NAME_DELETE_WORD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Buffer buffer = null;
            try {
                try {
                    JTextComponent target;
                    JNPadFrame jNPad = this.getJNPadParent(e);
                    buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.beginCompoundEdit();
                    }
                    if ((target = this.getTextComponent(e)) != null) {
                        JNPadTextActions.this.get("select-word").actionPerformed(e);
                        JNPadTextActions.this.get("delete-next").actionPerformed(e);
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    if (buffer != null) {
                        buffer.endCompoundEdit();
                    }
                }
            }
            finally {
                if (buffer != null) {
                    buffer.endCompoundEdit();
                }
            }
        }
    }

    class DeletionBeginLineAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = 8754448756437935965L;

        DeletionBeginLineAction() {
            super(JNPadTextActions.ACTION_NAME_DELETION_BEGIN_LINE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JTextComponent target = this.getTextComponent(e);
                if (target != null) {
                    JNPadTextActions.this.get("selection-begin-line").actionPerformed(e);
                    JNPadTextActions.this.get("delete-next").actionPerformed(e);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    class DeletionBeginParagraphAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = 7821147495101266649L;

        DeletionBeginParagraphAction() {
            super(JNPadTextActions.ACTION_NAME_DELETION_BEGIN_PARAGRAPH);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JTextComponent target = this.getTextComponent(e);
                if (target != null) {
                    JNPadTextActions.this.get("selection-begin-paragraph").actionPerformed(e);
                    JNPadTextActions.this.get("delete-next").actionPerformed(e);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    class DeletionEndLineAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = 7656879384815607333L;

        DeletionEndLineAction() {
            super(JNPadTextActions.ACTION_NAME_DELETION_END_LINE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JTextComponent target = this.getTextComponent(e);
                if (target != null) {
                    JNPadTextActions.this.get("selection-end-line").actionPerformed(e);
                    JNPadTextActions.this.get("delete-next").actionPerformed(e);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    class DeletionEndParagraphAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = 7031727398621792604L;

        DeletionEndParagraphAction() {
            super(JNPadTextActions.ACTION_NAME_DELETION_END_PARAGRAPH);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JTextComponent target = this.getTextComponent(e);
                if (target != null) {
                    JNPadTextActions.this.get("selection-end-paragraph").actionPerformed(e);
                    JNPadTextActions.this.get("delete-next").actionPerformed(e);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class EndWordAction
    extends JNPadTextActionWithOrWithoutSelection {
        private static final long serialVersionUID = -1766369979956403270L;

        EndWordAction(boolean withSelection) {
            super(withSelection ? "selection-end-word" : "caret-end-word", withSelection);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadTextArea textArea = this.getTextArea(e);
                if (textArea != null) {
                    int offs;
                    String delimiters = textArea.getDelimiters();
                    int iOffs = offs = textArea.getCaretPosition();
                    String text = textArea.getDocument().getText(iOffs, textArea.getDocument().getLength() - iOffs);
                    while (offs - iOffs < text.length() - 1) {
                        char ch;
                        if (delimiters.indexOf(ch = text.charAt(++offs - iOffs)) >= 0 || Character.isWhitespace(ch)) break;
                    }
                    this.moveCaret(textArea, offs);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class HighlightAllOccurrencesAction
    extends JNPadTextAction {
        private static final long serialVersionUID = -5846207806975730585L;

        HighlightAllOccurrencesAction() {
            super(JNPadTextActions.ACTION_NAME_HIGHLIGHT_ALL_OCCURRENCES);
            this.setEnabled(Config.OCCURRENCES_HIGHLIGHTER_VISIBLE.getValue());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                EditPane editPane = jNPad.getActiveEditPane();
                if (editPane != null) {
                    String selectedText;
                    JNPadTextArea textArea = editPane.getTextArea();
                    if (textArea.hasSelection()) {
                        selectedText = textArea.getSelectedText();
                    } else {
                        Document doc = textArea.getDocument();
                        selectedText = TextUtilities.getSingleWordAt(doc, textArea.getCaretPosition(), textArea.getDelimiters());
                    }
                    if (selectedText != null) {
                        editPane.highlightAllOccurrences(new SearchContext(selectedText));
                    } else {
                        editPane.clearAllOccurrences();
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class IncreaseFontAction
    extends JNPadTextAction {
        private static final long serialVersionUID = 6321699285684527213L;

        IncreaseFontAction() {
            super(JNPadTextActions.ACTION_NAME_INCREASE_FONT);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JTextComponent target = this.getTextComponent(e);
                if (target != null) {
                    Font font = target.getFont();
                    Font newFont = font.deriveFont((float)(font.getSize() + 1));
                    JNPadFrame jNPad = this.getJNPadParent(e);
                    Buffer buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.setEditorFont(newFont);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class InsertBreakAction
    extends JNPadTextAction {
        private static final long serialVersionUID = -3288060714579447443L;

        InsertBreakAction() {
            super("insert-break");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            block26: {
                buffer = null;
                try {
                    jNPad = this.getJNPadParent(e);
                    buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.beginCompoundEdit();
                    }
                    if ((textArea = this.getTextArea(e)) == null) lbl-1000:
                    // 2 sources

                    {
                        return;
                    }
                    if (!textArea.isEditable() || !textArea.isEnabled()) {
                        UIManager.getLookAndFeel().provideErrorFeedback(textArea);
                        ** continue;
                    }
                    if (!textArea.getAutoIndent()) ** GOTO lbl71
                    selectionStart = textArea.getSelectionStart();
                    selectionEnd = textArea.getSelectionEnd();
                    if (selectionEnd == 0) {
                        textArea.replaceSelection("\n");
                        return;
                    }
                    doc = textArea.getDocument();
                    lineElem = TextUtilities.getLine(doc, TextUtilities.getLineNumber(doc, selectionStart));
                    startOffset = lineElem.getStartOffset();
                    length = selectionStart - startOffset;
                    if (length == 0) {
                        textArea.replaceSelection("\n");
                        return;
                    }
                    try {
                        try {
                            lineHead = new Segment();
                            doc.getText(startOffset, length, lineHead);
                            spaces = new StringBuilder();
                            i = lineHead.offset;
                            while (i < lineHead.offset + lineHead.count) {
                                if (lineHead.array[i] == ' ') {
                                    spaces.append(" ");
                                } else {
                                    if (lineHead.array[i] != '\t') break;
                                    spaces.append("\t");
                                }
                                ++i;
                            }
                            lastChar = doc.getText(selectionEnd - 1, 1);
                            nextChar = null;
                            try {
                                nextChar = doc.getText(selectionEnd, 1);
                            }
                            catch (StringIndexOutOfBoundsException strexc) {
                                JNPadTextActions.access$0().log(Level.FINE, strexc.getMessage(), strexc);
                            }
                            _spaces_ = spaces.toString();
                            _open_bracket_ = false;
                            if (Scheme.hasCLikeSyntax(textArea.getContentType()) && Config.TEXT_AUTO_CLOSE_BRACKETS.getValue().booleanValue() && lastChar.equals("{") && (nextChar == null || !nextChar.equals("}"))) {
                                if (textArea.getUseTabs()) {
                                    spaces.append("\t");
                                } else {
                                    spaces.append(Utilities.spaces(textArea.getTabSize()));
                                }
                                _open_bracket_ = lastChar.equals("{");
                            }
                            textArea.replaceSelection("\n" + spaces);
                            _position_ = selectionStart + spaces.length() + 1;
                            textArea.setCaretPosition(_position_);
                            if (_open_bracket_) {
                                textArea.insert("\n" + _spaces_ + "}", _position_);
                                textArea.setCaretPosition(_position_);
                            }
                            break block26;
                        }
                        catch (Exception ex) {
                            JNPadTextActions.access$0().log(Level.WARNING, ex.getMessage(), ex);
                            textArea.replaceSelection("\n");
                        }
                        break block26;
lbl71:
                        // 1 sources

                        textArea.replaceSelection("\n");
                    }
                    catch (Exception ex) {
                        JNPadTextActions.access$0().log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
                finally {
                    if (buffer != null) {
                        buffer.endCompoundEdit();
                    }
                }
            }
        }
    }

    private static abstract class JNPadTextActionWithOrWithoutSelection
    extends JNPadTextAction {
        private boolean withSelection;
        private static final long serialVersionUID = -2473760499325530848L;

        protected JNPadTextActionWithOrWithoutSelection(String actionName, boolean withSelection) {
            super(actionName);
            this.withSelection = withSelection;
        }

        protected void moveCaret(JTextComponent c, int pos) {
            if (this.withSelection) {
                c.getCaret().moveDot(pos);
            } else {
                c.setCaretPosition(pos);
            }
        }
    }

    class LeftIndentAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = -6088245184514079552L;

        LeftIndentAction() {
            super(JNPadTextActions.ACTION_NAME_LEFT_INDENT);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Buffer buffer = null;
            try {
                try {
                    JNPadTextArea textArea;
                    JNPadFrame jNPad = this.getJNPadParent(e);
                    buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.beginCompoundEdit();
                    }
                    if ((textArea = this.getTextArea(e)) != null) {
                        if (textArea.getUseTabs()) {
                            if (textArea.hasSelection()) {
                                TextUtilities.unindentLines(textArea.getDocument(), textArea.getSelectionStart(), textArea.getSelectionEnd());
                            } else {
                                JNPadTextActions.this.get("delete-previous").actionPerformed(e);
                            }
                        } else {
                            int tabSize = textArea.getTabSize();
                            if (textArea.hasSelection()) {
                                TextUtilities.unindentLines(textArea.getDocument(), textArea.getSelectionStart(), textArea.getSelectionEnd(), tabSize);
                            } else {
                                int i = 0;
                                while (i < tabSize) {
                                    JNPadTextActions.this.get("delete-previous").actionPerformed(e);
                                    ++i;
                                }
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    if (buffer != null) {
                        buffer.endCompoundEdit();
                    }
                }
            }
            finally {
                if (buffer != null) {
                    buffer.endCompoundEdit();
                }
            }
        }
    }

    static class NextOccurrenceAction
    extends JNPadTextAction {
        private static final long serialVersionUID = 8266484094729197897L;

        NextOccurrenceAction() {
            super(JNPadTextActions.ACTION_NAME_NEXT_OCCURRENCE);
            this.setEnabled(Config.OCCURRENCES_HIGHLIGHTER_VISIBLE.getValue());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                EditPane editPane = jNPad.getActiveEditPane();
                if (editPane != null) {
                    editPane.nextOccurrence();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class NextWordAction
    extends JNPadTextActionWithOrWithoutSelection {
        private static final long serialVersionUID = -5804423781790119209L;

        NextWordAction(boolean withSelection) {
            super(withSelection ? "selection-next-word" : "caret-next-word", withSelection);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadTextArea textArea = this.getTextArea(e);
                if (textArea != null) {
                    int offs;
                    String delimiters = textArea.getDelimiters();
                    int iOffs = offs = textArea.getCaretPosition();
                    String text = textArea.getDocument().getText(iOffs, textArea.getDocument().getLength() - iOffs);
                    int len = text.length();
                    while (offs - iOffs < len) {
                        if (++offs - iOffs == len) break;
                        char ch = text.charAt(offs - iOffs);
                        char chPrev = text.charAt(offs - iOffs - 1);
                        if (delimiters.indexOf(ch) >= 0 || delimiters.indexOf(chPrev) >= 0 || Character.isWhitespace(chPrev) || ch == '\n') {
                            while (offs - iOffs < len && Character.isWhitespace(ch) && ch != '\n') {
                                if (delimiters.indexOf(chPrev) >= 0) break;
                                ch = text.charAt(++offs - iOffs);
                            }
                            if (ch != '\n' || !Character.isWhitespace(text.charAt(offs - iOffs - 1))) break;
                            continue;
                        }
                        if (Character.isWhitespace(chPrev) || !Character.isWhitespace(ch)) continue;
                        int offs0 = offs;
                        while (offs - iOffs < len - 1 && ch != '\n' && Character.isWhitespace(ch)) {
                            ch = text.charAt(++offs - iOffs);
                            chPrev = text.charAt(offs - iOffs - 1);
                        }
                        offs = offs0;
                        if (ch == '\n') break;
                    }
                    this.moveCaret(textArea, offs);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class NumLockAction
    extends JNPadTextAction {
        private static final long serialVersionUID = 792328569197293370L;

        NumLockAction() {
            super(JNPadTextActions.ACTION_NAME_NUM_LOCK);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                try {
                    jNPad.getStatusBar().setNumLockIndicatorEnabled(jNPad.getToolkit().getLockingKeyState(144));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class PreviousOccurrenceAction
    extends JNPadTextAction {
        private static final long serialVersionUID = 3843284508521172572L;

        PreviousOccurrenceAction() {
            super(JNPadTextActions.ACTION_NAME_PREVIOUS_OCCURRENCE);
            this.setEnabled(Config.OCCURRENCES_HIGHLIGHTER_VISIBLE.getValue());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                EditPane editPane = jNPad.getActiveEditPane();
                if (editPane != null) {
                    editPane.previousOccurrence();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class PreviousWordAction
    extends JNPadTextActionWithOrWithoutSelection {
        private static final long serialVersionUID = -5804423781790119209L;

        PreviousWordAction(boolean withSelection) {
            super(withSelection ? "selection-previous-word" : "caret-previous-word", withSelection);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadTextArea textArea = this.getTextArea(e);
                if (textArea != null) {
                    String delimiters = textArea.getDelimiters();
                    int offs = textArea.getCaretPosition();
                    String text = textArea.getDocument().getText(0, offs);
                    while (offs > 0) {
                        char ch = text.charAt(--offs);
                        char chPrev = text.charAt(offs - 1);
                        if (Character.isWhitespace(ch) && Character.isWhitespace(chPrev) && ch != '\n') continue;
                        if (delimiters.indexOf(ch) >= 0 || delimiters.indexOf(chPrev) >= 0 || offs >= 2 && Character.isWhitespace(chPrev) && !Character.isWhitespace(text.charAt(offs - 2)) && ch != '\n' || Character.isWhitespace(chPrev) && !Character.isWhitespace(ch) || !Character.isWhitespace(chPrev) && ch == '\n') break;
                        if (!Character.isWhitespace(chPrev) || ch != '\n') continue;
                        while (Character.isWhitespace(chPrev) && offs > 0) {
                            ch = text.charAt(--offs);
                            chPrev = text.charAt(offs - 1);
                        }
                        break block2;
                    }
                    this.moveCaret(textArea, offs);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class RedoAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = -8402376403958102330L;

        RedoAction() {
            super(JNPadTextActions.ACTION_NAME_REDO);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                Buffer buffer = jNPad.getActiveBuffer();
                try {
                    try {
                        if (buffer != null && buffer.canRedo()) {
                            buffer.redo();
                        }
                    }
                    catch (CannotRedoException ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                        jNPad.updateControls(5);
                    }
                }
                finally {
                    jNPad.updateControls(5);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    class RightIndentAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = -6949965516937583077L;

        RightIndentAction() {
            super(JNPadTextActions.ACTION_NAME_RIGHT_INDENT);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block12: {
                Buffer buffer = null;
                try {
                    try {
                        JNPadTextArea textArea;
                        JNPadFrame jNPad = this.getJNPadParent(e);
                        buffer = jNPad.getActiveBuffer();
                        if (buffer != null) {
                            buffer.beginCompoundEdit();
                        }
                        if ((textArea = this.getTextArea(e)) == null) break block12;
                        if (textArea.getUseTabs()) {
                            if (textArea.hasSelection()) {
                                TextUtilities.indentLines(textArea.getDocument(), textArea.getSelectionStart(), textArea.getSelectionEnd());
                            } else {
                                JNPadTextActions.this.get("insert-tab").actionPerformed(e);
                            }
                            break block12;
                        }
                        int tabSize = textArea.getTabSize();
                        if (textArea.hasSelection()) {
                            TextUtilities.indentLines(textArea.getDocument(), textArea.getSelectionStart(), textArea.getSelectionEnd(), tabSize);
                            break block12;
                        }
                        textArea.insert(Utilities.spaces(tabSize), textArea.getCaretPosition());
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                        if (buffer != null) {
                            buffer.endCompoundEdit();
                        }
                    }
                }
                finally {
                    if (buffer != null) {
                        buffer.endCompoundEdit();
                    }
                }
            }
        }
    }

    static class SelectWordAction
    extends JNPadTextAction {
        private static final long serialVersionUID = 3927036646628861226L;

        SelectWordAction() {
            super("select-word");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadTextArea textArea = this.getTextArea(e);
                if (textArea != null) {
                    String delimiters = textArea.getDelimiters();
                    int origPos = textArea.getCaret().getDot();
                    int[] range = TextUtilities.getWordBoundsAt(textArea.getDocument(), origPos, delimiters);
                    if (range == null) {
                        return;
                    }
                    textArea.getCaret().setDot(range[0]);
                    textArea.getCaret().moveDot(range[1]);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                BeginWordAction start = new BeginWordAction(false);
                EndWordAction end = new EndWordAction(true);
                start.actionPerformed(e);
                end.actionPerformed(e);
            }
        }
    }

    static class SpacesToTabsAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = 3713190328770441006L;

        SpacesToTabsAction() {
            super(JNPadTextActions.ACTION_NAME_SPACES_TO_TABS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Buffer buffer = null;
            try {
                try {
                    JNPadTextArea textArea;
                    JNPadFrame jNPad = this.getJNPadParent(e);
                    buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.beginCompoundEdit();
                    }
                    if ((textArea = this.getTextArea(e)) != null) {
                        Document doc = textArea.getDocument();
                        Element map = doc.getDefaultRootElement();
                        int count = map.getElementCount();
                        int tabSize = textArea.getTabSize();
                        int i = 0;
                        while (i < count) {
                            Element lineElement = map.getElement(i);
                            int start = lineElement.getStartOffset();
                            int end = lineElement.getEndOffset() - 1;
                            String text = TextUtilities.doSpacesToTabs(TextUtilities.getText(doc, start, end -= start), tabSize);
                            doc.remove(start, end);
                            doc.insertString(start, text, null);
                            ++i;
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    if (buffer != null) {
                        buffer.endCompoundEdit();
                    }
                }
            }
            finally {
                if (buffer != null) {
                    buffer.endCompoundEdit();
                }
            }
        }
    }

    static class TabsToSpacesAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = -2351345392416101941L;

        TabsToSpacesAction() {
            super(JNPadTextActions.ACTION_NAME_TABS_TO_SPACES);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Buffer buffer = null;
            try {
                try {
                    JNPadTextArea textArea;
                    JNPadFrame jNPad = this.getJNPadParent(e);
                    buffer = jNPad.getActiveBuffer();
                    if (buffer != null) {
                        buffer.beginCompoundEdit();
                    }
                    if ((textArea = this.getTextArea(e)) != null) {
                        Document doc = textArea.getDocument();
                        Element map = doc.getDefaultRootElement();
                        int count = map.getElementCount();
                        int tabSize = textArea.getTabSize();
                        int i = 0;
                        while (i < count) {
                            Element lineElement = map.getElement(i);
                            int start = lineElement.getStartOffset();
                            int end = lineElement.getEndOffset() - 1;
                            String text = TextUtilities.doTabsToSpaces(TextUtilities.getText(doc, start, end -= start), tabSize);
                            doc.remove(start, end);
                            doc.insertString(start, text, null);
                            ++i;
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    if (buffer != null) {
                        buffer.endCompoundEdit();
                    }
                }
            }
            finally {
                if (buffer != null) {
                    buffer.endCompoundEdit();
                }
            }
        }
    }

    static class ToggleTextModeAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = 1561152749491506327L;

        ToggleTextModeAction() {
            super(JNPadTextActions.ACTION_NAME_TOGGLE_TEXT_MODE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                JNPadTextArea textArea = jNPad.getActiveTextArea();
                if (textArea != null) {
                    boolean b = !textArea.isOverwriteTextMode();
                    textArea.setOverwriteTextMode(b);
                    jNPad.getStatusBar().setAsOverwriteTextMode(b);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    static class UndoAction
    extends JNPadTextAction
    implements IEditAction {
        private static final long serialVersionUID = 1413908501994140495L;

        UndoAction() {
            super(JNPadTextActions.ACTION_NAME_UNDO);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JNPadFrame jNPad = this.getJNPadParent(e);
                Buffer buffer = jNPad.getActiveBuffer();
                try {
                    try {
                        if (buffer != null && buffer.canUndo()) {
                            buffer.undo();
                        }
                    }
                    catch (CannotRedoException ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                        jNPad.updateControls(5);
                    }
                }
                finally {
                    jNPad.updateControls(5);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

