/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import jnpad.config.Config;
import jnpad.text.Scheme;
import jnpad.text.TextUtilities;
import jnpad.util.UnexpectedException;
import jnpad.util.Utilities;

public class JNPadDocument
extends PlainDocument {
    public static final String useTabsAttribute = "JNPadDocument.useTabs";
    public static final String autoIndentAttribute = "JNPadDocument.autoIndent";
    public static final String delimitersAttribute = "JNPadDocument.delimitersTabs";
    private Scheme _scheme;
    private Scheme _mscheme;
    private DocumentListener _handler;
    private static final Logger LOGGER = Logger.getLogger(JNPadDocument.class.getName());
    private static final long serialVersionUID = 8537681881189609777L;
    public static final Object START_COMMENT = new AttributeKey("CommentStart");
    public static final Object END_COMMENT = new AttributeKey("CommentEnd");
    public static final Object MULTILINE_COMMENT = new AttributeKey("MultilineComment");
    public static final Object JAVADOC = new AttributeKey("Javadoc");

    public JNPadDocument() {
        super(new JNPadGapContent());
        this.putProperty("__EndOfLine__", "\n");
        this.putProperty("tabSize", Config.TEXT_TAB_SIZE.getValue());
        this.putProperty(autoIndentAttribute, Config.TEXT_AUTO_INDENT.getValue());
        this.putProperty(delimitersAttribute, Config.TEXT_DELIMITERS.getValue());
    }

    public Scheme getScheme() {
        return this._scheme;
    }

    public Scheme getMiniScheme() {
        return this._mscheme;
    }

    public String getContentType() {
        return this._scheme != null ? this._scheme.getContentType() : "text/plain";
    }

    public void setContentType(String type) {
        this._scheme = Scheme.getScheme(Utilities.defaultString(type, "text/plain"), false);
        this._mscheme = Scheme.getScheme(Utilities.defaultString(type, "text/plain"), true);
        if (Scheme.hasCLikeSyntax(type)) {
            if (this._handler == null) {
                this._handler = new DocumentHandler();
            }
            this.addDocumentListener(this._handler);
        } else if (this._handler != null) {
            this.removeDocumentListener(this._handler);
        }
    }

    public void clear() throws UnexpectedException {
        try {
            this.remove(0, this.getLength());
        }
        catch (BadLocationException ex) {
            throw new UnexpectedException(ex);
        }
    }

    public String getText() throws UnexpectedException {
        try {
            return this.getText(0, this.getLength());
        }
        catch (Exception ex) {
            throw new UnexpectedException(ex);
        }
    }

    public String getLineText(int line) throws BadLocationException {
        this.checkLine(line);
        return TextUtilities.getTextOfLine(this, line);
    }

    public String getLineTextOfOffset(int offset) throws BadLocationException {
        this.checkOffset(offset);
        return TextUtilities.getTextOfLineAtPosition(this, offset);
    }

    public String getLineTextOfOffsetOnlyUpToPos(int offset) throws BadLocationException {
        this.checkOffset(offset);
        return TextUtilities.getTextOfLineAtPosition_onlyUpToPos(this, offset);
    }

    public int getLineNumber(int offset) throws BadLocationException {
        this.checkOffset(offset);
        return TextUtilities.getLineNumber(this, offset);
    }

    public Element getLine(int line) throws BadLocationException {
        this.checkLine(line);
        return TextUtilities.getLine(this, line);
    }

    public int getLineCount() {
        Element map = this.getDefaultRootElement();
        return map.getElementCount();
    }

    private void checkOffset(int offset) throws BadLocationException {
        if (offset < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (offset > this.getLength()) {
            throw new BadLocationException("Can't translate offset to line", this.getLength() + 1);
        }
    }

    private void checkLine(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getLength() + 1);
        }
    }

    public char charAt(int offset) throws BadLocationException {
        return ((JNPadGapContent)this.getContent()).charAt(offset);
    }

    @Override
    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent ev, AttributeSet att) {
        super.insertUpdate(ev, att);
    }

    @Override
    protected void postRemoveUpdate(AbstractDocument.DefaultDocumentEvent ev) {
        super.postRemoveUpdate(ev);
    }

    private void _insertUpdate(DocumentEvent ev) {
        int length;
        int startOffset;
        DocumentEvent.ElementChange change = ev.getChange(this.getDefaultRootElement());
        if (change == null) {
            startOffset = ev.getOffset();
            length = ev.getLength();
        } else {
            Element[] elements = change.getChildrenAdded();
            startOffset = elements[0].getStartOffset();
            length = elements[elements.length - 1].getEndOffset() - elements[0].getStartOffset();
        }
        try {
            this.checkTextToComment(startOffset, length);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void _postRemoveUpdate(DocumentEvent ev) {
        try {
            this.checkTextToComment(ev.getOffset(), ev.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkTextToComment(int offset, int len) throws BadLocationException {
        Element root = this.getDefaultRootElement();
        int firstParagraph = root.getElementIndex(offset);
        int lastParagraph = root.getElementIndex(offset + len);
        boolean inComment = this.getCommentStatus(firstParagraph);
        if (this.getContentType() == "text/java") {
            boolean inJavadoc = this.getJavadocStatus(firstParagraph);
            int i = firstParagraph;
            while (i <= lastParagraph) {
                boolean[] r = this.checkTextToCommentAndJavadoc(root.getElement(i), inComment, inJavadoc);
                inComment = r[0];
                inJavadoc = r[1];
                ++i;
            }
            if (inJavadoc) {
                this.javadocFollowingText(lastParagraph + 1);
            } else {
                this.unjavadocFollowingText(lastParagraph + 1);
            }
        } else {
            int i = firstParagraph;
            while (i <= lastParagraph) {
                inComment = this.checkTextToComment(root.getElement(i), inComment);
                ++i;
            }
        }
        if (inComment) {
            this.commentFollowingText(lastParagraph + 1);
        } else {
            this.uncommentFollowingText(lastParagraph + 1);
        }
    }

    private boolean getCommentStatus(int paragraphNumber) {
        if (paragraphNumber > 0) {
            Element previousElement = this.getDefaultRootElement().getElement(paragraphNumber - 1);
            return JNPadDocument.containsMultilineCommentAttribute(previousElement);
        }
        return false;
    }

    private boolean getJavadocStatus(int paragraphNumber) {
        if (paragraphNumber > 0) {
            Element previousElement = this.getDefaultRootElement().getElement(paragraphNumber - 1);
            return JNPadDocument.containsJavadocAttribute(previousElement);
        }
        return false;
    }

    private void commentFollowingText(int startParagraph) {
        int lastParagraphToScan = this.getDefaultRootElement().getElementCount();
        int i = startParagraph;
        while (i < lastParagraphToScan) {
            if (JNPadDocument.containsEndComment(this.getDefaultRootElement().getElement(i))) {
                Element e = this.getDefaultRootElement().getElement(i);
                this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, e.getStartOffset(), e.getEndOffset() - e.getStartOffset(), DocumentEvent.EventType.CHANGE));
                break;
            }
            this.addMultilineCommentAttribute(this.getDefaultRootElement().getElement(i));
            ++i;
        }
    }

    private void javadocFollowingText(int startParagraph) {
        int lastParagraphToScan = this.getDefaultRootElement().getElementCount();
        int i = startParagraph;
        while (i < lastParagraphToScan) {
            if (JNPadDocument.containsEndComment(this.getDefaultRootElement().getElement(i))) {
                Element e = this.getDefaultRootElement().getElement(i);
                this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, e.getStartOffset(), e.getEndOffset() - e.getStartOffset(), DocumentEvent.EventType.CHANGE));
                break;
            }
            this.addJavadocAttribute(this.getDefaultRootElement().getElement(i));
            ++i;
        }
    }

    private void uncommentFollowingText(int startParagraph) {
        int lastParagraphToScan = this.getDefaultRootElement().getElementCount();
        int i = startParagraph;
        while (i < lastParagraphToScan) {
            if (!JNPadDocument.containsMultilineCommentAttribute(this.getDefaultRootElement().getElement(i)) || JNPadDocument.containsStartComment(this.getDefaultRootElement().getElement(i))) {
                Element e = this.getDefaultRootElement().getElement(i);
                this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, e.getStartOffset(), e.getEndOffset() - e.getStartOffset(), DocumentEvent.EventType.CHANGE));
                break;
            }
            this.removeMultilineCommentAttribute(this.getDefaultRootElement().getElement(i));
            ++i;
        }
    }

    private void unjavadocFollowingText(int startParagraph) {
        int lastParagraphToScan = this.getDefaultRootElement().getElementCount();
        int i = startParagraph;
        while (i < lastParagraphToScan) {
            if (!JNPadDocument.containsJavadocAttribute(this.getDefaultRootElement().getElement(i)) || JNPadDocument.containsStartComment(this.getDefaultRootElement().getElement(i))) {
                Element e = this.getDefaultRootElement().getElement(i);
                this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, e.getStartOffset(), e.getEndOffset() - e.getStartOffset(), DocumentEvent.EventType.CHANGE));
                break;
            }
            this.removeJavadocAttribute(this.getDefaultRootElement().getElement(i));
            ++i;
        }
    }

    private boolean checkTextToComment(Element paragraph, boolean inComment) throws BadLocationException {
        int startPosition = paragraph.getStartOffset();
        int length = (paragraph.getEndOffset() < this.getLength() ? paragraph.getEndOffset() : this.getLength()) - startPosition;
        Segment content = new Segment();
        this.getText(startPosition, length, content);
        boolean slashFound = false;
        boolean starFound = false;
        boolean commentStartFound = false;
        boolean commentEndFound = false;
        boolean stringLiteral = false;
        boolean charLiteral = false;
        int wordIndex = 0;
        while (wordIndex < content.length()) {
            char indexedChar = content.charAt(wordIndex);
            if (!inComment && slashFound && indexedChar == '/') break;
            if (!inComment && indexedChar == '\"') {
                stringLiteral = !stringLiteral;
            } else if (!inComment && indexedChar == '\'') {
                charLiteral = !charLiteral;
            } else if (!(starFound || stringLiteral || charLiteral || indexedChar != '/')) {
                slashFound = true;
            } else if (!(slashFound || stringLiteral || charLiteral || indexedChar != '*')) {
                starFound = true;
            } else if (starFound && !stringLiteral && !charLiteral && indexedChar == '/') {
                inComment = false;
                commentEndFound = true;
                starFound = false;
            } else if (slashFound && !stringLiteral && !charLiteral && indexedChar == '*') {
                inComment = true;
                commentStartFound = true;
                slashFound = false;
            } else {
                starFound = false;
                slashFound = false;
            }
            ++wordIndex;
        }
        if (inComment) {
            this.addMultilineCommentAttribute(paragraph);
        } else {
            this.removeMultilineCommentAttribute(paragraph);
        }
        if (commentStartFound) {
            this.addStartComment(paragraph);
        } else {
            this.removeStartComment(paragraph);
        }
        if (commentEndFound) {
            this.addEndComment(paragraph);
        } else {
            this.removeEndComment(paragraph);
        }
        return inComment;
    }

    private boolean[] checkTextToCommentAndJavadoc(Element paragraph, boolean inComment, boolean inJavadoc) throws BadLocationException {
        int startPosition = paragraph.getStartOffset();
        int length = (paragraph.getEndOffset() < this.getLength() ? paragraph.getEndOffset() : this.getLength()) - startPosition;
        Segment content = new Segment();
        this.getText(startPosition, length, content);
        boolean slashFound = false;
        boolean starFound = false;
        boolean commentStartFound = false;
        boolean commentEndFound = false;
        boolean stringLiteral = false;
        boolean charLiteral = false;
        int wordIndex = 0;
        while (wordIndex < content.length()) {
            char indexedChar = content.charAt(wordIndex);
            if (!inComment && !inJavadoc && slashFound && indexedChar == '/') break;
            if (!inComment && !inJavadoc && indexedChar == '\"') {
                stringLiteral = !stringLiteral;
            } else if (!inComment && !inJavadoc && indexedChar == '\'') {
                charLiteral = !charLiteral;
            } else if (!(starFound || stringLiteral || charLiteral || indexedChar != '/')) {
                slashFound = true;
            } else if (!(slashFound || stringLiteral || charLiteral || indexedChar != '*')) {
                starFound = true;
            } else if (starFound && !stringLiteral && !charLiteral && indexedChar == '/') {
                inComment = false;
                inJavadoc = false;
                commentEndFound = true;
                starFound = false;
            } else if (slashFound && !stringLiteral && !charLiteral && indexedChar == '*') {
                if (wordIndex + 1 < content.length() && content.charAt(wordIndex + 1) == '*') {
                    inJavadoc = true;
                } else {
                    inComment = true;
                }
                commentStartFound = true;
                slashFound = false;
            } else {
                starFound = false;
                slashFound = false;
            }
            ++wordIndex;
        }
        if (inComment) {
            this.addMultilineCommentAttribute(paragraph);
        } else {
            this.removeMultilineCommentAttribute(paragraph);
        }
        if (commentStartFound) {
            this.addStartComment(paragraph);
        } else {
            this.removeStartComment(paragraph);
        }
        if (commentEndFound) {
            this.addEndComment(paragraph);
        } else {
            this.removeEndComment(paragraph);
        }
        if (inJavadoc) {
            this.addJavadocAttribute(paragraph);
        } else {
            this.removeJavadocAttribute(paragraph);
        }
        return new boolean[]{inComment, inJavadoc};
    }

    private static boolean containsStartComment(Element e) {
        return e.getAttributes().containsAttribute(START_COMMENT, START_COMMENT);
    }

    private static boolean containsMultilineCommentAttribute(Element e) {
        return e.getAttributes().containsAttribute(MULTILINE_COMMENT, MULTILINE_COMMENT);
    }

    private static boolean containsJavadocAttribute(Element e) {
        return e.getAttributes().containsAttribute(JAVADOC, JAVADOC);
    }

    private static boolean containsEndComment(Element e) {
        return e.getAttributes().containsAttribute(END_COMMENT, END_COMMENT);
    }

    private void addStartComment(Element e) {
        this.addAttribute(e, START_COMMENT, START_COMMENT);
    }

    private void removeStartComment(Element e) {
        this.removeAttribute(e, START_COMMENT);
    }

    private void addMultilineCommentAttribute(Element e) {
        this.addAttribute(e, MULTILINE_COMMENT, MULTILINE_COMMENT);
    }

    private void removeMultilineCommentAttribute(Element e) {
        this.removeAttribute(e, MULTILINE_COMMENT);
    }

    private void addJavadocAttribute(Element e) {
        this.addAttribute(e, JAVADOC, JAVADOC);
    }

    private void removeJavadocAttribute(Element e) {
        this.removeAttribute(e, JAVADOC);
    }

    private void addEndComment(Element e) {
        this.addAttribute(e, END_COMMENT, END_COMMENT);
    }

    private void removeEndComment(Element e) {
        this.removeAttribute(e, END_COMMENT);
    }

    private void addAttribute(Element e, Object name, Object value) {
        ((MutableAttributeSet)e.getAttributes()).addAttribute(name, value);
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, e.getStartOffset(), e.getEndOffset() - e.getStartOffset(), DocumentEvent.EventType.CHANGE));
    }

    private void removeAttribute(Element e, Object name) {
        ((MutableAttributeSet)e.getAttributes()).removeAttribute(name);
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, e.getStartOffset(), e.getEndOffset() - e.getStartOffset(), DocumentEvent.EventType.CHANGE));
    }

    static class AttributeKey {
        private String attributeName;

        AttributeKey(String attributeName) {
            this.attributeName = attributeName;
        }

        public String toString() {
            return this.attributeName;
        }
    }

    class DocumentHandler
    implements DocumentListener,
    Serializable {
        private static final long serialVersionUID = 6446285225479775497L;

        DocumentHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JNPadDocument.this._insertUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JNPadDocument.this._postRemoveUpdate(e);
        }
    }

    private static class JNPadGapContent
    extends GapContent {
        private static final long serialVersionUID = -1699909757565203087L;

        private JNPadGapContent() {
        }

        public char charAt(int offset) throws BadLocationException {
            if (offset < 0 || offset >= this.length()) {
                throw new BadLocationException("Invalid offset", offset);
            }
            int g0 = this.getGapStart();
            char[] array = (char[])this.getArray();
            if (offset < g0) {
                return array[offset];
            }
            return array[this.getGapEnd() + offset - g0];
        }
    }
}

