/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.CannotUndoException;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.JNPadKeyboardHandler;
import jnpad.action.ActionManager;
import jnpad.config.Config;
import jnpad.text.BufferSet;
import jnpad.text.CompoundUndoManager;
import jnpad.text.EditPane;
import jnpad.text.IBuffer;
import jnpad.text.IView;
import jnpad.text.JNPadTextArea;
import jnpad.text.JNPadTransferHandler;
import jnpad.text.Viewer;
import jnpad.ui.JNPadSplitPane;
import jnpad.ui.status.IStatusBar;
import jnpad.ui.status.ITextStatusBar;
import jnpad.util.LineSeparator;
import jnpad.util.Utilities;

public final class Buffer
extends JPanel
implements IBuffer,
IView {
    public static final String PROPERTY_DIRTY = "Buffer.dirty";
    public static final String PROPERTY_READ_ONLY = "Buffer.readOnly";
    public static final String PROPERTY_LINE_SEPARATOR = "Buffer.lineSeparator";
    public static final String PROPERTY_ENCODING = "Buffer.encoding";
    private EditPane editPane;
    private JSplitPane splitPane;
    private Component mainContent;
    private JPanel mainPanel = new JPanel();
    private String filePath;
    private CompoundUndoManager undoManager;
    private LineSeparator lineSeparator = LineSeparator.getDefault();
    private String charSet = Config.FILE_ENCODING.getValue();
    private boolean readOnly;
    private boolean isDirty;
    private boolean isHandleValueChangedEnabled = true;
    private String initialSplitConfig;
    private String lastSplitConfig;
    private int lastIndex;
    private List<Integer> lastCaretPositions = new ArrayList<Integer>();
    BufferSet bufferSet;
    JNPadFrame jNPad;
    private static final Logger LOGGER = Logger.getLogger(Buffer.class.getName());
    private static final long serialVersionUID = 1104199986574484076L;

    public Buffer(BufferSet bufferSet, String filePath, String text) {
        super(new BorderLayout());
        try {
            this.bufferSet = bufferSet;
            this.jNPad = bufferSet.getViewer()._jNPad;
            this.filePath = Utilities.defaultString(filePath);
            this.undoManager = new CompoundUndoManager(this);
            this.setOpaque(false);
            this.mainPanel.setLayout(new BorderLayout());
            this.add((Component)this.mainPanel, "Center");
            this.setMainContent(this.createEditPane(text));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private Buffer(BufferSet bufferSet, Buffer oldBuffer) {
        super(new BorderLayout());
        try {
            this.bufferSet = bufferSet;
            this.jNPad = bufferSet.getViewer()._jNPad;
            this.filePath = oldBuffer.filePath;
            this.undoManager = oldBuffer.undoManager;
            this.isDirty = oldBuffer.isDirty;
            this.readOnly = oldBuffer.readOnly;
            this.lineSeparator = oldBuffer.lineSeparator;
            this.charSet = oldBuffer.charSet;
            this.setOpaque(false);
            this.mainPanel.setLayout(new BorderLayout());
            this.add((Component)this.mainPanel, "Center");
            this.setMainContent(this.createEditPane(oldBuffer.editPane));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    Buffer create(BufferSet bufferSet) {
        Buffer buffer = new Buffer(bufferSet, this);
        PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener l = propertyChangeListenerArray[n2];
            buffer.doAddPropertyChangeListener(l);
            ++n2;
        }
        return buffer;
    }

    private EditPane createEditPane(String text) {
        EditPane editPane = new EditPane(this, text);
        editPane.textArea.getDocument().addUndoableEditListener(this.undoManager);
        editPane.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Buffer.this.handleValueChanged(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Buffer.this.handleValueChanged(e);
            }
        });
        editPane.textArea.addFocusListener(new FocusHandler());
        editPane.textArea.setDragEnabled(true);
        editPane.textArea.setTransferHandler(new JNPadTransferHandler(this.jNPad));
        return editPane;
    }

    private EditPane createEditPane(EditPane oldEditPane) {
        EditPane editPane = new EditPane(this, oldEditPane);
        editPane.textArea.addFocusListener(new FocusHandler());
        editPane.textArea.setDragEnabled(true);
        editPane.textArea.setTransferHandler(new JNPadTransferHandler(this.jNPad));
        return editPane;
    }

    public void replace(int start, int end, String replaceFor) {
        this.beginCompoundEdit();
        this.editPane.textArea.select(start, end);
        this.editPane.textArea.replaceSelection(replaceFor);
        this.endCompoundEdit();
    }

    public void beginCompoundEdit() {
        this.undoManager.beginCompoundEdit();
    }

    public void endCompoundEdit() {
        this.undoManager.endCompoundEdit();
    }

    public boolean canUndo() {
        return this.undoManager.canUndo() && !this.isReadOnly();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo() && !this.isReadOnly();
    }

    public void undo() throws CannotUndoException {
        if (this.isReadOnly()) {
            return;
        }
        this.undoManager.undo();
        if (!this.undoManager.isModified()) {
            this.setDirty(false);
        }
    }

    public void redo() throws CannotUndoException {
        if (this.isReadOnly()) {
            return;
        }
        this.undoManager.redo();
    }

    public void setAsSaved() {
        this.setDirty(false);
        this.undoManager.documentSaved();
    }

    private void setSelectedEditPane(EditPane editPane) {
        this.editPane = editPane;
        editPane.updateControls(8191);
        this.repaintGutter();
    }

    void repaintGutter() {
        EditPane[] editPaneArray = this.getEditPanes();
        int n = editPaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane epane = editPaneArray[n2];
            epane.repaintGutter();
            ++n2;
        }
    }

    public JNPadTextArea getSelectedTextArea() {
        return this.editPane.getTextArea();
    }

    public JNPadTextArea[] getTextAreas() {
        EditPane[] epanes = this.getEditPanes();
        JNPadTextArea[] array = new JNPadTextArea[epanes.length];
        int i = 0;
        while (i < epanes.length) {
            array[i] = epanes[i].getTextArea();
            ++i;
        }
        return array;
    }

    public EditPane getSelectedEditPane() {
        return this.editPane;
    }

    public EditPane[] getEditPanes() {
        if (this.splitPane == null) {
            return new EditPane[]{this.editPane};
        }
        ArrayList<EditPane> list = new ArrayList<EditPane>();
        Buffer.lookForEditPanes(list, this.splitPane);
        EditPane[] array = new EditPane[list.size()];
        list.toArray(array);
        return array;
    }

    private static void lookForEditPanes(List<EditPane> list, Component comp) {
        if (comp instanceof EditPane) {
            list.add((EditPane)comp);
        } else if (comp instanceof JSplitPane) {
            JSplitPane split = (JSplitPane)comp;
            Buffer.lookForEditPanes(list, split.getLeftComponent());
            Buffer.lookForEditPanes(list, split.getRightComponent());
        }
    }

    void handleValueChanged(DocumentEvent e) {
        if (!this.isHandleValueChangedEnabled) {
            return;
        }
        this.setDirty(true);
        this.updateControls(4);
    }

    @Override
    public void configure(int cfg) {
        EditPane[] editPaneArray = this.getEditPanes();
        int n = editPaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane epane = editPaneArray[n2];
            epane.configure(cfg);
            ++n2;
        }
    }

    @Override
    public void updateControls() {
        this.updateControls(8191);
    }

    @Override
    public void updateControls(int ctrls) {
        if ((ctrls & 1) != 0 || (ctrls & 0x200) != 0) {
            ActionManager.INSTANCE.setEnabled("undo", this.canUndo());
            ActionManager.INSTANCE.setEnabled("redo", this.canRedo());
            EditPane[] editPaneArray = this.getEditPanes();
            int n = editPaneArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditPane epane = editPaneArray[n2];
                epane.actions.setUndoEnabled(this.canUndo());
                epane.actions.setRedoEnabled(this.canRedo());
                ++n2;
            }
        }
        if ((ctrls & 2) != 0) {
            boolean b = this.isSplitted();
            ActionManager.INSTANCE.setEnabled("unsplit", b);
            ActionManager.INSTANCE.setEnabled("unsplit-current", b);
            ActionManager.INSTANCE.setEnabled("next-edit-pane", b);
            ActionManager.INSTANCE.setEnabled("previous-edit-pane", b);
        }
        this.editPane.updateControls(ctrls);
    }

    public int getSelectedIndex() {
        EditPane[] epanes = this.getEditPanes();
        int i = 0;
        while (i < epanes.length) {
            if (this.editPane == epanes[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void nextEditPane() {
        EditPane[] epanes = this.getEditPanes();
        int index = this.getSelectedIndex();
        if (index > -1 && index < epanes.length - 1) {
            this.setSelectedEditPane(epanes[++index]);
            this.editPane.requestFocus();
        } else if (index == epanes.length - 1) {
            this.setSelectedEditPane(epanes[0]);
            this.editPane.requestFocus();
        }
    }

    public void previousEditPane() {
        EditPane[] epanes = this.getEditPanes();
        int index = this.getSelectedIndex();
        if (index > 0 && index < epanes.length) {
            this.setSelectedEditPane(epanes[--index]);
            this.editPane.requestFocus();
        } else if (index == 0) {
            this.setSelectedEditPane(epanes[epanes.length - 1]);
            this.editPane.requestFocus();
        }
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void setFilePath(String path) {
        this.filePath = Utilities.defaultString(path);
    }

    @Override
    public String getContentType() {
        return this.editPane.textArea.getContentType();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof IBuffer && this.filePath.equals(((IBuffer)obj).getFilePath());
    }

    @Override
    public int hashCode() {
        return this.filePath.hashCode();
    }

    @Override
    public void reload() throws IOException {
        String s;
        if (this.isNew()) {
            return;
        }
        String path = this.getFilePath();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));
        byte[] buffer = new byte[in.available()];
        in.read(buffer, 0, buffer.length);
        in.close();
        String encoding = this.getEncoding();
        try {
            s = new String(buffer, 0, buffer.length, encoding);
        }
        catch (Exception ex) {
            try {
                encoding = Config.FILE_ENCODING.getValue();
                s = new String(buffer, 0, buffer.length, encoding);
            }
            catch (Exception ex2) {
                encoding = (String)Config.FILE_ENCODING.getDefault();
                s = new String(buffer, 0, buffer.length, encoding);
            }
            this.setEncoding(encoding, false);
        }
        boolean removeEndSpaces = Config.REMOVE_END_SPACES.getValue();
        int tabSize = !this.getSelectedTextArea().getUseTabs() ? this.getSelectedTextArea().getTabSize() : -1;
        String result = GUIUtilities.convertString(s, removeEndSpaces, tabSize);
        int caretPosition = this.getCaretPosition();
        this.setText(result);
        try {
            this.getSelectedTextArea().setCaretPosition(caretPosition);
        }
        catch (Exception ex) {
            this.getSelectedTextArea().setCaretPosition(0);
        }
    }

    public void setText(String text) {
        this.editPane.setText(text);
        this.setDirty(true);
    }

    public String getText() {
        return this.editPane.getText();
    }

    @Override
    public boolean hasSelection() {
        return this.editPane.hasSelection();
    }

    @Override
    public int getCaretPosition() {
        return this.editPane.textArea.getCaretPosition();
    }

    @Override
    public boolean isLineWrapped() {
        return this.editPane.getLineWrap();
    }

    public boolean isNew() {
        return !new File(this.filePath).isFile();
    }

    public void setEditorFont(Font f) {
        EditPane[] editPaneArray = this.getEditPanes();
        int n = editPaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane epane = editPaneArray[n2];
            epane.setEditorFont(f);
            ++n2;
        }
    }

    @Override
    public void setLineWrap(boolean b) {
        EditPane[] editPaneArray = this.getEditPanes();
        int n = editPaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane epane = editPaneArray[n2];
            epane.setLineWrap(b);
            ++n2;
        }
    }

    public boolean getLineWrap() {
        return this.editPane.getLineWrap();
    }

    @Override
    public void setLineNumbersVisible(boolean b) {
        EditPane[] editPaneArray = this.getEditPanes();
        int n = editPaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane epane = editPaneArray[n2];
            epane.setLineNumbersVisible(b);
            ++n2;
        }
    }

    public boolean isLineNumbersVisible() {
        return this.editPane.isLineNumbersVisible();
    }

    public boolean isActiveLineVisible() {
        return this.editPane.isActiveLineVisible();
    }

    @Override
    public void setActiveLineVisible(boolean b) {
        EditPane[] editPaneArray = this.getEditPanes();
        int n = editPaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane epane = editPaneArray[n2];
            epane.setActiveLineVisible(b);
            ++n2;
        }
    }

    public boolean isOccurrencesHighlighterVisible() {
        return this.editPane.isOccurrencesHighlighterVisible();
    }

    @Override
    public void setOccurrencesHighlighterVisible(boolean b) {
        EditPane[] editPaneArray = this.getEditPanes();
        int n = editPaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane epane = editPaneArray[n2];
            epane.setOccurrencesHighlighterVisible(b);
            ++n2;
        }
    }

    public boolean isBracketHighlighterVisible() {
        return this.editPane.isBracketHighlighterVisible();
    }

    @Override
    public void setBracketHighlighterVisible(boolean b) {
        EditPane[] editPaneArray = this.getEditPanes();
        int n = editPaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane epane = editPaneArray[n2];
            epane.setBracketHighlighterVisible(b);
            ++n2;
        }
    }

    @Override
    public void setRightMarginLineVisible(boolean b) {
        EditPane[] editPaneArray = this.getEditPanes();
        int n = editPaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane epane = editPaneArray[n2];
            epane.setRightMarginLineVisible(b);
            ++n2;
        }
    }

    public boolean isRightMarginLineVisible() {
        return this.editPane.isRightMarginLineVisible();
    }

    @Override
    public void setMarkStripVisible(boolean b) {
        EditPane[] editPaneArray = this.getEditPanes();
        int n = editPaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane epane = editPaneArray[n2];
            epane.setMarkStripVisible(b);
            ++n2;
        }
    }

    public boolean isMarkStripVisible() {
        return this.editPane.isMarkStripVisible();
    }

    @Override
    public void requestFocus() {
        if (this.editPane != null) {
            this.editPane.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.editPane != null) {
            this.editPane.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    public boolean isReadOnly() {
        return !this.editPane.isEditable();
    }

    public void setReadOnly(boolean b) {
        if (this.readOnly == b) {
            return;
        }
        this.doSetReadOnly(b);
        BufferSet[] bufferSetArray = this.bufferSet.getViewer().getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            if (eviews != this.bufferSet) {
                for (Buffer eview : eviews) {
                    if (!this.equals(eview)) continue;
                    eview.doSetReadOnly(b);
                }
            }
            ++n2;
        }
        this.jNPad.requestFocus();
        this.requestFocus();
    }

    private void doSetReadOnly(boolean b) {
        if (this.readOnly != b) {
            this.readOnly = b;
            EditPane[] editPaneArray = this.getEditPanes();
            int n = editPaneArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditPane epane = editPaneArray[n2];
                epane.setEditable(!b);
                ++n2;
            }
            this.updateControls(512);
            this.firePropertyChange(PROPERTY_READ_ONLY, !b, b);
        }
    }

    public LineSeparator getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(LineSeparator lineSeparator) {
        this.setLineSeparator(lineSeparator, true);
    }

    public void setLineSeparator(LineSeparator lineSeparator, boolean setDirty) {
        if (this.lineSeparator == lineSeparator) {
            return;
        }
        this.doSetLineSeparator(lineSeparator, setDirty);
        BufferSet[] bufferSetArray = this.bufferSet.getViewer().getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            if (eviews != this.bufferSet) {
                for (Buffer eview : eviews) {
                    if (!this.equals(eview)) continue;
                    eview.doSetLineSeparator(lineSeparator, setDirty);
                }
            }
            ++n2;
        }
    }

    private void doSetLineSeparator(LineSeparator lineSeparator, boolean setDirty) {
        if (this.lineSeparator != lineSeparator) {
            LineSeparator old = this.lineSeparator;
            this.lineSeparator = lineSeparator;
            this.firePropertyChange(PROPERTY_LINE_SEPARATOR, (Object)old, (Object)lineSeparator);
            if (setDirty) {
                this.setDirty(true);
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean b) {
        if (this.isDirty == b) {
            return;
        }
        this.doSetDirty(b);
        BufferSet[] bufferSetArray = this.bufferSet.getViewer().getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            if (eviews != this.bufferSet) {
                for (Buffer eview : eviews) {
                    if (!this.equals(eview)) continue;
                    eview.doSetDirty(b);
                }
            }
            ++n2;
        }
    }

    private void doSetDirty(boolean b) {
        if (this.isDirty != b) {
            this.isDirty = b;
            this.firePropertyChange(PROPERTY_DIRTY, !b, b);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.doAddPropertyChangeListener(listener);
        if (this.bufferSet != null) {
            BufferSet[] bufferSetArray = this.bufferSet.getViewer().getBufferSets();
            int n = bufferSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                BufferSet eviews = bufferSetArray[n2];
                if (eviews != this.bufferSet) {
                    for (Buffer eview : eviews) {
                        if (!this.equals(eview)) continue;
                        eview.doAddPropertyChangeListener(listener);
                    }
                }
                ++n2;
            }
        }
    }

    private void doAddPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.doRemovePropertyChangeListener(listener);
        BufferSet[] bufferSetArray = this.bufferSet.getViewer().getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            if (eviews != this.bufferSet) {
                for (Buffer eview : eviews) {
                    if (!this.equals(eview)) continue;
                    eview.doRemovePropertyChangeListener(listener);
                }
            }
            ++n2;
        }
    }

    private void doRemovePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
    }

    public String getEncoding() {
        return this.charSet;
    }

    public void setEncoding(String encoding) throws UnsupportedCharsetException {
        this.setEncoding(encoding, true);
    }

    public void setEncoding(String encoding, boolean setDirty) throws UnsupportedCharsetException {
        if (!Charset.isSupported(encoding)) {
            throw new UnsupportedCharsetException(encoding);
        }
        if (this.charSet.equals(encoding)) {
            return;
        }
        String old = this.charSet;
        this.doSetEncoding(encoding, setDirty);
        BufferSet[] bufferSetArray = this.bufferSet.getViewer().getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            if (eviews != this.bufferSet) {
                for (Buffer eview : eviews) {
                    if (!this.equals(eview)) continue;
                    eview.doSetEncoding(encoding, setDirty);
                }
            }
            ++n2;
        }
        this.firePropertyChange(PROPERTY_ENCODING, old, encoding);
        if (setDirty) {
            this.setDirty(true);
        }
    }

    private void doSetEncoding(String encoding, boolean setDirty) {
        this.charSet = encoding;
    }

    IStatusBar getStatusBar() {
        return this.jNPad.getStatusBar();
    }

    void clearStatusMessageCharacter() {
        this.jNPad.getStatusBar().setMessage(ITextStatusBar.StatusMessage.CHARACTER, "");
    }

    JNPadKeyboardHandler getKeyboardHandler() {
        return this.jNPad.getKeyboardHandler();
    }

    KeyListener getKeyEventInterceptor() {
        return this.jNPad.getKeyEventInterceptor();
    }

    void setKeyEventInterceptor(KeyListener listener) {
        this.jNPad.setKeyEventInterceptor(listener);
    }

    public EditPane splitHorizontally() {
        return this.split(0);
    }

    public EditPane splitVertically() {
        return this.split(1);
    }

    public EditPane split(int orientation) {
        this.isHandleValueChangedEnabled = false;
        EditPane oldEditPane = this.editPane;
        EditPane newEditPane = this.createEditPane(oldEditPane);
        JComponent oldParent = (JComponent)oldEditPane.getParent();
        final JNPadSplitPane newSplitPane = new JNPadSplitPane(orientation);
        int parentSize = orientation == 0 ? oldEditPane.getHeight() : oldEditPane.getWidth();
        final int dividerPosition = (int)((double)(parentSize - newSplitPane.getDividerSize()) * 0.5);
        newSplitPane.setDividerLocation(dividerPosition);
        if (oldParent instanceof JSplitPane) {
            JSplitPane oldSplitPane = (JSplitPane)oldParent;
            int dividerPos = oldSplitPane.getDividerLocation();
            Component left = oldSplitPane.getLeftComponent();
            if (left == oldEditPane) {
                oldSplitPane.setLeftComponent(newSplitPane);
            } else {
                oldSplitPane.setRightComponent(newSplitPane);
            }
            newSplitPane.setLeftComponent(oldEditPane);
            newSplitPane.setRightComponent(newEditPane);
            oldSplitPane.setDividerLocation(dividerPos);
        } else {
            this.splitPane = newSplitPane;
            newSplitPane.setLeftComponent(oldEditPane);
            newSplitPane.setRightComponent(newEditPane);
            this.setMainContent(newSplitPane);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                newSplitPane.setDividerLocation(dividerPosition);
                Buffer.this.isHandleValueChangedEnabled = true;
            }
        });
        newEditPane.focusOnTextArea();
        newEditPane.refreshCaretPosition();
        return newEditPane;
    }

    public void unsplit() {
        if (this.splitPane != null) {
            this.saveLastConfig();
            this.setMainContent(this.editPane);
            this.splitPane = null;
            this.editPane.focusOnTextArea();
        } else {
            GUIUtilities.beep();
        }
    }

    public void unsplitCurrent() {
        if (this.splitPane != null) {
            JComponent parent;
            this.saveLastConfig();
            Container comp = this.editPane;
            while (!(comp instanceof JSplitPane) && comp != null) {
                comp = comp.getParent();
            }
            JComponent jComponent = parent = comp == null ? null : (JComponent)comp.getParent();
            if (parent instanceof JSplitPane) {
                JSplitPane parentSplit = (JSplitPane)parent;
                int pos = parentSplit.getDividerLocation();
                if (parentSplit.getLeftComponent() == comp) {
                    parentSplit.setLeftComponent(this.editPane);
                } else {
                    parentSplit.setRightComponent(this.editPane);
                }
                parentSplit.setDividerLocation(pos);
                parent.revalidate();
            } else {
                this.setMainContent(this.editPane);
                this.splitPane = null;
            }
            this.editPane.focusOnTextArea();
        } else {
            GUIUtilities.beep();
        }
    }

    public void restoreSplit() {
        if (this.lastSplitConfig == null) {
            GUIUtilities.beep();
        } else {
            this.setLastConfig();
        }
    }

    private void setMainContent(Component c) {
        if (this.mainContent != null) {
            this.mainPanel.remove(this.mainContent);
        }
        this.mainContent = c;
        this.mainPanel.add(this.mainContent, "Center");
        if (c instanceof JSplitPane) {
            this.splitPane = (JSplitPane)c;
        } else {
            this.splitPane = null;
            this.editPane = (EditPane)c;
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    public boolean isSplitted() {
        return this.splitPane != null;
    }

    private void saveLastConfig() {
        EditPane[] editPanes;
        this.lastSplitConfig = this.getSplitConfig();
        this.lastIndex = this.getSelectedIndex();
        this.lastCaretPositions.clear();
        EditPane[] editPaneArray = editPanes = this.getEditPanes();
        int n = editPanes.length;
        int n2 = 0;
        while (n2 < n) {
            EditPane editPane1 = editPaneArray[n2];
            this.lastCaretPositions.add(editPane1.getTextArea().getCaretPosition());
            ++n2;
        }
    }

    private void setLastConfig() {
        this.isHandleValueChangedEnabled = false;
        this.setSplitConfig(this.lastSplitConfig);
        try {
            this.getEditPanes()[this.lastIndex].focusOnTextArea();
            int i = 0;
            while (i < this.lastCaretPositions.size()) {
                try {
                    this.getEditPanes()[i].getTextArea().setCaretPosition(this.lastCaretPositions.get(i));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isHandleValueChangedEnabled = true;
    }

    public void setSplitConfig(String splitConfig) {
        try {
            Component comp = this.restoreSplitConfig(splitConfig);
            this.setMainContent(comp);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private Component restoreSplitConfig(String splitConfig) throws IOException {
        if (Utilities.isEmptyString(splitConfig)) {
            return this.editPane;
        }
        Stack<Serializable> stack = new Stack<Serializable>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(splitConfig));
        st.whitespaceChars(0, 32);
        st.wordChars(35, 126);
        st.commentChar(33);
        st.quoteChar(34);
        st.eolIsSignificant(false);
        block5: while (true) {
            switch (st.nextToken()) {
                case -1: {
                    break block5;
                }
                case -3: {
                    if (st.sval.equals("vertical") || st.sval.equals("horizontal")) {
                        int orientation = st.sval.equals("vertical") ? 0 : 1;
                        int divider = (Integer)stack.pop();
                        Object obj1 = stack.pop();
                        Object obj2 = stack.pop();
                        if (obj1 instanceof EditPane) {
                            EditPane b1 = (EditPane)obj1;
                            this.editPane = this.createEditPane(b1);
                            obj1 = this.editPane;
                        }
                        if (obj2 instanceof EditPane) {
                            EditPane b2 = (EditPane)obj2;
                            obj2 = this.createEditPane(b2);
                        }
                        this.splitPane = new JNPadSplitPane(orientation, (Component)obj1, (Component)obj2);
                        stack.push(this.splitPane);
                        this.splitPane.setDividerLocation(divider);
                        continue block5;
                    }
                    if (!st.sval.equals("EditPane")) continue block5;
                    stack.push(this.editPane);
                    continue block5;
                }
                case -2: {
                    stack.push(Integer.valueOf((int)st.nval));
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        Object obj = stack.peek();
        return (Component)obj;
    }

    public String getSplitConfig() {
        StringBuilder sb = new StringBuilder();
        if (this.splitPane != null) {
            Buffer.appendToSplitConfig(this.splitPane, sb);
        } else {
            Buffer.appendToSplitConfig(sb, this.editPane);
        }
        return sb.toString();
    }

    private static void appendToSplitConfig(JSplitPane splitPane, StringBuilder sb) {
        Component right = splitPane.getRightComponent();
        Buffer.appendToSplitConfig(sb, right);
        sb.append(' ');
        Component left = splitPane.getLeftComponent();
        Buffer.appendToSplitConfig(sb, left);
        sb.append(' ');
        sb.append(splitPane.getDividerLocation());
        sb.append(' ');
        sb.append(splitPane.getOrientation() == 0 ? "vertical" : "horizontal");
    }

    private static void appendToSplitConfig(StringBuilder sb, Component component) {
        if (component instanceof JSplitPane) {
            Buffer.appendToSplitConfig((JSplitPane)component, sb);
        } else {
            sb.append("EditPane");
        }
    }

    public String getInitialSplitConfig() {
        return this.initialSplitConfig;
    }

    public void setInitialSplitConfig(String initialSplitConfig) {
        this.initialSplitConfig = initialSplitConfig;
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Viewer eviewer;
            BufferSet eviews;
            Component comp = (Component)e.getSource();
            while (!(comp instanceof EditPane)) {
                if (comp == null) {
                    return;
                }
                comp = comp.getParent();
            }
            if (comp != Buffer.this.editPane) {
                Buffer.this.setSelectedEditPane((EditPane)comp);
            }
            if ((eviews = (eviewer = Buffer.this.bufferSet.getViewer()).getActiveBufferSet()) != Buffer.this.bufferSet) {
                eviewer.setActiveBufferSet(Buffer.this.bufferSet);
            }
        }
    }
}

