/*
 * Decompiled with CFR 0.152.
 */
package jnpad.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.config.Config;
import jnpad.search.SearchBundle;
import jnpad.search.SearchContext;
import jnpad.text.Buffer;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.text.TextUtilities;
import jnpad.ui.JNPadLabel;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Utilities;

public class IncrementalSearchPanel
extends JPanel {
    JPanel pnFind = new JPanel();
    JLabel lbFind = new JNPadLabel();
    JTextField tfFind = new JTextField();
    JButton btFindPrevious = new JButton();
    JButton btFindNext = new JButton();
    JToggleButton tbHighlightAll = new JToggleButton();
    JToggleButton tbWholeWord = new JToggleButton();
    JToggleButton tbMatchCase = new JToggleButton();
    JLabel lbNotFound = new JNPadLabel();
    JPanel pnButton = new JPanel();
    JButton btClose = new JButton();
    private Buffer _buffer;
    private int _actualPosition = -1;
    private boolean notFound;
    private static final Color NOT_FOUND_BG = new Color(255, 102, 102);
    private JNPadFrame jNPad;
    private ChangeListener changeHandler = new ChangeHandler();
    private static final Logger LOGGER = Logger.getLogger(IncrementalSearchPanel.class.getName());
    private static final long serialVersionUID = 4089080779502311618L;

    public IncrementalSearchPanel(JNPadFrame jNPad) {
        super(new BorderLayout());
        try {
            this.jNPad = jNPad;
            this.jbInit();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.lbFind.setText(SearchBundle.getString("IncrementalSearchPanel.find", new Object[0]));
        this.tfFind.setColumns(30);
        this.pnFind.setLayout(new FlowLayout(0));
        this.pnFind.add((Component)this.lbFind, null);
        this.pnFind.add((Component)this.tfFind, null);
        this.pnFind.add((Component)this.btFindPrevious, null);
        this.pnFind.add((Component)this.btFindNext, null);
        this.pnFind.add(Box.createRigidArea(new Dimension(10, 5)), null);
        this.pnFind.add((Component)this.tbMatchCase, null);
        this.pnFind.add((Component)this.tbWholeWord, null);
        this.pnFind.add((Component)this.tbHighlightAll, null);
        this.pnFind.add((Component)this.lbNotFound, null);
        this.pnButton.setLayout(new FlowLayout(2));
        this.pnButton.add((Component)this.btClose, null);
        this.add((Component)this.pnFind, "Center");
        this.add((Component)this.pnButton, "East");
        ActionHandler actionHandler = new ActionHandler();
        IncrementalSearchPanel.setButtonMargin(this.btFindPrevious);
        this.btFindPrevious.setIcon(GUIUtilities.loadIcon("find-previous.png"));
        this.btFindPrevious.setToolTipText(SearchBundle.getString("IncrementalSearchPanel.findPrevious", new Object[0]));
        this.btFindPrevious.addActionListener(actionHandler);
        IncrementalSearchPanel.setButtonMargin(this.btFindNext);
        this.btFindNext.setIcon(GUIUtilities.loadIcon("find-next.png"));
        this.btFindNext.setToolTipText(SearchBundle.getString("IncrementalSearchPanel.findNext", new Object[0]));
        this.btFindNext.addActionListener(actionHandler);
        IncrementalSearchPanel.setButtonMargin(this.tbMatchCase);
        this.tbMatchCase.setIcon(GUIUtilities.loadIcon("match-case.png"));
        this.tbMatchCase.setToolTipText(SearchBundle.getString("IncrementalSearchPanel.matchCase", new Object[0]));
        this.tbMatchCase.setSelected(Config.FIND_MATCH_CASE.getValue());
        this.tbMatchCase.addActionListener(actionHandler);
        IncrementalSearchPanel.setButtonMargin(this.tbWholeWord);
        this.tbWholeWord.setIcon(GUIUtilities.loadIcon("match-whole-word.png"));
        this.tbWholeWord.setToolTipText(SearchBundle.getString("IncrementalSearchPanel.matchWholeWord", new Object[0]));
        this.tbWholeWord.setSelected(Config.FIND_MATCH_WHOLEWORD.getValue());
        this.tbWholeWord.addActionListener(actionHandler);
        IncrementalSearchPanel.setButtonMargin(this.tbHighlightAll);
        this.tbHighlightAll.setIcon(GUIUtilities.loadIcon("highlight-all.png"));
        this.tbHighlightAll.setToolTipText(SearchBundle.getString("IncrementalSearchPanel.highlightAll", new Object[0]));
        this.tbHighlightAll.setSelected(Config.FIND_HIGHLIGHT_ALL.getValue());
        this.tbHighlightAll.addActionListener(actionHandler);
        IncrementalSearchPanel.setButtonMargin(this.btClose);
        this.btClose.setIcon(GUIUtilities.loadIcon("cancel.png"));
        this.btClose.addActionListener(actionHandler);
        this.tfFind.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                if (IncrementalSearchPanel.this.checkBuffer()) {
                    if (ke.getKeyCode() == 10) {
                        IncrementalSearchPanel.this.searchNext(true, false);
                    } else {
                        IncrementalSearchPanel.this._actualPosition = IncrementalSearchPanel.this._buffer.getCaretPosition() - 1;
                        IncrementalSearchPanel.this.searchNext(true, true, false);
                    }
                }
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.jNPad.getActiveBufferSet().addChangeListener(this.changeHandler);
        this.setBuffer();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.jNPad.getActiveBufferSet().removeChangeListener(this.changeHandler);
    }

    private static void setButtonMargin(AbstractButton bt) {
        if (LAFUtils.isMetalLAF() || LAFUtils.isMotifLAF()) {
            bt.setMargin(new Insets(0, 0, 0, 0));
        } else if (LAFUtils.isWindowsLAF()) {
            bt.setMargin(new Insets(2, 2, 2, 2));
        } else if (LAFUtils.isNimbusLAF()) {
            bt.setMargin(new Insets(0, -7, 0, -7));
        } else {
            bt.setMargin(new Insets(1, 1, 1, 1));
        }
    }

    private SearchContext getContext(boolean forward, boolean highlightAll) {
        SearchContext context = new SearchContext(this.tfFind.getText());
        context.setMatchCase(this.tbMatchCase.isSelected());
        context.setWholeWord(this.tbWholeWord.isSelected());
        context.setSearchForward(forward);
        context.setHighlightAll(highlightAll);
        return context;
    }

    private boolean checkBuffer() {
        if (this._buffer == null) {
            this._buffer = this.jNPad.getActiveBuffer();
        }
        return this._buffer != null;
    }

    private void setBuffer() {
        Buffer buffer = this.jNPad.getActiveBuffer();
        if (buffer != null) {
            this._buffer = buffer;
            this._actualPosition = this._buffer.getCaretPosition();
        }
    }

    private void searchNext(boolean forward, boolean notifyNotFound) {
        this.searchNext(forward, notifyNotFound, this.tbHighlightAll.isSelected());
    }

    private void searchNext(boolean forward, boolean notifyNotFound, boolean highlightAll) {
        SearchContext context2;
        EditPane editPane = this._buffer.getSelectedEditPane();
        JNPadTextArea textArea = this._buffer.getSelectedTextArea();
        SearchContext context = this.getContext(forward, highlightAll);
        String searchFor = context.getSearchFor();
        if (Utilities.isEmptyString(searchFor)) {
            return;
        }
        editPane.clearSearchHighlight();
        if (highlightAll && editPane.hasOccurrences() && !context.equals2(context2 = editPane.getOccurrencesContext().getSearchContext())) {
            editPane.clearAllOccurrences();
        }
        int incr = 1;
        if (!forward) {
            incr = -1;
        }
        this._actualPosition = this.search(textArea.getDocument(), searchFor, this._actualPosition + incr, !forward);
        if (this._actualPosition > -1) {
            try {
                editPane.highlightSearch(context, this._actualPosition, this._actualPosition + searchFor.length());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
            if (this.notFound && notifyNotFound) {
                this.tfFind.setBackground(LAFUtils.getTextFieldBackground());
                this.tfFind.setForeground(LAFUtils.getTextFieldForeground());
                this.notFound = false;
                this.lbNotFound.setText("");
            }
        } else if (notifyNotFound) {
            this.tfFind.setBackground(NOT_FOUND_BG);
            this.tfFind.setForeground(Color.WHITE);
            this.notFound = true;
            this.lbNotFound.setText(SearchBundle.getString("IncrementalSearchPanel.notFound", new Object[0]));
            this.tfFind.requestFocusInWindow();
        } else {
            this.searchNext(forward, notifyNotFound, highlightAll);
        }
    }

    private int search(Document doc, String searchFor, int from, boolean backward) {
        if (backward) {
            return IncrementalSearchPanel.searchBackward(doc, searchFor, from, !this.tbMatchCase.isSelected(), this.tbWholeWord.isSelected());
        }
        return IncrementalSearchPanel.searchFoward(doc, searchFor, from, !this.tbMatchCase.isSelected(), this.tbWholeWord.isSelected());
    }

    private static int searchFoward(Document doc, String searchFor, int from, boolean ignoreCase, boolean wholeWord) {
        String searchIn;
        int pos;
        if (from < 0) {
            from = 0;
        }
        if ((pos = Utilities.indexOf(searchIn = TextUtilities.getTextFromTo(doc, from, doc.getLength()), searchFor, ignoreCase, wholeWord)) != -1) {
            return pos + from;
        }
        searchIn = TextUtilities.getTextFromTo(doc, 0, from);
        pos = Utilities.indexOf(searchIn, searchFor, ignoreCase, wholeWord);
        if (pos != -1) {
            return pos;
        }
        return -1;
    }

    private static int searchBackward(Document doc, String searchFor, int from, boolean ignoreCase, boolean wholeWord) {
        String searchIn;
        int pos;
        if (from < 0) {
            from = doc.getLength();
        }
        if ((pos = Utilities.lastIndexOf(searchIn = TextUtilities.getTextFromTo(doc, 0, from), searchFor, ignoreCase, wholeWord)) != -1) {
            return pos;
        }
        searchIn = TextUtilities.getTextFromTo(doc, from, doc.getLength());
        pos = Utilities.lastIndexOf(searchIn, searchFor, ignoreCase, wholeWord);
        if (pos != -1) {
            return pos + from;
        }
        return -1;
    }

    @Override
    public void requestFocus() {
        if (this.tfFind != null) {
            this.tfFind.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.tfFind != null) {
            return this.tfFind.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj == IncrementalSearchPanel.this.btClose) {
                IncrementalSearchPanel.this.jNPad.setIncrementalSearchVisible(false);
            } else if (obj == IncrementalSearchPanel.this.btFindPrevious && IncrementalSearchPanel.this.checkBuffer()) {
                IncrementalSearchPanel.this._actualPosition = IncrementalSearchPanel.this._buffer.getCaretPosition();
                IncrementalSearchPanel.this.searchNext(false, false);
                IncrementalSearchPanel.this._buffer.requestFocus();
            } else if (obj == IncrementalSearchPanel.this.btFindNext && IncrementalSearchPanel.this.checkBuffer()) {
                IncrementalSearchPanel.this._actualPosition = IncrementalSearchPanel.this._buffer.getCaretPosition();
                IncrementalSearchPanel.this.searchNext(true, false);
                IncrementalSearchPanel.this._buffer.requestFocus();
            } else if ((obj == IncrementalSearchPanel.this.tbMatchCase || obj == IncrementalSearchPanel.this.tbWholeWord) && IncrementalSearchPanel.this.checkBuffer()) {
                IncrementalSearchPanel.this._actualPosition = -1;
                IncrementalSearchPanel.this.searchNext(true, true);
                IncrementalSearchPanel.this._buffer.requestFocus();
            } else if (obj == IncrementalSearchPanel.this.tbHighlightAll && IncrementalSearchPanel.this.checkBuffer()) {
                EditPane editPane = IncrementalSearchPanel.this._buffer.getSelectedEditPane();
                if (IncrementalSearchPanel.this.tbHighlightAll.isSelected()) {
                    editPane.highlightAllOccurrences(IncrementalSearchPanel.this.getContext(true, true));
                } else {
                    editPane.clearAllOccurrences();
                }
                IncrementalSearchPanel.this._buffer.requestFocus();
            }
        }
    }

    private class ChangeHandler
    implements ChangeListener,
    Serializable {
        private static final long serialVersionUID = 5433934188372069571L;

        private ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            IncrementalSearchPanel.this.setBuffer();
        }
    }
}

