/*
 * Decompiled with CFR 0.152.
 */
package jnpad.search;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.text.BadLocationException;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.config.Config;
import jnpad.search.SearchBundle;
import jnpad.search.SearchContext;
import jnpad.search.SearchDialog;
import jnpad.text.Buffer;
import jnpad.text.EditPane;
import jnpad.text.JNPadTextArea;
import jnpad.ui.JNPadCheckBox;
import jnpad.util.Utilities;

public class FindDialog
extends SearchDialog {
    JCheckBox cbHighlightAll = new JNPadCheckBox();
    JButton btCount = new JButton();
    JButton btMarkAll = new JButton();
    JButton btFindAll = new JButton();
    private static final long serialVersionUID = 8317331526849105028L;

    public FindDialog(JNPadFrame jNPad) {
        super(jNPad, SearchBundle.getString("FindDialog.title", new Object[0]));
        try {
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(jNPad);
            this.setVisible(true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.cbHighlightAll.setText(SearchBundle.getString("FindDialog.highlightAll", new Object[0]));
        this.btCount.setText(SearchBundle.getString("FindDialog.count", new Object[0]));
        this.btCount.addActionListener(this.actionHandler);
        this.btMarkAll.setText(SearchBundle.getString("FindDialog.markAll", new Object[0]));
        this.btMarkAll.addActionListener(this.actionHandler);
        this.btFindAll.setText(SearchBundle.getString("FindDialog.findAll", new Object[0]));
        this.btFindAll.addActionListener(this.actionHandler);
        this.pnButtons.add((Component)this.btFind, null);
        this.pnButtons.add((Component)this.btCount, null);
        this.pnButtons.add((Component)this.btMarkAll, null);
        this.pnButtons.add((Component)this.btFindAll, null);
        this.pnButtons.add((Component)this.btClose, null);
        this.pnOptionsN.add((Component)this.pnFind, null);
        this.pnOptionsN.add((Component)this.pnLookIn, null);
        this.pnOptionsSW.add((Component)this.cbHighlightAll, null);
        GUIUtilities.setRelativeSize(this.lbFind, this.lbLookIn);
        this.loadState();
    }

    @Override
    void loadState() {
        GUIUtilities.setComboBoxList(this.cmbFind, Config.getFindList());
        int lookIn = Config.FIND_LOOKIN.getValue();
        if (lookIn >= 0 && lookIn <= 2) {
            this.cmbLookIn.setSelectedIndex(lookIn);
        }
        this.cbFindFromCursor.setSelected(Config.FIND_FROMCURSOR.getValue());
        this.cbMatchCase.setSelected(Config.FIND_MATCH_CASE.getValue());
        this.cbMatchWholeWord.setSelected(Config.FIND_MATCH_WHOLEWORD.getValue());
        this.cbHighlightAll.setSelected(Config.FIND_HIGHLIGHT_ALL.getValue());
        if (Config.FIND_DIRECTION_DOWN.getValue().booleanValue()) {
            this.rbFindFoward.setSelected(true);
        } else {
            this.rbFindBackward.setSelected(true);
        }
    }

    @Override
    void saveState() {
        Config.setFindList(GUIUtilities.getComboBoxList(this.cmbFind));
        Config.saveSearchHistorial();
        Config.FIND_LOOKIN.setValue(this.cmbLookIn.getSelectedIndex());
        Config.FIND_FROMCURSOR.setValue(this.cbFindFromCursor.isSelected());
        Config.FIND_MATCH_CASE.setValue(this.cbMatchCase.isSelected());
        Config.FIND_MATCH_WHOLEWORD.setValue(this.cbMatchWholeWord.isSelected());
        Config.FIND_HIGHLIGHT_ALL.setValue(this.cbHighlightAll.isSelected());
        Config.FIND_DIRECTION_DOWN.setValue(this.rbFindFoward.isSelected());
    }

    @Override
    boolean initialize(boolean hide) {
        if (Utilities.isEmptyString(this.getSearchFor()) || !this.checkBuffer()) {
            return false;
        }
        GUIUtilities.updateComboBoxList(this.cmbFind);
        if (hide) {
            this.searchManagerDialog.setMode(10, this.getSearchFor(), null);
        }
        this.saveState();
        if (hide) {
            this.setVisible(false);
        }
        this.resetFind();
        return true;
    }

    @Override
    SearchContext getSearchContext() {
        SearchContext context = new SearchContext(this.getSearchFor());
        context.setMatchCase(this.cbMatchCase.isSelected());
        context.setWholeWord(this.cbMatchWholeWord.isSelected());
        context.setSearchForward(this.rbFindFoward.isSelected());
        context.setHighlightAll(this.cbHighlightAll.isSelected());
        return context;
    }

    @Override
    void removeHighlight(EditPane editPane, SearchContext context) {
        SearchContext context2;
        editPane.clearSearchHighlight();
        if (editPane.hasOccurrences() && !context.equals2(context2 = editPane.getOccurrencesContext().getSearchContext())) {
            editPane.clearAllOccurrences();
        }
    }

    public void findNext() {
        this._buffer = this.jNPad.getActiveBuffer();
        this.doFindNext();
    }

    private void doFindNext() {
        if (!this.searchNext()) {
            int option = this.reportWordNotFound2();
            if (option == 1 || option == -1) {
                return;
            }
            this.resetFind(true);
            this.doFindNext();
        }
    }

    public void findPrevious() {
        this._buffer = this.jNPad.getActiveBuffer();
        this.doFindPrevious();
    }

    private void doFindPrevious() {
        if (!this.searchPrevious()) {
            int option = this.reportWordNotFound2();
            if (option == 1 || option == -1) {
                return;
            }
            this.resetFind(false);
            this.doFindPrevious();
        }
    }

    private void findInOpenDocumments() {
        Buffer[] bufferArray = this.jNPad.getViewer().getBuffers();
        int n = bufferArray.length;
        int n2 = 0;
        while (n2 < n) {
            Buffer buffer = bufferArray[n2];
            this.resetFind();
            this.doFind(buffer, true);
            ++n2;
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.lbStatusBar.setText(" ");
            this.cmbFind.requestFocus();
            this._buffer = this.jNPad.getActiveBuffer();
            try {
                String selectedText;
                if (this._buffer != null && this.cmbLookIn.getSelectedIndex() != 2 && Utilities.isNotEmptyString(selectedText = this._buffer.getSelectedTextArea().getSelectedText())) {
                    this.cmbFind.getEditor().setItem(selectedText);
                    this.cmbFind.getEditor().selectAll();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        } else {
            this.saveState();
        }
        super.setVisible(b);
    }

    @Override
    void handleKeyPressed(KeyEvent e) {
        Object obj = e.getSource();
        if (e.getKeyCode() == 10 && obj == this.cmbFind.getEditor().getEditorComponent()) {
            this.actionHandler.actionPerformed(new ActionEvent(this.btFind, 1001, ""));
        }
    }

    @Override
    void handleActionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.cmbLookIn) {
            int selectedIndex = this.cmbLookIn.getSelectedIndex();
            boolean b = selectedIndex == 0 || selectedIndex == 2;
            this.btFind.setEnabled(b);
        } else if (obj == this.btMarkAll) {
            switch (this.cmbLookIn.getSelectedIndex()) {
                case 0: {
                    this.mark(false);
                    break;
                }
                case 1: {
                    this.markInOpenDocumments();
                    break;
                }
                case 2: {
                    this.mark(true);
                    break;
                }
            }
            this.setVisible(false);
        } else if (obj == this.btCount && this.initialize(false)) {
            switch (this.cmbLookIn.getSelectedIndex()) {
                case 0: {
                    this.count(false);
                    break;
                }
                case 1: {
                    this.countInOpenDocumments();
                    break;
                }
                case 2: {
                    this.count(true);
                }
            }
        } else if (obj == this.btFindAll && this.initialize(true)) {
            if (this.cmbLookIn.getSelectedIndex() == 1) {
                this.findInOpenDocumments();
            } else {
                this.find(true);
            }
        } else {
            super.handleActionPerformed(e);
        }
    }

    private void markInOpenDocumments() {
        int count = 0;
        Buffer[] bufferArray = this.jNPad.getViewer().getBuffers();
        int n = bufferArray.length;
        int n2 = 0;
        while (n2 < n) {
            Buffer buffer = bufferArray[n2];
            count += this.doMark(buffer, false);
            ++n2;
        }
        this.notifyMarksCount(count);
    }

    private void mark(boolean selection) {
        if (!this.checkBuffer()) {
            return;
        }
        this.notifyMarksCount(this.doMark(this._buffer, selection));
    }

    private void notifyMarksCount(int count) {
        this.jNPad.setStatus(SearchBundle.getString("FindDialog.status.markAll", count), 10);
    }

    private int doMark(Buffer buffer, boolean selection) {
        int maxIndex;
        int minIndex;
        char[] searchForArray;
        char[] searchInArray;
        EditPane editPane = buffer.getSelectedEditPane();
        JNPadTextArea textArea = buffer.getSelectedTextArea();
        String searchFor = this.getSearchFor();
        String searchIn = textArea.getText();
        if (this.cbMatchCase.isSelected()) {
            searchInArray = searchIn.toCharArray();
            searchForArray = searchFor.toCharArray();
        } else {
            searchInArray = searchIn.toLowerCase().toCharArray();
            searchForArray = searchFor.toLowerCase().toCharArray();
        }
        if (selection) {
            minIndex = textArea.getSelectionStart();
            maxIndex = textArea.getSelectionEnd();
        } else {
            minIndex = 0;
            maxIndex = textArea.getDocument().getLength() - 1;
        }
        int len = searchInArray.length;
        TreeSet<Integer> bookmarks = new TreeSet<Integer>();
        int index = minIndex;
        while (index < len && index <= maxIndex) {
            if (searchInArray[index] == searchForArray[0] && index + searchForArray.length - 1 <= maxIndex) {
                int j = index + 1;
                int ln = 1;
                while (ln < searchForArray.length && searchInArray[j] == searchForArray[ln]) {
                    ++j;
                    ++ln;
                }
                if (ln == searchForArray.length && this.checkWholeWord(searchInArray, index, ln, minIndex, maxIndex)) {
                    try {
                        int line = textArea.getLineOfOffset(index);
                        bookmarks.add(line);
                    }
                    catch (BadLocationException ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            }
            ++index;
        }
        if (!bookmarks.isEmpty()) {
            editPane.addBookmarks(bookmarks);
        }
        return bookmarks.size();
    }

    private void countInOpenDocumments() {
        int count = 0;
        Buffer[] bufferArray = this.jNPad.getViewer().getBuffers();
        int n = bufferArray.length;
        int n2 = 0;
        while (n2 < n) {
            Buffer buffer = bufferArray[n2];
            count += this.doCount(buffer, false);
            ++n2;
        }
        this.notifyOccurrencesCount(count);
    }

    private void count(boolean selection) {
        if (!this.checkBuffer()) {
            return;
        }
        this.notifyOccurrencesCount(this.doCount(this._buffer, selection));
    }

    private void notifyOccurrencesCount(int count) {
        this.lbStatusBar.setText(SearchBundle.getString("FindDialog.status.count", count));
    }

    private int doCount(Buffer buffer, boolean selection) {
        JNPadTextArea textArea = buffer.getSelectedTextArea();
        String searchFor = this.getSearchFor();
        int count = 0;
        if (!this.cbMatchWholeWord.isSelected()) {
            String searchIn;
            String string = searchIn = selection ? textArea.getSelectedText() : textArea.getText();
            if (!this.cbMatchCase.isSelected()) {
                searchFor = searchFor.toLowerCase();
                searchIn = searchIn.toLowerCase();
            }
            count = Utilities.countMatches(searchIn, searchFor);
        } else {
            int maxIndex;
            int minIndex;
            char[] searchForArray;
            char[] searchInArray;
            String searchIn = textArea.getText();
            if (this.cbMatchCase.isSelected()) {
                searchInArray = searchIn.toCharArray();
                searchForArray = searchFor.toCharArray();
            } else {
                searchInArray = searchIn.toLowerCase().toCharArray();
                searchForArray = searchFor.toLowerCase().toCharArray();
            }
            if (selection) {
                minIndex = textArea.getSelectionStart();
                maxIndex = textArea.getSelectionEnd();
            } else {
                minIndex = 0;
                maxIndex = textArea.getDocument().getLength() - 1;
            }
            int len = searchInArray.length;
            int index = minIndex;
            while (index < len && index <= maxIndex) {
                if (searchInArray[index] == searchForArray[0] && index + searchForArray.length - 1 <= maxIndex) {
                    int j = index + 1;
                    int ln = 1;
                    while (ln < searchForArray.length && searchInArray[j] == searchForArray[ln]) {
                        ++j;
                        ++ln;
                    }
                    if (ln == searchForArray.length && this.checkWholeWord(searchInArray, index, ln, minIndex, maxIndex)) {
                        ++count;
                    }
                }
                ++index;
            }
        }
        return count;
    }
}

