/*
 * Decompiled with CFR 0.152.
 */
package jnpad.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import jnpad.JNPadBundle;
import jnpad.print.PrintingOptions;
import jnpad.ui.ReporterUtilities;
import jnpad.util.Utilities;

public class PrintText {
    private int _wrapOffset = 0;
    private String _docTitle;
    private String[] _text;
    private PrintingOptions _printOptions;
    private int _tabSize = 4;

    public PrintText(Document doc) {
        this(doc, "", new PrintingOptions(), 4);
    }

    public PrintText(Document doc, String docTitle, PrintingOptions printOptions, int tabSize) {
        this._printOptions = printOptions;
        this._tabSize = tabSize;
        this._docTitle = docTitle != null ? docTitle : JNPadBundle.getString("PrintText.new", new Object[0]);
        Element root = doc.getDefaultRootElement();
        int count = root.getElementCount();
        String[] lines = new String[count];
        Segment segment = new Segment();
        int i = 0;
        while (i < count) {
            Element lineElement = root.getElement(i);
            try {
                doc.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset(), segment);
                lines[i] = segment.toString();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++i;
        }
        this._text = lines;
        this.printTextArray();
    }

    void printTextArray() {
        try {
            PrinterJob pj = PrinterJob.getPrinterJob();
            this._text = this.removeEOLChar();
            if (this._printOptions.getPrintLineNumbers()) {
                this._text = this.addLineNumbers();
            }
            if (this._printOptions.getWrapText()) {
                this._text = this.wrapText();
            }
            Book _pages = this.pageinateText();
            try {
                pj.setPageable(_pages);
                if (pj.printDialog()) {
                    pj.print();
                }
            }
            catch (Exception ex) {
                PrintText.reportError();
            }
        }
        catch (Exception ex) {
            PrintText.reportError();
        }
    }

    private static void reportError() {
        ReporterUtilities.reportError(null, JNPadBundle.getString("PrintText.error.message", new Object[0]), JNPadBundle.getString("PrintText.error.title", new Object[0]));
    }

    private String[] removeEOLChar() {
        int lineCount = this._text.length;
        String[] newText = new String[lineCount];
        int i = 0;
        while (i < lineCount) {
            if (this._text[i].length() == 1) {
                newText[i] = " ";
            } else {
                String temp1 = this._text[i].substring(this._text[i].length() - 2, this._text[i].length() - 1);
                String temp2 = this._text[i].substring(this._text[i].length() - 1, this._text[i].length());
                int offset = temp1.compareTo("\r") == 0 || temp1.compareTo("\n") == 0 ? 2 : (temp2.compareTo("\r") == 0 || temp2.compareTo("\n") == 0 ? 1 : 0);
                String temp3 = this._text[i].substring(0, this._text[i].length() - offset);
                StringBuilder temp4 = new StringBuilder();
                int length = temp3.length();
                int j = 0;
                while (j < length) {
                    if ("\t".equals(temp3.substring(j, j + 1))) {
                        int numSpaces = temp4.length() % this._tabSize;
                        if (numSpaces == 0) {
                            numSpaces = this._tabSize;
                        }
                        int x = 0;
                        while (x < numSpaces) {
                            temp4.append(" ");
                            ++x;
                        }
                    } else {
                        temp4.append(temp3.substring(j, j + 1));
                    }
                    ++j;
                }
                newText[i] = temp4.toString();
            }
            ++i;
        }
        return newText;
    }

    private String[] addLineNumbers() {
        int numLines = this._text.length;
        String[] newText = new String[numLines];
        Integer lines = numLines;
        String temp = lines.toString();
        int totalNumSpaces = temp.length();
        this._wrapOffset = totalNumSpaces + 3;
        int i = 0;
        while (i < numLines) {
            StringBuilder num = new StringBuilder();
            num.append(i + 1);
            int numLen = num.length();
            StringBuilder lineNum = new StringBuilder();
            int j = 0;
            while (j < totalNumSpaces - numLen) {
                lineNum.append(' ');
                ++j;
            }
            lineNum.append(num.toString());
            newText[i] = String.valueOf(lineNum.toString()) + ".  " + this._text[i];
            ++i;
        }
        return newText;
    }

    private String[] wrapText() {
        Object tempString = null;
        Vector<String> temp = new Vector<String>();
        int lineCount = this._text.length;
        StringBuilder wrapSpaces = new StringBuilder();
        PageFormat pgfmt = this._printOptions.getPageFormat();
        Font pageFont = this._printOptions.getPageFont();
        double pageWidth = pgfmt.getImageableWidth();
        int i = 0;
        while (i < this._wrapOffset) {
            wrapSpaces.append(' ');
            ++i;
        }
        i = 0;
        while (i < lineCount) {
            String currentLine = this._text[i];
            while (pageFont.getStringBounds(currentLine, new FontRenderContext(pageFont.getTransform(), false, false)).getWidth() > pageWidth) {
                int numChars = (int)((double)currentLine.length() * pageWidth / pageFont.getStringBounds(currentLine, new FontRenderContext(pageFont.getTransform(), false, false)).getWidth());
                temp.add(currentLine.substring(0, numChars));
                currentLine = String.valueOf(wrapSpaces.toString()) + currentLine.substring(numChars, currentLine.length());
            }
            temp.add(currentLine);
            ++i;
        }
        int newLineCount = temp.size();
        String[] newText = new String[newLineCount];
        int j = 0;
        while (j < newLineCount) {
            newText[j] = (String)temp.get(j);
            ++j;
        }
        return newText;
    }

    private Book pageinateText() {
        Book book = new Book();
        int currentLine = 0;
        int pageNum = 0;
        PageFormat pgfmt = this._printOptions.getPageFormat();
        Font pageFont = this._printOptions.getPageFont();
        int height = (int)pgfmt.getImageableHeight();
        int linesPerPage = height / (pageFont.getSize() + 2);
        int pages = this._text.length / linesPerPage;
        this.convertUnprintables();
        if (this._printOptions.getPrintHeader()) {
            linesPerPage -= 2;
        }
        while (pageNum <= pages) {
            String[] pageText = new String[linesPerPage];
            int x = 0;
            while (x < linesPerPage) {
                String readString;
                try {
                    readString = this._text[currentLine];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    readString = " ";
                }
                pageText[x] = readString;
                ++currentLine;
                ++x;
            }
            book.append(new Page(pageText, ++pageNum), pgfmt);
        }
        return book;
    }

    private void convertUnprintables() {
        int i = this._text.length;
        while (i > 0) {
            String tempString;
            if (!Utilities.isEmptyString(tempString = this._text[--i])) continue;
            this._text[i] = " ";
        }
    }

    class Page
    implements Printable {
        private String[] pageText_;
        private int pageNumber_ = 0;

        Page(String[] text, int pageNum) {
            this.pageText_ = text;
            this.pageNumber_ = pageNum;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            int pos;
            int posOffset = 1;
            double pageWidth = pageFormat.getImageableWidth();
            Font pageFont = PrintText.this._printOptions.getPageFont();
            if (PrintText.this._printOptions.getPrintHeader()) {
                StringBuilder header = new StringBuilder();
                StringBuilder pageNumText = new StringBuilder();
                boolean i = false;
                boolean headerPos = false;
                boolean numSpaces = false;
                Calendar date = Calendar.getInstance();
                header.append(date.get(5));
                header.append('/');
                header.append(date.get(2) + 1);
                header.append('/');
                header.append(date.get(1));
                pageNumText.append(JNPadBundle.getString("PrintText.page", new Object[0]));
                pageNumText.append(this.pageNumber_);
                double margin = (pageFormat.getWidth() - pageFormat.getImageableWidth()) / 2.0;
                graphics.setFont(PrintText.this._printOptions.getHeaderFont());
                graphics.setColor(Color.black);
                pos = (int)pageFormat.getImageableY() + (PrintText.this._printOptions.getHeaderFont().getSize() + 2);
                graphics.drawString(header.toString(), (int)pageFormat.getImageableX(), pos);
                int xPos = (int)(pageFormat.getWidth() / 2.0 - (double)graphics.getFontMetrics().stringWidth(PrintText.this._docTitle) / 2.0);
                graphics.drawString(PrintText.this._docTitle, xPos, pos);
                xPos = (int)(pageFormat.getWidth() - margin - (double)graphics.getFontMetrics().stringWidth(pageNumText.toString()));
                graphics.drawString(pageNumText.toString(), xPos, pos);
                posOffset = 3;
            }
            graphics.setFont(pageFont);
            graphics.setColor(Color.black);
            int x = 0;
            while (x < this.pageText_.length) {
                pos = (int)pageFormat.getImageableY() + (pageFont.getSize() + 2) * (x + posOffset);
                graphics.drawString(this.pageText_[x], (int)pageFormat.getImageableX(), pos);
                ++x;
            }
            return 0;
        }
    }
}

