/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.Element;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;
import jnpad.text.TextUtilities;
import jnpad.ui.status.StatusDisplayable;

public final class RemoveEndSpacesAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(RemoveEndSpacesAction.class.getName());
    private static final long serialVersionUID = 3469606959782769250L;

    public RemoveEndSpacesAction(JNPadFrame jNPad) {
        super(jNPad, "remove-end-lines", JNPadActions.Group.EDIT, Accelerators.REMOVE_END_SPACES, null);
    }

    @Override
    public void performAction() {
        Buffer buffer = this.jNPad.getActiveBuffer();
        if (buffer != null) {
            try {
                try {
                    buffer.beginCompoundEdit();
                    JNPadTextArea target = buffer.getSelectedTextArea();
                    Document doc = target.getDocument();
                    Element map = doc.getDefaultRootElement();
                    int count = map.getElementCount();
                    int i = 0;
                    while (i < count) {
                        Element lineElement = map.getElement(i);
                        int start = lineElement.getStartOffset();
                        int end = lineElement.getEndOffset() - 1;
                        String text = this.doRemove(TextUtilities.getText(doc, start, end -= start));
                        doc.remove(start, end);
                        if (text != null) {
                            doc.insertString(start, text, null);
                        }
                        ++i;
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getLabel()));
                    buffer.endCompoundEdit();
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
    }

    private String doRemove(String in) {
        int end = in.length();
        while (--end >= 0 && Character.isWhitespace(in.charAt(end))) {
        }
        return end < 0 ? null : in.substring(0, end + 1);
    }
}

