/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.print.PageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.print.PrintText;
import jnpad.print.PrintingOptions;
import jnpad.text.JNPadTextArea;

public final class PrintAction
extends JNPadAction {
    private static final Logger LOGGER = Logger.getLogger(PrintAction.class.getName());
    private static final long serialVersionUID = -6923219883495955962L;

    public PrintAction(JNPadFrame jNPad) {
        super(jNPad, "print", JNPadActions.Group.FILE, Accelerators.PRINT, "print.png");
    }

    @Override
    public void performAction() {
        JNPadTextArea textArea = this.jNPad.getActiveTextArea();
        if (textArea != null) {
            try {
                PrintingOptions printOptions = new PrintingOptions();
                printOptions.setPrintLineNumbers(Config.PRINT_LINE_NUMBERS.getValue());
                printOptions.setPrintHeader(Config.PRINT_HEADER.getValue());
                printOptions.setWrapText(Config.PRINT_WRAP_TEXT.getValue());
                printOptions.setPageFont(Config.PRINT_FONT.getValue());
                PageFormat pageFormat = this.jNPad.getPageFormat();
                printOptions.setPageFormat(pageFormat);
                new PrintText(textArea.getDocument(), textArea.getName(), printOptions, textArea.getTabSize());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

