/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.ViewActionScope;
import jnpad.text.Viewer;

public final class MarkBracketsAction
extends JNPadAction {
    private static final long serialVersionUID = 2378316097520732616L;

    public MarkBracketsAction(JNPadFrame jNPad) {
        super(jNPad, "mark-brackets", JNPadActions.Group.VIEW, Accelerators.MARK_BRACKETS, "mark-brackets.png");
        this.setSelected(Config.BRACKET_HIGHLIGHTER_VISIBLE.getValue());
        this.setStateAction(true);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        ViewActionScope scope = Config.VIEW_ACTION_SCOPE.getValue();
        Viewer viewer = this.jNPad.getViewer();
        switch (scope) {
            case VIEWER: {
                viewer.setBracketHighlighterVisible(1 == e.getStateChange());
                break;
            }
            case BUFFER_SET: {
                viewer.getActiveBufferSet().setBracketHighlighterVisible(1 == e.getStateChange());
                break;
            }
            case EDIT_PANE: {
                viewer.getActiveEditPane().setBracketHighlighterVisible(1 == e.getStateChange());
                break;
            }
            default: {
                viewer.getActiveBuffer().setBracketHighlighterVisible(1 == e.getStateChange());
            }
        }
    }
}

