/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.text.EditPane;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;
import jnpad.util.Utilities;

public final class InsertDateAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(InsertDateAction.class.getName());
    private static final long serialVersionUID = -3901339451203050782L;

    public InsertDateAction(JNPadFrame jNPad) {
        super(jNPad, "insert-date", JNPadActions.Group.EDIT, Accelerators.INSERT_DATE, "");
    }

    @Override
    public void performAction() {
        EditPane editPane = this.jNPad.getActiveEditPane();
        if (editPane != null) {
            SimpleDateFormat dateFormat;
            try {
                dateFormat = new SimpleDateFormat(Config.DATE_FORMAT.getValue());
            }
            catch (Exception ex) {
                LOGGER.warning(ex.getMessage());
                dateFormat = new SimpleDateFormat();
            }
            try {
                String date = dateFormat.format(Utilities.now());
                JNPadTextArea target = editPane.getTextArea();
                Document doc = target.getDocument();
                int caretPosition = target.getCaretPosition();
                doc.insertString(caretPosition, date, null);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }
}

