/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.config.Config;
import jnpad.ui.EdgeBorder;
import jnpad.ui.EscapableDialog;
import jnpad.ui.status.StatusDisplayable;

class FilePropertiesDialog
extends EscapableDialog {
    JPanel contentPane;
    JPanel pnBackground = new JPanel();
    JPanel pnProperties = new JPanel();
    JPanel pnPropertiesNames = new JPanel();
    JPanel pnPropertiesValues = new JPanel();
    JLabel lbFileName = new JLabel();
    JPanel pnAttributes = new JPanel();
    JPanel pnReadable = new JPanel();
    JCheckBox cbReadable = new JCheckBox();
    JLabel lbReadable = new JLabel();
    JPanel pnWritable = new JPanel();
    JCheckBox cbWritable = new JCheckBox();
    JLabel lbWritable = new JLabel();
    JPanel pnHidden = new JPanel();
    JCheckBox cbHidden = new JCheckBox();
    JLabel lbHidden = new JLabel();
    JPanel pnClose = new JPanel();
    JButton btClose = new JButton();
    JLabel lbPath = new JLabel();
    JLabel lbPathValue = new JLabel();
    JLabel lbLines = new JLabel();
    JLabel lbLinesValue = new JLabel();
    JLabel lbEOL = new JLabel();
    JLabel lbEOLValue = new JLabel();
    JLabel lbEncoding = new JLabel();
    JLabel lbEncodingValue = new JLabel();
    JLabel lbSize = new JLabel();
    JLabel lbSizeValue = new JLabel();
    JLabel lbModified = new JLabel();
    JLabel lbModifiedValue = new JLabel();
    private File file;
    private static final Logger LOGGER = Logger.getLogger(FilePropertiesDialog.class.getName());
    private static final long serialVersionUID = 2275677877542023512L;

    public FilePropertiesDialog(JNPadFrame jNPad, File file) {
        super(jNPad, ActionBundle.getString("file-properties".concat(".title"), file.getName()), true);
        try {
            this.file = file;
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(jNPad);
            this.setVisible(true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getTitle()));
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.pnBackground, "North");
        this.contentPane.add((Component)this.pnClose, "South");
        this.init();
        this.pnBackground.setLayout(new BorderLayout());
        this.pnBackground.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.pnBackground.add((Component)this.lbFileName, "North");
        this.pnBackground.add((Component)this.pnProperties, "Center");
        this.pnBackground.add((Component)this.pnAttributes, "South");
        this.lbFileName.setHorizontalAlignment(0);
        this.lbFileName.setBorder(new EdgeBorder(4));
        this.pnProperties.setLayout(new BorderLayout(5, 0));
        this.pnProperties.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.pnProperties.add((Component)this.pnPropertiesNames, "West");
        this.pnProperties.add((Component)this.pnPropertiesValues, "Center");
        this.lbPath.setText(ActionBundle.getString("file-properties".concat(".path"), new Object[0]));
        this.lbLines.setText(ActionBundle.getString("file-properties".concat(".lines"), new Object[0]));
        this.lbEOL.setText(ActionBundle.getString("file-properties".concat(".eol"), new Object[0]));
        this.lbEncoding.setText(ActionBundle.getString("file-properties".concat(".encoding"), new Object[0]));
        this.lbSize.setText(ActionBundle.getString("file-properties".concat(".size"), new Object[0]));
        this.lbModified.setText(ActionBundle.getString("file-properties".concat(".modified"), new Object[0]));
        this.pnPropertiesNames.setLayout(new GridLayout(6, 1, 0, 5));
        this.pnPropertiesNames.add((Component)this.lbPath, null);
        this.pnPropertiesNames.add((Component)this.lbLines, null);
        this.pnPropertiesNames.add((Component)this.lbEOL, null);
        this.pnPropertiesNames.add((Component)this.lbEncoding, null);
        this.pnPropertiesNames.add((Component)this.lbSize, null);
        this.pnPropertiesNames.add((Component)this.lbModified, null);
        this.pnPropertiesValues.setLayout(new GridLayout(6, 1, 0, 5));
        this.pnPropertiesValues.add((Component)this.lbPathValue, null);
        this.pnPropertiesValues.add((Component)this.lbLinesValue, null);
        this.pnPropertiesValues.add((Component)this.lbEOLValue, null);
        this.pnPropertiesValues.add((Component)this.lbEncodingValue, null);
        this.pnPropertiesValues.add((Component)this.lbSizeValue, null);
        this.pnPropertiesValues.add((Component)this.lbModifiedValue, null);
        this.pnAttributes.setBorder(BorderFactory.createTitledBorder(ActionBundle.getString("file-properties".concat(".attributes.title"), new Object[0])));
        this.pnAttributes.setLayout(new GridLayout(3, 1));
        this.pnAttributes.add((Component)this.pnReadable, null);
        this.pnAttributes.add((Component)this.pnWritable, null);
        this.pnAttributes.add((Component)this.pnHidden, null);
        this.pnReadable.setLayout(new FlowLayout(0, 5, 0));
        this.pnReadable.add((Component)this.cbReadable, null);
        this.pnReadable.add((Component)this.lbReadable, null);
        this.lbReadable.setText(ActionBundle.getString("file-properties".concat(".attributes.readable"), new Object[0]));
        this.cbReadable.setEnabled(false);
        this.pnWritable.setLayout(new FlowLayout(0, 5, 0));
        this.pnWritable.add((Component)this.cbWritable, null);
        this.pnWritable.add((Component)this.lbWritable, null);
        this.lbWritable.setText(ActionBundle.getString("file-properties".concat(".attributes.writable"), new Object[0]));
        this.cbWritable.setEnabled(false);
        this.pnHidden.setLayout(new FlowLayout(0, 5, 0));
        this.pnHidden.add((Component)this.cbHidden, null);
        this.pnHidden.add((Component)this.lbHidden, null);
        this.lbHidden.setText(ActionBundle.getString("file-properties".concat(".attributes.hidden"), new Object[0]));
        this.cbHidden.setEnabled(false);
        this.pnClose.setLayout(new FlowLayout(4));
        this.pnClose.add((Component)this.btClose, null);
        GUIUtilities.setLocalizedText(this.btClose, JNPadBundle.getCloseButtonText());
        this.btClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePropertiesDialog.this.dispose();
            }
        });
        this.setDefaultCloseOperation(2);
    }

    @Override
    protected void escapePressed() {
        this.dispose();
    }

    private void init() {
        SimpleDateFormat dateFormat;
        double tempSize;
        this.lbFileName.setText(this.file.getName());
        this.lbPathValue.setText(this.file.getAbsolutePath());
        try {
            String s;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
            String encoding = GUIUtilities.detectEncoding(in);
            if (encoding == null || !Charset.isSupported(encoding)) {
                encoding = Config.FILE_ENCODING.getValue();
            } else {
                this.lbEncodingValue.setText(encoding);
            }
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            in.close();
            try {
                s = new String(buffer, 0, buffer.length, encoding);
            }
            catch (Exception ex) {
                s = new String(buffer, 0, buffer.length, (String)Config.FILE_ENCODING.getDefault());
            }
            GUIUtilities.StringConversion conversion = GUIUtilities.detectEOL(s);
            this.lbEOLValue.setText(conversion.getLineSeparator().getLongName());
            this.lbLinesValue.setText(String.valueOf(conversion.getLineCount()));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        int count = 0;
        double prevSize = tempSize = (double)this.file.length();
        while (count < 4 && (tempSize = prevSize / 1024.0) >= 1.0) {
            prevSize = tempSize;
            ++count;
        }
        String suffix = null;
        switch (count) {
            case 0: {
                suffix = "bytes";
                break;
            }
            case 1: {
                suffix = "KB";
                break;
            }
            case 2: {
                suffix = "MB";
                break;
            }
            case 3: {
                suffix = "GB";
                break;
            }
            case 4: {
                suffix = "TB";
                break;
            }
        }
        NumberFormat fileSizeFormat = NumberFormat.getNumberInstance();
        fileSizeFormat.setGroupingUsed(true);
        fileSizeFormat.setMinimumFractionDigits(0);
        fileSizeFormat.setMaximumFractionDigits(1);
        this.lbSizeValue.setText(String.valueOf(fileSizeFormat.format(prevSize)) + " " + suffix);
        try {
            dateFormat = new SimpleDateFormat(Config.DATE_FORMAT.getValue());
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            dateFormat = new SimpleDateFormat();
        }
        this.lbModifiedValue.setText(dateFormat.format(new Date(this.file.lastModified())));
        this.cbHidden.setSelected(this.file.isHidden());
        this.cbWritable.setSelected(this.file.canWrite());
        this.cbReadable.setSelected(this.file.canRead());
    }
}

