/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.Element;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.action.SortLinesAscendingAction;
import jnpad.config.Accelerators;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.text.JNPadTextArea;
import jnpad.text.TextUtilities;
import jnpad.ui.status.StatusDisplayable;

public final class DuplicateCurrentLineAction
extends JNPadAction
implements IEditAction {
    private static final Logger LOGGER = Logger.getLogger(SortLinesAscendingAction.class.getName());
    private static final long serialVersionUID = 2088612702394865299L;

    public DuplicateCurrentLineAction(JNPadFrame jNPad) {
        super(jNPad, "duplicate-current-line", JNPadActions.Group.EDIT, Accelerators.DUPLICATE_CURRENT_LINE, null);
    }

    @Override
    public void performAction() {
        Buffer buffer = this.jNPad.getActiveBuffer();
        if (buffer != null) {
            try {
                try {
                    boolean b;
                    buffer.beginCompoundEdit();
                    JNPadTextArea target = buffer.getSelectedTextArea();
                    Document doc = target.getDocument();
                    int line = TextUtilities.getCurrentLineIndex(target);
                    Element lineElem = TextUtilities.getLine(doc, line);
                    int end = lineElem.getEndOffset();
                    String text = TextUtilities.getTextOfLine(doc, line);
                    boolean bl = b = end > doc.getLength();
                    if (b) {
                        end = doc.getLength();
                        text = "\n" + text;
                    }
                    doc.insertString(end, text, null);
                    target.setCaretPosition(b ? end + 1 : end);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    this.jNPad.setStatus(StatusDisplayable.StatusType.ERROR, "Error - ".concat(this.getLabel()));
                    buffer.endCompoundEdit();
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
    }
}

