/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import jnpad.action.JNPadAction;
import jnpad.action.RedoAction;
import jnpad.action.UndoAction;
import jnpad.text.IDirtyAction;
import jnpad.text.IEditAction;
import jnpad.text.ISelectionAction;

public enum ActionManager {
    INSTANCE;

    private Map<Object, Action> actions = new HashMap<Object, Action>();

    public void registerActions(Map<?, Action> actions_) {
        for (Map.Entry<?, Action> entry : actions_.entrySet()) {
            this.actions.put(entry.getKey(), entry.getValue());
        }
    }

    public void registerAction(Action action) {
        this.actions.put(action.getValue("Name"), action);
    }

    public void unregisterAction(Action action) {
        this.actions.remove(action.getValue("Name"));
    }

    public Action get(String name) {
        return this.actions.get(name);
    }

    public void setEnabled(String name, boolean b) {
        Action action = this.get(name);
        if (action != null) {
            action.setEnabled(b);
        }
    }

    public boolean isEnabled(String name) {
        Action action = this.get(name);
        return action != null && action.isEnabled();
    }

    public boolean executeAction(String name) {
        Action action = this.get(name);
        if (action != null && action instanceof JNPadAction && action.isEnabled()) {
            if (((JNPadAction)action).isStateAction()) {
                ((JNPadAction)action).setSelected(!((JNPadAction)action).isSelected());
            } else {
                ((JNPadAction)action).performAction();
            }
            return true;
        }
        return false;
    }

    public List<String> getCompletionsForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object key : this.actions.keySet()) {
            Action a = this.actions.get(key);
            String s_key = key.toString();
            if (!s_key.startsWith(prefix) || !a.isEnabled()) continue;
            list.add(s_key);
        }
        Collections.sort(list);
        return list;
    }

    public void setEnabledBy(boolean edit, boolean selection, boolean undo, boolean redo, boolean dirty) {
        for (Object key : this.actions.keySet()) {
            Action a = this.actions.get(key);
            if (a instanceof UndoAction) {
                a.setEnabled(edit & undo);
                continue;
            }
            if (a instanceof RedoAction) {
                a.setEnabled(edit & redo);
                continue;
            }
            if (a instanceof IEditAction && a instanceof ISelectionAction) {
                a.setEnabled(edit && selection);
                continue;
            }
            if (a instanceof IEditAction && a instanceof IDirtyAction) {
                a.setEnabled(edit && dirty);
                continue;
            }
            if (a instanceof IEditAction) {
                a.setEnabled(edit);
                continue;
            }
            if (!(a instanceof ISelectionAction)) continue;
            a.setEnabled(selection);
        }
    }
}

