/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.config.Config;
import jnpad.text.IBuffer;
import jnpad.text.Scheme;
import jnpad.ui.EscapableDialog;
import jnpad.ui.icon.CompositeIcon;
import jnpad.ui.tab.ITabbedPane;
import jnpad.ui.table.JNPadTable;
import jnpad.ui.table.LabelTableCellRenderer;
import jnpad.util.Utilities;

public class WindowDialog
extends EscapableDialog {
    JPanel contentPane;
    JPanel pnBackground = new JPanel();
    JScrollPane scrollPane = new JScrollPane();
    JPanel pnButtons = new JPanel();
    JPanel pnButtonsGroup = new JPanel();
    JButton btActivate = new JButton();
    JButton btSave = new JButton();
    JButton btClose = new JButton();
    JButton btMove = new JButton();
    JButton btSort = new JButton();
    JButton btOk = new JButton();
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_PATH = 1;
    private static final int COLUMN_TYPE = 2;
    private static final String[] COLUMN_NAMES = new String[]{JNPadBundle.getString("WindowDialog.column.name", new Object[0]), JNPadBundle.getString("WindowDialog.column.path", new Object[0]), JNPadBundle.getString("WindowDialog.column.type", new Object[0])};
    DefaultTableModel tableModel = new DefaultTableModel(){
        private static final long serialVersionUID = -2339075884909205886L;

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    };
    JNPadTable table = new JNPadTable(this.tableModel);
    private JNPadFrame jNPad;
    private ITabbedPane tabbedPane;
    private boolean isEditable;
    private boolean isValueChangedEnabled = true;
    private static final Logger LOGGER = Logger.getLogger(WindowDialog.class.getName());
    private static final long serialVersionUID = -3473470406892731188L;

    public WindowDialog(JNPadFrame jNPad, ITabbedPane tabbedPane, boolean isEditable) {
        super(jNPad, JNPadBundle.getString("WindowDialog.title", new Object[0]), true);
        try {
            this.jNPad = jNPad;
            this.tabbedPane = tabbedPane;
            this.isEditable = isEditable;
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(jNPad);
            this.setVisible(true);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.pnBackground, "Center");
        this.contentPane.add((Component)this.pnButtons, "East");
        ActionHandler actionHandler = new ActionHandler();
        this.pnButtons.setLayout(new BorderLayout());
        this.pnButtonsGroup.setLayout(new GridLayout(0, 1, 0, 5));
        this.pnButtons.setBorder(GUIUtilities.createEmptyBorder(5));
        this.pnBackground.setBorder(BorderFactory.createEmptyBorder(5, 5, 20, 5));
        this.pnBackground.setLayout(new BorderLayout());
        this.pnButtons.add((Component)this.pnButtonsGroup, "North");
        this.pnButtonsGroup.add((Component)this.btActivate, null);
        this.pnButtonsGroup.add((Component)this.btSave, null);
        this.pnButtonsGroup.add((Component)this.btClose, null);
        this.pnButtonsGroup.add((Component)this.btMove, null);
        this.pnButtonsGroup.add((Component)this.btSort, null);
        this.pnButtons.add((Component)this.btOk, "South");
        GUIUtilities.setLocalizedText(this.btOk, JNPadBundle.getOkButtonText());
        GUIUtilities.setLocalizedText(this.btActivate, JNPadBundle.getActivateButtonText());
        GUIUtilities.setLocalizedText(this.btSave, JNPadBundle.getSaveButtonText());
        GUIUtilities.setLocalizedText(this.btClose, JNPadBundle.getCloseButtonText());
        GUIUtilities.setLocalizedText(this.btMove, JNPadBundle.getMoveButtonText());
        GUIUtilities.setLocalizedText(this.btSort, JNPadBundle.getSortButtonText());
        this.btActivate.addActionListener(actionHandler);
        this.btSave.addActionListener(actionHandler);
        this.btClose.addActionListener(actionHandler);
        this.btMove.addActionListener(actionHandler);
        this.btSort.addActionListener(actionHandler);
        this.btOk.addActionListener(actionHandler);
        this.pnBackground.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.table, null);
        this.table.setSortingEnabled(false);
        this.table.setRowHeaderEnabled(true);
        this.table.setRowHeaderSelected(this.tabbedPane.getSelectedIndex());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionHandler());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(600, 300));
        this.table.setGridColor(Config.TEXT_RIGHT_MARGIN_LINE_COLOR.getValue());
        this.table.setForeground(Config.TEXT_FOREGROUND.getValue());
        this.table.setBackground(Config.TEXT_BACKGROUND.getValue());
        this.table.setSelectionForeground(Config.TEXT_SELECTION_FOREGROUND.getValue());
        this.table.setSelectionBackground(Config.TEXT_SELECTION_BACKGROUND.getValue());
        int tabCount = this.tabbedPane.getTabCount();
        Object[][] data = new Object[tabCount][COLUMN_NAMES.length];
        int i = 0;
        while (i < tabCount) {
            Component c = this.tabbedPane.getComponentAt(i);
            data[i][0] = this.getName(c, i);
            data[i][1] = this.getPath(c);
            data[i][2] = this.getType(c);
            ++i;
        }
        this.tableModel.setDataVector(data, COLUMN_NAMES);
        this.tableModel.getDataVector();
        this.table.getColumnModel().getColumn(0).setCellRenderer(new NameTableCellRenderer());
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new LabelTableCellRenderer(true));
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(2).setCellRenderer(new LabelTableCellRenderer(false));
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        this.table.setRowSelectionInterval(selectedIndex, selectedIndex);
        this.setDefaultCloseOperation(2);
    }

    @Override
    protected void escapePressed() {
        this.dispose();
    }

    private void reload() {
        this.isValueChangedEnabled = false;
        this.tableModel.getDataVector().clear();
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            Component c = this.tabbedPane.getComponentAt(i);
            Object[] rowData = new Object[COLUMN_NAMES.length];
            rowData[0] = this.getName(c, i);
            rowData[1] = this.getPath(c);
            rowData[2] = this.getType(c);
            this.tableModel.addRow(rowData);
            ++i;
        }
        this.tableModel.fireTableDataChanged();
        this.isValueChangedEnabled = true;
    }

    private void doPostClose() {
        int[] selectedRows = this.table.getSelectedRows();
        this.reload();
        int rowCount = this.table.getRowCount();
        if (selectedRows.length > 0) {
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            int selectedRow = selectedRows[0];
            if (selectedRow < rowCount) {
                selectionModel.setSelectionInterval(selectedRow, selectedRow);
            } else if (rowCount > 0) {
                selectionModel.setSelectionInterval(rowCount - 1, rowCount - 1);
            }
        }
        if (rowCount == 0) {
            this.dispose();
        }
    }

    private void doPostSave() {
        int[] selectedRows = this.table.getSelectedRows();
        this.reload();
        if (selectedRows.length > 0) {
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            int[] nArray = selectedRows;
            int n = selectedRows.length;
            int n2 = 0;
            while (n2 < n) {
                int selectedRow = nArray[n2];
                selectionModel.addSelectionInterval(selectedRow, selectedRow);
                ++n2;
            }
        }
    }

    private void doPostMove() {
        this.reload();
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        this.table.setRowSelectionInterval(selectedIndex, selectedIndex);
    }

    private NameElem getName(Component c, int index) {
        boolean save;
        Icon icon;
        String name;
        boolean selected;
        boolean bl = selected = this.tabbedPane.getSelectedIndex() == index;
        if (c instanceof IBuffer) {
            name = this.tabbedPane.getTitleAt(index);
            if (((IBuffer)((Object)c)).isDirty()) {
                name = String.valueOf(name) + "*";
            }
            if ((icon = this.tabbedPane.getIconAt(index)) instanceof CompositeIcon && ((CompositeIcon)icon).hasMainIcon()) {
                icon = ((CompositeIcon)icon).getMainIcon();
            }
            save = this.isEditable && !((IBuffer)((Object)c)).isReadOnly() && ((IBuffer)((Object)c)).isDirty();
        } else {
            name = "";
            icon = null;
            save = this.isEditable;
        }
        return new NameElem(name, icon, save, selected);
    }

    private String getPath(Component c) {
        if (c instanceof IBuffer) {
            return ((IBuffer)((Object)c)).getFilePath();
        }
        return "";
    }

    private String getType(Component c) {
        if (c instanceof IBuffer) {
            return Scheme.getDisplayName(((IBuffer)((Object)c)).getContentType());
        }
        return JNPadBundle.getString("WindowDialog.text", new Object[0]);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj == WindowDialog.this.btOk) {
                WindowDialog.this.dispose();
            } else if (obj == WindowDialog.this.btActivate) {
                int selectedRow = WindowDialog.this.table.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < WindowDialog.this.tabbedPane.getTabCount()) {
                    WindowDialog.this.tabbedPane.setSelectedIndex(selectedRow);
                    WindowDialog.this.dispose();
                }
            } else if (obj == WindowDialog.this.btSave && WindowDialog.this.isEditable) {
                int[] selectedRows = WindowDialog.this.table.getSelectedRows();
                boolean b = false;
                int[] nArray = selectedRows;
                int n = selectedRows.length;
                int n2 = 0;
                while (n2 < n) {
                    int selectedRow = nArray[n2];
                    String path = (String)WindowDialog.this.table.getValueAt(selectedRow, 1);
                    b = WindowDialog.this.jNPad.saveFile(path) || b;
                    ++n2;
                }
                if (b) {
                    WindowDialog.this.doPostSave();
                }
            } else if (obj == WindowDialog.this.btClose && WindowDialog.this.isEditable) {
                int[] selectedRows = WindowDialog.this.table.getSelectedRows();
                boolean b = false;
                int[] nArray = selectedRows;
                int n = selectedRows.length;
                int n3 = 0;
                while (n3 < n) {
                    int selectedRow = nArray[n3];
                    String path = (String)WindowDialog.this.table.getValueAt(selectedRow, 1);
                    b = WindowDialog.this.jNPad.closeFile(path, true) || b;
                    ++n3;
                }
                if (b) {
                    WindowDialog.this.doPostClose();
                }
            } else if (obj == WindowDialog.this.btMove) {
                int selectedRow = WindowDialog.this.table.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < WindowDialog.this.tabbedPane.getTabCount()) {
                    int tab;
                    String response = JOptionPane.showInputDialog(WindowDialog.this, JNPadBundle.getString("WindowDialog.move.message", WindowDialog.this.tabbedPane.getTabCount()), JNPadBundle.getString("WindowDialog.move.title", new Object[0]), 3);
                    if (Utilities.isBlankString(response)) {
                        return;
                    }
                    try {
                        tab = Integer.parseInt(response) - 1;
                    }
                    catch (Exception ex) {
                        JOptionPane.showConfirmDialog(WindowDialog.this, JNPadBundle.getString("WindowDialog.move.error.message", response), JNPadBundle.getString("WindowDialog.move.error.title", new Object[0]), -1, 0);
                        return;
                    }
                    try {
                        WindowDialog.this.tabbedPane.setSelectedIndex(selectedRow);
                        WindowDialog.this.tabbedPane.moveSelectedTabTo(tab);
                        WindowDialog.this.doPostMove();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            } else if (obj == WindowDialog.this.btSort) {
                try {
                    ArrayList<String> l_titles = new ArrayList<String>();
                    ArrayList<Component> l_comps = new ArrayList<Component>();
                    int i = 0;
                    while (i < WindowDialog.this.tabbedPane.getTabCount()) {
                        l_titles.add(WindowDialog.this.tabbedPane.getTitleAt(i));
                        l_comps.add(WindowDialog.this.tabbedPane.getComponentAt(i));
                        ++i;
                    }
                    ArrayList l_aux = new ArrayList(l_titles);
                    Collections.sort(l_titles);
                    if (!l_aux.equals(l_titles)) {
                        Component selectedComponent = WindowDialog.this.tabbedPane.getSelectedComponent();
                        int i2 = 0;
                        while (i2 < l_comps.size()) {
                            for (Component c : l_comps) {
                                WindowDialog.this.tabbedPane.setSuppressStateChangedEvents(true);
                                WindowDialog.this.tabbedPane.setSelectedComponent(c);
                                WindowDialog.this.tabbedPane.setSuppressStateChangedEvents(false);
                                WindowDialog.this.tabbedPane.moveSelectedTabTo(l_titles.indexOf(WindowDialog.this.tabbedPane.getTitleAt(WindowDialog.this.tabbedPane.getSelectedIndex())));
                            }
                            ++i2;
                        }
                        WindowDialog.this.tabbedPane.setSelectedComponent(selectedComponent);
                    }
                    WindowDialog.this.doPostMove();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!WindowDialog.this.isValueChangedEnabled) {
                return;
            }
            if (e.getSource() == WindowDialog.this.table.getSelectionModel() && e.getFirstIndex() >= 0) {
                int[] selectedRows = WindowDialog.this.table.getSelectedRows();
                switch (selectedRows.length) {
                    case 0: {
                        WindowDialog.this.btActivate.setEnabled(false);
                        WindowDialog.this.btClose.setEnabled(false);
                        WindowDialog.this.btSave.setEnabled(false);
                        WindowDialog.this.btMove.setEnabled(false);
                        WindowDialog.this.btSort.setEnabled(true);
                        break;
                    }
                    case 1: {
                        WindowDialog.this.btClose.setEnabled(WindowDialog.this.isEditable);
                        NameElem nameElem = (NameElem)WindowDialog.this.table.getValueAt(selectedRows[0], 0);
                        WindowDialog.this.btSave.setEnabled(nameElem.save);
                        WindowDialog.this.btActivate.setEnabled(!nameElem.selected);
                        WindowDialog.this.btMove.setEnabled(true);
                        WindowDialog.this.btSort.setEnabled(false);
                        break;
                    }
                    default: {
                        WindowDialog.this.btActivate.setEnabled(false);
                        WindowDialog.this.btMove.setEnabled(false);
                        WindowDialog.this.btSort.setEnabled(selectedRows.length == WindowDialog.this.tabbedPane.getTabCount());
                        WindowDialog.this.btClose.setEnabled(WindowDialog.this.isEditable);
                        boolean b = false;
                        int[] nArray = selectedRows;
                        int n = selectedRows.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int selectedRow = nArray[n2];
                            NameElem nElem = (NameElem)WindowDialog.this.table.getValueAt(selectedRow, 0);
                            if (nElem.save) {
                                b = true;
                                break;
                            }
                            ++n2;
                        }
                        WindowDialog.this.btSave.setEnabled(b);
                    }
                }
            }
        }
    }

    static class NameElem {
        private String name;
        private Icon icon;
        private boolean save;
        private boolean selected;

        NameElem(String name, Icon icon, boolean save, boolean selected) {
            this.name = name;
            this.icon = icon;
            this.save = save;
            this.selected = selected;
        }

        public String toString() {
            return this.name;
        }
    }

    static class NameTableCellRenderer
    extends LabelTableCellRenderer {
        private static final long serialVersionUID = -3676231760961001044L;

        NameTableCellRenderer() {
            super(false);
        }

        @Override
        protected void setState(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof NameElem) {
                this.setIcon(((NameElem)value).icon);
            } else {
                this.setIcon(null);
            }
        }
    }
}

