/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.JNPadTabbedPane;
import jnpad.JNPadViewer;
import jnpad.config.Config;
import jnpad.text.Buffer;
import jnpad.text.BufferSet;
import jnpad.ui.icon.CompositeIcon;
import jnpad.ui.icon.IconClickTarget;

public final class JNPadTabbedViewer
extends JNPadViewer {
    static ImageIcon iiTabGenericClose;
    static ImageIcon iiTabModifiedClose;
    static ImageIcon iiTabReadOnlyClose;
    static ImageIcon iiTabModifiedReadOnlyClose;
    private static final Logger LOGGER;
    private static final long serialVersionUID = 5946227426715682848L;

    static {
        LOGGER = Logger.getLogger(JNPadTabbedViewer.class.getName());
        try {
            iiTabGenericClose = GUIUtilities.getIcon("tab-generic-close.png");
            iiTabModifiedClose = GUIUtilities.getIcon("tab-modified-close.png");
            iiTabReadOnlyClose = GUIUtilities.getIcon("tab-readonly-close.png");
            iiTabModifiedReadOnlyClose = GUIUtilities.getIcon("tab-modified-readonly-close.png");
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public JNPadTabbedViewer(JNPadFrame jNPad, JMenu mWindow) {
        super(jNPad, mWindow);
        this._bufferSet = new JNPadTabbedPane(this);
        this._bufferSet.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JNPadTabbedViewer.this.handleStateChanged(e);
            }
        });
        this.setMainContent((JNPadTabbedPane)this._bufferSet);
    }

    public JNPadTabbedPane getJNPadTabbedPane() {
        return (JNPadTabbedPane)this._bufferSet;
    }

    @Override
    protected Icon getIcon(Buffer buffer) {
        Icon icon;
        if (Config.TAB_CLOSE_BUTTON.getValue().booleanValue() && this._bufferSet.getTabLayoutPolicy() == 0) {
            ImageIcon fileIcon;
            ArrayList<Icon> list = new ArrayList<Icon>();
            if (buffer.isDirty()) {
                fileIcon = iiFileModified;
                list.add(new IconClickTarget(buffer.isReadOnly() ? iiTabModifiedReadOnlyClose : iiTabModifiedClose));
            } else if (buffer.isNew()) {
                fileIcon = iiFileNew;
                list.add(new IconClickTarget(buffer.isReadOnly() ? iiTabReadOnlyClose : iiTabGenericClose));
            } else {
                fileIcon = iiFile;
                list.add(new IconClickTarget(buffer.isReadOnly() ? iiTabReadOnlyClose : iiTabGenericClose));
            }
            list.add(fileIcon);
            Icon[] icons = list.toArray(new Icon[list.size()]);
            CompositeIcon cicon = new CompositeIcon(icons, 2, 0);
            cicon.setMainIcon(fileIcon);
            icon = cicon;
        } else {
            icon = super.getIcon(buffer);
        }
        return icon;
    }

    @Override
    protected BufferSet createBufferSet(BufferSet oldBufferSet) {
        JNPadTabbedPane newBufferSet = new JNPadTabbedPane(this);
        int i = 0;
        while (i < this._bufferSet.getTabCount()) {
            Buffer buffer = this._bufferSet.getBufferAt(i);
            Buffer e = JNPadTabbedViewer.create(newBufferSet, buffer);
            String title = this._bufferSet.getTitleAt(i);
            String tip = this._bufferSet.getToolTipTextAt(i);
            Icon icon = this._bufferSet.getIconAt(i);
            newBufferSet.addTab(title, icon, e, tip);
            ++i;
        }
        newBufferSet.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JNPadTabbedViewer.this.handleStateChanged(e);
            }
        });
        return newBufferSet;
    }
}

