/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.io.Serializable;
import jnpad.util.Platform;
import jnpad.util.Utilities;

public class JNPadInput
implements Serializable {
    private String _filePath;
    private boolean _isReadOnly;
    private int _caretPosition;
    private boolean _isCurrent;
    private String _splitConfig;
    private boolean _isLineWrapped;
    private static final long serialVersionUID = 5444128936316971023L;

    public JNPadInput(String filePath, int caretPosition, boolean isReadOnly, boolean isCurrent, boolean isLineWrapped) {
        this(filePath, caretPosition, isReadOnly, isCurrent, "", isLineWrapped);
    }

    public JNPadInput(String filePath, int caretPosition, boolean isReadOnly, boolean isCurrent, String splitConfig, boolean isLineWrapped) {
        this._filePath = filePath;
        this._caretPosition = caretPosition;
        this._isReadOnly = isReadOnly;
        this._isCurrent = isCurrent;
        this._splitConfig = splitConfig == null ? "" : splitConfig;
        this._isLineWrapped = isLineWrapped;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public boolean isCurrent() {
        return this._isCurrent;
    }

    public String getPath() {
        return this._filePath;
    }

    public int getCaretPosition() {
        return this._caretPosition;
    }

    public String getSplitConfig() {
        return this._splitConfig;
    }

    public boolean isLineWrapped() {
        return this._isLineWrapped;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof JNPadInput && Utilities.equals(this._filePath, ((JNPadInput)obj)._filePath, !Platform.isWindows) && this._caretPosition == ((JNPadInput)obj)._caretPosition && this._isReadOnly == ((JNPadInput)obj)._isReadOnly && this._isCurrent == ((JNPadInput)obj)._isCurrent && this._isLineWrapped == ((JNPadInput)obj)._isLineWrapped && Utilities.equals(this._splitConfig, ((JNPadInput)obj)._splitConfig);
    }

    public int hashCode() {
        return Utilities.hashCode(this._filePath, this._caretPosition, this._isReadOnly, this._isCurrent, this._splitConfig, this._isLineWrapped);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._filePath).append(",").append(this._caretPosition).append(",").append(this._isReadOnly).append(",").append(this._isCurrent).append(",").append(this._isLineWrapped);
        if (Utilities.isNotEmptyString(this._splitConfig)) {
            sb.append(",").append(this._splitConfig);
        }
        return sb.toString();
    }
}

