/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.config.Config;
import jnpad.ui.MnemonicHelper;
import jnpad.ui.icon.EmptyIcon;
import jnpad.ui.plaf.LAFUtils;
import jnpad.util.LineSeparator;
import jnpad.util.Platform;
import jnpad.util.Utilities;

public final class GUIUtilities {
    public static final Icon EMPTY_ICON = EmptyIcon.ICON_16;
    private static final Insets NULL_INSETS = new Insets(0, 0, 0, 0);
    private static final int MAX_ITEM_LIST_ELEM = 40;
    private static final int MIN_ITEM_LIST_ELEM = 4;
    private static Map<Integer, GradientPaint> m_gpCache;
    private static RGBImageFilter imageIconFilter;
    private static final String[] FONT_STYLES;
    private static final String[] HIDE_FONTS;
    private static final String[] STANDARD_FONT_SIZES;
    private static final Logger LOGGER;

    static {
        FONT_STYLES = new String[]{"Plain", "Bold", "Italic", "Bold Italic"};
        HIDE_FONTS = new String[]{".bold", ".italic"};
        STANDARD_FONT_SIZES = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        LOGGER = Logger.getLogger(GUIUtilities.class.getName());
    }

    private GUIUtilities() {
    }

    public static int getSelectedButtonIndex(ButtonGroup group) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (group.isSelected(button.getModel())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static AbstractButton getSelectedButton(ButtonGroup group) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            if (!group.isSelected(button.getModel())) continue;
            return button;
        }
        return null;
    }

    public static void setSelectedButton(ButtonGroup group, int index) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        int i = 0;
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            group.setSelected(button.getModel(), index == i);
            ++i;
        }
    }

    public static void setButtonGroupEnabled(ButtonGroup group, boolean enabled) {
        Enumeration<AbstractButton> enumeration = group.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton button = enumeration.nextElement();
            button.setEnabled(enabled);
        }
    }

    public static JMenu createMenu(String text, Icon icon) {
        JMenu m = new JMenu();
        GUIUtilities.setLocalizedText(m, text);
        if (icon != null && Config.isDefaultMode()) {
            m.setIcon(icon);
        }
        return m;
    }

    public static JNPadFrame getJNPadFrame(EventObject evt) {
        Object o;
        if (evt != null && (o = evt.getSource()) instanceof Component) {
            return GUIUtilities.getJNPadFrame((Component)o);
        }
        return null;
    }

    public static JNPadFrame getJNPadFrame(Component comp) {
        while (true) {
            if (comp instanceof JNPadFrame) {
                return (JNPadFrame)comp;
            }
            if (comp instanceof JPopupMenu) {
                comp = ((JPopupMenu)comp).getInvoker();
                continue;
            }
            if (comp == null) break;
            comp = comp.getParent();
        }
        return null;
    }

    public static void setLocalizedText(AbstractButton item, String text) {
        GUIUtilities.setLocalizedText2(item, text);
    }

    public static void setLocalizedText(JLabel item, String text) {
        GUIUtilities.setLocalizedText2(item, text);
    }

    private static void setLocalizedText2(Object item, String text) {
        if (text == null || item == null) {
            return;
        }
        int i = GUIUtilities.findMnemonicAmpersand(text);
        if (i < 0) {
            GUIUtilities.setText(item, text);
            GUIUtilities.setMnemonic(item, 0);
        } else {
            GUIUtilities.setText(item, String.valueOf(text.substring(0, i)) + text.substring(i + 1));
            if (Platform.isMac) {
                GUIUtilities.setMnemonic(item, 0);
            } else {
                int ch = text.charAt(i + 1);
                if (text.startsWith("<html>")) {
                    GUIUtilities.setText(item, String.valueOf(text.substring(0, i)) + "<u>" + (char)ch + "</u>" + text.substring(i + 2));
                    i += 3;
                }
                if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57) {
                    int vk = ch;
                    if (vk >= 97 && vk <= 122) {
                        vk -= 32;
                    }
                    GUIUtilities.setMnemonic(item, vk);
                } else {
                    try {
                        int latinCode = GUIUtilities.getLatinKeycode((char)ch);
                        GUIUtilities.setMnemonic(item, latinCode);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static void setMnemonic(JMenu menu, MnemonicHelper mnemonicHelper, boolean submenus) {
        Component c;
        int len = menu.getMenuComponentCount();
        int i = 0;
        while (i < len) {
            c = menu.getMenuComponent(i);
            if (c instanceof AbstractButton) {
                if (mnemonicHelper != null) {
                    char mnemonic = mnemonicHelper.getMnemonic(((AbstractButton)c).getText());
                    if (mnemonic != '\u0000') {
                        ((AbstractButton)c).setMnemonic(mnemonic);
                    }
                } else {
                    ((AbstractButton)c).setMnemonic('\u0000');
                }
            }
            ++i;
        }
        if (submenus) {
            if (mnemonicHelper != null) {
                mnemonicHelper.clear();
            }
            i = 0;
            while (i < len) {
                c = menu.getMenuComponent(i);
                if (c instanceof JMenu) {
                    GUIUtilities.setMnemonic((JMenu)c, mnemonicHelper, true);
                }
                ++i;
            }
        }
    }

    private static void setText(Object item, String text) {
        if (item instanceof AbstractButton) {
            ((AbstractButton)item).setText(text);
        } else {
            ((JLabel)item).setText(text);
        }
    }

    private static void setMnemonic(Object item, int mnem) {
        if (Platform.isMac) {
            return;
        }
        if (item instanceof AbstractButton) {
            ((AbstractButton)item).setMnemonic(mnem);
        } else {
            ((JLabel)item).setDisplayedMnemonic(mnem);
        }
    }

    public static int findMnemonicAmpersand(String text) {
        int i = -1;
        boolean isHTML = text.startsWith("<html>");
        do {
            if ((i = text.indexOf(38, i + 1)) < 0 || i + 1 >= text.length()) continue;
            if (isHTML) {
                boolean startsEntity = false;
                int j = i + 1;
                while (j < text.length()) {
                    char c = text.charAt(j);
                    if (c == ';') {
                        startsEntity = true;
                        break;
                    }
                    if (!Character.isLetterOrDigit(c)) break;
                    ++j;
                }
                if (startsEntity) continue;
                return i;
            }
            if (text.charAt(i + 1) == ' ' || text.charAt(i + 1) == '\'' && i > 0 && text.charAt(i - 1) == '\'') continue;
            return i;
        } while (i >= 0);
        return -1;
    }

    public static int getLatinKeycode(char localeChar) throws MissingResourceException {
        String str = GUIUtilities.getMnemonicsBundle().getString("MNEMONIC_" + localeChar);
        if (str.length() == 1) {
            return str.charAt(0);
        }
        return Integer.parseInt(str);
    }

    private static ResourceBundle getMnemonicsBundle() {
        return ResourceBundle.getBundle("jnpad.i18n.MnemonicsBundle");
    }

    public static ImageIcon getIcon(String picture, Class<?> source) throws FileNotFoundException {
        return GUIUtilities.getIcon(picture, source, true);
    }

    public static ImageIcon getIcon(String picture, Class<?> source, boolean filter) throws FileNotFoundException {
        try {
            RGBImageFilter imageFilter;
            ImageIcon icon = new ImageIcon(source.getResource("icons/".concat(picture)));
            if (filter && LAFUtils.isDarkLAF() && (imageFilter = GUIUtilities.getImageIconFilter()) != null) {
                Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(icon.getImage().getSource(), imageFilter));
                icon = new ImageIcon(image);
            }
            return icon;
        }
        catch (Exception e) {
            throw new FileNotFoundException("No se encontr\u00f3 el archivo: icons/".concat(picture));
        }
    }

    private static RGBImageFilter getImageIconFilter() {
        Object obj;
        if (imageIconFilter == null && (obj = UIManager.get("jnpad.imageicon.filter")) instanceof RGBImageFilter) {
            imageIconFilter = (RGBImageFilter)obj;
        }
        return imageIconFilter;
    }

    public static ImageIcon getIcon(String picture) throws FileNotFoundException {
        return GUIUtilities.getIcon(picture, GUIUtilities.class);
    }

    public static ImageIcon getIcon(String picture, boolean filter) throws FileNotFoundException {
        return GUIUtilities.getIcon(picture, GUIUtilities.class, filter);
    }

    public static ImageIcon loadIcon(String picture, Class<?> source) {
        try {
            return GUIUtilities.getIcon(picture, source);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    public static ImageIcon loadIcon(String picture, Class<?> source, boolean filter) {
        try {
            return GUIUtilities.getIcon(picture, source, filter);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    public static ImageIcon loadIcon(String picture) {
        try {
            return GUIUtilities.getIcon(picture);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    public static ImageIcon loadIcon(String picture, boolean filter) {
        try {
            return GUIUtilities.getIcon(picture, filter);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            return null;
        }
    }

    public static Border createEmptyBorder(int gap) {
        return BorderFactory.createEmptyBorder(gap, gap, gap, gap);
    }

    public static Border createEmptyBorder(int hgap, int vgap) {
        return BorderFactory.createEmptyBorder(vgap, hgap, vgap, hgap);
    }

    public static StringConversion getStringConversion(String str, boolean removeEndSpaces) {
        StringConversion sc = new StringConversion(str, removeEndSpaces);
        sc.convert();
        return sc;
    }

    public static StringConversion detectEOL(String str) {
        StringConversion sc = new StringConversion(str, false);
        sc.detectEOL();
        return sc;
    }

    public static String convertString(String str, boolean removeEndSpaces, int tabSize) {
        StringConversion sc = new StringConversion(str, removeEndSpaces, tabSize);
        sc.convertText();
        return sc.getResult();
    }

    public static String formatString(String text, String lineSeparator) {
        if (lineSeparator == null) {
            lineSeparator = Utilities.LINE_SEPARATOR;
        }
        return Utilities.convertLineEndings(text, lineSeparator);
    }

    public static String detectEncoding(InputStream in) throws IOException {
        CharsetDetector cd = new CharsetDetector();
        cd.setText(in);
        CharsetMatch cm = cd.detect();
        return cm == null ? null : cm.getName();
    }

    public static String[] getDetectableEncodings() {
        return CharsetDetector.getAllDetectableCharsets();
    }

    public static String getJNPadDefaultEncoding() {
        String encoding = null;
        try {
            File f;
            block32: {
                block30: {
                    f = new File("jnpad-temp");
                    PrintWriter pw = null;
                    try {
                        try {
                            pw = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                            pw.println("# Este es un archivo de prueba");
                        }
                        catch (Exception ex) {
                            encoding = GUIUtilities.getDefaultEncoding();
                            if (pw != null) {
                                try {
                                    pw.close();
                                }
                                catch (Exception exception) {}
                            }
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        if (pw != null) {
                            try {
                                pw.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (pw != null) {
                        try {
                            pw.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (encoding == null) {
                    BufferedInputStream in = null;
                    try {
                        try {
                            in = new BufferedInputStream(new FileInputStream(f));
                            encoding = GUIUtilities.detectEncoding(in);
                        }
                        catch (Exception ex) {
                            encoding = GUIUtilities.getDefaultEncoding();
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Exception exception) {}
                            }
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            boolean bool = f.delete();
        }
        catch (Exception ex) {
            encoding = GUIUtilities.getDefaultEncoding();
        }
        return encoding;
    }

    public static String getDefaultEncoding() {
        String encoding = Charset.defaultCharset().name();
        if (encoding == null) {
            try {
                File f = File.createTempFile("jnpad-temp", null);
                FileWriter w = new FileWriter(f);
                encoding = w.getEncoding();
                w.close();
                f.deleteOnExit();
            }
            catch (IOException ioe) {
                encoding = System.getProperty("file.encoding", "UTF-8");
            }
        }
        return encoding;
    }

    public static TreeSet<String> getCharsetTreeSet() {
        TreeSet<String> result = new TreeSet<String>();
        result.add(Config.FILE_ENCODING.getValue());
        String[] stringArray = GUIUtilities.getDetectableEncodings();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String encoding = stringArray[n2];
            if (Charset.isSupported(encoding)) {
                result.add(encoding);
            }
            ++n2;
        }
        return result;
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void addCloseWithEscapeKey(final Window comp) throws IllegalArgumentException {
        Container cont;
        if (comp instanceof JFrame) {
            cont = ((JFrame)comp).getContentPane();
        } else if (comp instanceof JDialog) {
            cont = ((JDialog)comp).getContentPane();
        } else if (comp instanceof JWindow) {
            cont = ((JWindow)comp).getContentPane();
        } else {
            throw new IllegalArgumentException(String.valueOf(JNPadBundle.getString("utils.error.0", new Object[0])) + comp.getClass());
        }
        ((JComponent)cont).registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                comp.setVisible(false);
                comp.dispose();
            }
        }, "Escape", KeyStroke.getKeyStroke(27, 0), 1);
    }

    public static void runOrInvokeAndWait(Runnable r) throws InvocationTargetException, InterruptedException {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeAndWait(r);
        }
    }

    public static void runOrInvokeLater(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void requestFocus(final Component c) {
        if (c == null) {
            return;
        }
        if (c.isShowing()) {
            c.requestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    c.requestFocus();
                }
            });
        }
    }

    public static void requestFocusInWindow(final Component c) {
        if (c == null) {
            return;
        }
        if (c.isShowing()) {
            c.requestFocusInWindow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    c.requestFocusInWindow();
                }
            });
        }
    }

    public static void requestFocus(final Window win, final Component comp) {
        win.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                comp.requestFocus();
                win.removeWindowListener(this);
            }
        });
    }

    public static void requestFocusInWindow(final Window win, final Component comp) {
        win.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        comp.requestFocusInWindow();
                    }
                });
                win.removeWindowFocusListener(this);
            }
        });
    }

    public static boolean checkHasFocus(Container container) {
        Component[] components;
        Component[] componentArray = components = container.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof Container && GUIUtilities.checkHasFocus((Container)component)) {
                return true;
            }
            if (component.hasFocus()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Component getFocusedComponent() {
        Frame frame = GUIUtilities.getFocusedFrame();
        if (frame == null) {
            return null;
        }
        return frame.getFocusOwner();
    }

    public static Frame getFocusedFrame() {
        Frame[] frames;
        Frame[] frameArray = frames = Frame.getFrames();
        int n = frames.length;
        int n2 = 0;
        while (n2 < n) {
            Frame frame = frameArray[n2];
            if (frame.isVisible() && frame.getFocusOwner() != null) {
                return frame;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isAncestorOfFocusOwner(Component component) {
        boolean hasFocus = false;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == focusOwner || component instanceof Container && ((Container)component).isAncestorOf(focusOwner)) {
            hasFocus = true;
        }
        return hasFocus;
    }

    public static void updateSize(JLabel label, String widestString) {
        Dimension maxDimension = label.getPreferredSize();
        Font f = label.getFont();
        if (f != null) {
            Border b = label.getBorder();
            Insets ins = b != null ? b.getBorderInsets(label) : NULL_INSETS;
            FontMetrics fm = label.getFontMetrics(f);
            int mw = fm.stringWidth(label.getText());
            maxDimension.height = fm.getHeight() + ins.top + ins.bottom;
            if (widestString != null) {
                mw = Math.max(mw, fm.stringWidth(widestString));
            }
            maxDimension.width = mw + ins.left + ins.right;
        }
        label.setPreferredSize(maxDimension);
        label.setMinimumSize(maxDimension);
    }

    public static void setRelativeSize(JComponent ... components) {
        JComponent component;
        Dimension dimension = new Dimension(0, 0);
        JComponent[] jComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            component = jComponentArray[n2];
            if (component.getPreferredSize().width > dimension.width) {
                dimension = component.getPreferredSize();
            }
            ++n2;
        }
        jComponentArray = components;
        n = components.length;
        n2 = 0;
        while (n2 < n) {
            component = jComponentArray[n2];
            component.setPreferredSize(dimension);
            ++n2;
        }
    }

    public static String getFilePath(FontMetrics fm, String path, int width) {
        int w = fm.stringWidth(path);
        StringBuilder sb = new StringBuilder(path);
        boolean b = false;
        while (w > width) {
            int idx1 = sb.toString().indexOf(Utilities.DIR_SEPARATOR);
            int idx2 = sb.toString().indexOf(Utilities.DIR_SEPARATOR, idx1 + 1);
            if (idx2 < 0) {
                idx2 = sb.toString().length();
            }
            try {
                sb.delete(idx1, idx2);
                b = true;
            }
            catch (Exception ex) {
                idx1 = sb.toString().indexOf(47);
                idx2 = sb.toString().indexOf(47, idx1 + 1);
                if (idx1 == -1 || idx2 == -1) {
                    idx2 = 0;
                    idx1 = 0;
                    if (sb.length() > 0) {
                        idx2 = 1;
                    }
                }
                sb.delete(idx1, idx2);
                b = true;
            }
            w = fm.stringWidth(sb.toString());
        }
        if (b) {
            try {
                sb.insert(sb.toString().indexOf(Utilities.DIR_SEPARATOR), String.valueOf(Utilities.DIR_SEPARATOR) + "...");
            }
            catch (Exception ex) {
                try {
                    sb.insert(sb.toString().indexOf(47), "/...");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }

    public static Dimension getScreenDimension() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static void centerComponent(Component comp) {
        Dimension sSize = GUIUtilities.getScreenDimension();
        Dimension cSize = comp.getSize();
        if (cSize.height > sSize.height) {
            cSize.height = sSize.height;
        }
        if (cSize.width > sSize.width) {
            cSize.width = sSize.width;
        }
        comp.setLocation(new Point((sSize.width - cSize.width) / 2, (sSize.height - cSize.height) / 2));
    }

    public static Rectangle getMaximumWindowBounds() {
        GraphicsEnvironment lge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            return lge.getMaximumWindowBounds();
        }
        catch (Exception ex) {
            Dimension s = GUIUtilities.getScreenDimension();
            return new Rectangle(0, 0, s.width, s.height);
        }
    }

    public static Rectangle getScreenBoundsForPoint(Point p) {
        return GUIUtilities.getScreenBoundsForPoint(p.x, p.y);
    }

    public static Rectangle getScreenBoundsForPoint(int x, int y) {
        GraphicsDevice[] devices;
        GraphicsEnvironment lge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = devices = lge.getScreenDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice device = graphicsDeviceArray[n2];
            GraphicsConfiguration config = device.getDefaultConfiguration();
            Rectangle gcBounds = config.getBounds();
            if (gcBounds.contains(x, y)) {
                return gcBounds;
            }
            ++n2;
        }
        return GUIUtilities.getMaximumWindowBounds();
    }

    public static void setPositionFrameOnScreen(Window frame, double horizontalPercent, double verticalPercent) {
        Rectangle r = GUIUtilities.getMaximumWindowBounds();
        Dimension f = frame.getSize();
        int w = Math.max(r.width - f.width, 0);
        int h = Math.max(r.height - f.height, 0);
        int x = (int)(horizontalPercent * (double)w) + r.x;
        int y = (int)(verticalPercent * (double)h) + r.y;
        frame.setBounds(x, y, f.width, f.height);
    }

    public static JButton createOkButton() {
        JButton btOk = new JButton();
        GUIUtilities.setLocalizedText(btOk, JNPadBundle.getString("button.ok", new Object[0]));
        btOk.setIcon(GUIUtilities.loadIcon("ok.png"));
        return btOk;
    }

    public static JButton createCancelButton() {
        JButton btCancel = new JButton();
        GUIUtilities.setLocalizedText(btCancel, JNPadBundle.getString("button.cancel", new Object[0]));
        btCancel.setIcon(GUIUtilities.loadIcon("cancel.png"));
        return btCancel;
    }

    public static Dimension getSize(Dimension size, Dimension max) {
        if (size.width > max.width) {
            size.width = max.width;
        }
        if (size.height > max.height) {
            size.height = max.height;
        }
        return size;
    }

    public static List getComboBoxList(JComboBox cmb) {
        ArrayList list = new ArrayList(cmb.getItemCount());
        int i = 0;
        while (i < cmb.getItemCount()) {
            Object obj = cmb.getItemAt(i);
            if (!list.contains(obj)) {
                list.add(obj);
            }
            ++i;
        }
        if (list.size() > 40) {
            Utilities.restrictListSize(list, 40);
        }
        return list;
    }

    public static void setComboBoxList(JComboBox cmb, List<?> list) {
        if (list.size() > 40) {
            Utilities.restrictListSize(list, 40);
        }
        for (Object aList : list) {
            cmb.addItem(aList);
        }
    }

    public static String getItem(JComboBox cmb) {
        return cmb.getEditor().getItem().toString();
    }

    public static void updateComboBoxList(JComboBox cmb) {
        GUIUtilities.updateComboBoxList(cmb, GUIUtilities.getItem(cmb), 40);
    }

    public static void updateComboBoxList(JComboBox cmb, int size) {
        GUIUtilities.updateComboBoxList(cmb, GUIUtilities.getItem(cmb), size);
    }

    public static void updateComboBoxList(JComboBox cmb, Object item) {
        GUIUtilities.updateComboBoxList(cmb, item, 40);
    }

    public static void updateComboBoxList(JComboBox cmb, Object item, int size) {
        if (size < 4) {
            size = 4;
        }
        boolean b = true;
        int j = 0;
        while (j < cmb.getItemCount()) {
            Object item_;
            if ((item_ = cmb.getItemAt(j++)).equals(item)) {
                cmb.removeItem(item_);
                cmb.insertItemAt(item_, 0);
                cmb.setSelectedItem(item_);
                j = cmb.getItemCount();
                b = false;
            }
            ++j;
        }
        if (b) {
            cmb.insertItemAt(item, 0);
            cmb.setSelectedIndex(0);
            while (cmb.getItemCount() > size) {
                cmb.removeItemAt(cmb.getItemCount() - 1);
            }
        }
    }

    public static void drawBorder(Graphics g, Color c, int x, int y, int w, int h) {
        g.setColor(c);
        g.drawRect(x, y, w - 1, h - 1);
    }

    public static void draw3DBorder(Graphics g, Color c1, Color c2, int x, int y, int w, int h) {
        int x2 = x + w - 1;
        int y2 = y + h - 1;
        g.setColor(c1);
        g.drawLine(x, y, x2 - 1, y);
        g.drawLine(x, y + 1, x, y2);
        g.setColor(c2);
        g.drawLine(x, y2, x2 - 1, y2);
        g.drawLine(x2, y, x2, y2);
    }

    public static void drawDottedRectangle(Graphics g, Rectangle r) {
        GUIUtilities.drawDottedRectangle(g, r.x, r.y, r.x + r.width, r.y + r.height);
    }

    public static void drawDottedRectangle(Graphics g, int x, int y, int x1, int y1) {
        int i1 = x;
        while (i1 <= x1) {
            g.drawLine(i1, y, i1, y);
            i1 += 2;
        }
        i1 = i1 != x1 + 1 ? y + 2 : y + 1;
        while (i1 <= y1) {
            g.drawLine(x1, i1, x1, i1);
            i1 += 2;
        }
        i1 = i1 != y1 + 1 ? x1 - 2 : x1 - 1;
        while (i1 >= x) {
            g.drawLine(i1, y1, i1, y1);
            i1 -= 2;
        }
        i1 = i1 != x - 1 ? y1 - 2 : y1 - 1;
        while (i1 >= y) {
            g.drawLine(x, i1, x, i1);
            i1 -= 2;
        }
    }

    public static void paintCross(Graphics g, Color color, int centerX, int centerY, int size, int thickness) {
        g.setColor(color);
        size /= 2;
        int i = 0;
        while (i < thickness) {
            g.drawLine(centerX - size, centerY - size, centerX + size, centerY + size);
            g.drawLine(centerX + size, centerY - size, centerX - size, centerY + size);
            ++centerX;
            ++i;
        }
    }

    public static void paintMaximize(Graphics g, Color color, int x, int y, int width, int height, int height2, int thickness) {
        g.setColor(color);
        int y2 = y + height2;
        int i = 0;
        while (i < thickness) {
            g.drawRect(x - i, y - i, width + 2 * i, height + 2 * i);
            g.drawLine(x, y2 + i, width + x, y2 + i);
            ++i;
        }
    }

    public static void paintMinimize(Graphics g, Color color, int x, int y, int width, int height, int thickness) {
        g.setColor(color);
        int i = 0;
        while (i < thickness) {
            g.drawRect(x - i, y - i, width + 2 * i, height + 2 * i);
            ++i;
        }
    }

    public static void paintRestore(Graphics g, Color color, int x, int y, int width, int height, int thickness) {
        int x2 = x + width / 2;
        int y2 = y - height / 2;
        g.setColor(color);
        int i = 0;
        while (i < thickness) {
            g.drawRect(x - i, y - i, width + 2 * i, height + 2 * i);
            g.drawRect(x2 - i, y2 - i, width + 2 * i, height + 2 * i);
            ++i;
        }
    }

    public static GradientPaint getGradientPaint(Color color1, Color color2, int orientation, Dimension d) {
        return GUIUtilities.getGradientPaint(color1, color2, orientation, 0, 0, d.width, d.height);
    }

    public static GradientPaint getGradientPaint(Color color1, Color color2, int orientation, int x, int y, int width, int height) {
        if (m_gpCache == null) {
            m_gpCache = new HashMap<Integer, GradientPaint>(20);
        }
        long l = Double.doubleToLongBits(x) + Double.doubleToLongBits(y) * 37L + Double.doubleToLongBits(width) * 43L + Double.doubleToLongBits(height) * 47L;
        Integer key = ((int)(l = 31L * l + (long)orientation) ^ (int)(l >> 32) ^ color1.hashCode() ^ color2.hashCode() * 17) * 31;
        GradientPaint gp = m_gpCache.get(key);
        if (gp == null) {
            switch (orientation) {
                case 10: {
                    gp = new GradientPaint(x, (float)height / 2.0f, color1, width, (float)height / 2.0f, color2, true);
                    break;
                }
                case 11: {
                    gp = new GradientPaint((float)width / 2.0f, y, color1, (float)width / 2.0f, height, color2, true);
                    break;
                }
                case 12: {
                    gp = new GradientPaint(x, y, color1, width, height, color2, true);
                    break;
                }
                case 13: {
                    gp = new GradientPaint(x, height, color1, width, y, color2, true);
                    break;
                }
                case 0: {
                    gp = new GradientPaint(x, y, color1, width, y, color2, true);
                    break;
                }
                default: {
                    gp = new GradientPaint(x, y, color1, x, height, color2, true);
                }
            }
            if (m_gpCache.size() > 40) {
                m_gpCache.clear();
            }
            m_gpCache.put(key, gp);
        }
        return gp;
    }

    public static boolean canSetWindowTransparency() {
        try {
            Class.forName("com.sun.awt.AWTUtilities");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setWindowTransparency(Window w, float t) {
        if (w instanceof JFrame) {
            JFrame fr = (JFrame)w;
            fr.getRootPane().putClientProperty("Window.alpha", Float.valueOf(t));
        }
        try {
            Class<?> class_ = Class.forName("com.sun.awt.AWTUtilities");
            Method m = class_.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            m.invoke(null, w, Float.valueOf(t));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Can't set window opacity: " + ex.getMessage(), ex);
        }
    }

    public static boolean isMonoSpaceFont(Font font) {
        FontRenderContext frc = new FontRenderContext(null, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT == RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT == RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Rectangle2D iBounds = font.getStringBounds("i", frc);
        Rectangle2D mBounds = font.getStringBounds("m", frc);
        return iBounds.getWidth() == mBounds.getWidth();
    }

    public static List<Font> getMonoSpaceFonts() {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        ArrayList<Font> l_monoFonts = new ArrayList<Font>();
        FontRenderContext frc = new FontRenderContext(null, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT == RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT == RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Font[] fontArray = fonts;
        int n = fonts.length;
        int n2 = 0;
        while (n2 < n) {
            Font font = fontArray[n2];
            Rectangle2D iBounds = font.getStringBounds("i", frc);
            Rectangle2D mBounds = font.getStringBounds("m", frc);
            if (iBounds.getWidth() == mBounds.getWidth()) {
                l_monoFonts.add(font);
            }
            ++n2;
        }
        return l_monoFonts;
    }

    public static String[] getStandardFontSizes() {
        return Utilities.copyOf(STANDARD_FONT_SIZES);
    }

    public static boolean isValidFont(Font font) {
        try {
            return font.canDisplay('a') && font.canDisplay('z') && font.canDisplay('A') && font.canDisplay('Z') && font.canDisplay('0') && font.canDisplay('1');
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String[] getFontStyles() {
        return Utilities.copyOf(FONT_STYLES);
    }

    public static String[] getAvailableFontFamilyNames() {
        String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        ArrayList<String> l_names = new ArrayList<String>(names.length);
        int i = 0;
        while (i < names.length) {
            int j = 0;
            while (j < HIDE_FONTS.length) {
                if (names[i].contains(HIDE_FONTS[j])) break;
                ++j;
            }
            if (j == HIDE_FONTS.length) {
                l_names.add(names[i]);
            }
            ++i;
        }
        return l_names.toArray(new String[l_names.size()]);
    }

    public static void applyStyle(ComponentStyle componentStyle, Component comp) {
        if (!(comp instanceof JComponent)) {
            return;
        }
        JComponent c = (JComponent)comp;
        if (LAFUtils.isUnderAquaLookAndFeel()) {
            c.putClientProperty("JComponent.sizeVariant", componentStyle == ComponentStyle.REGULAR ? "regular" : (componentStyle == ComponentStyle.SMALL ? "small" : "mini"));
        } else {
            c.setFont(GUIUtilities.getFont(componentStyle == ComponentStyle.REGULAR ? FontSize.NORMAL : (componentStyle == ComponentStyle.SMALL ? FontSize.SMALL : FontSize.TINY), c.getFont()));
        }
        Container p = c.getParent();
        if (p != null) {
            SwingUtilities.updateComponentTreeUI(p);
        }
    }

    public static Font getFont(FontSize size, Font base) {
        float fontSize;
        if (base == null) {
            base = LAFUtils.getLabelFont();
        }
        int defSize = base.getSize();
        switch (size) {
            case HUGE: {
                fontSize = Math.min((float)defSize + 4.0f, 18.0f);
                break;
            }
            case LARGE: {
                fontSize = Math.min((float)defSize + 2.0f, 16.0f);
                break;
            }
            case SMALL: {
                fontSize = Math.max((float)defSize - 2.0f, 11.0f);
                break;
            }
            case TINY: {
                fontSize = Math.max((float)defSize - 4.0f, 9.0f);
                break;
            }
            default: {
                fontSize = defSize;
            }
        }
        return base.deriveFont(fontSize);
    }

    public static Color getColor(ColorTone colorTone, Color base) {
        if (base == null) {
            base = LAFUtils.getLabelForeground();
        }
        switch (colorTone) {
            case BRIGHTER: {
                return new Color(Math.min(base.getRed() + 50, 255), Math.min(base.getGreen() + 50, 255), Math.min(base.getBlue() + 50, 255));
            }
            case DARKER: {
                return new Color(Math.max(base.getRed() - 50, 0), Math.max(base.getGreen() - 50, 0), Math.max(base.getBlue() - 50, 0));
            }
        }
        return base;
    }

    public static void openBrowser(URL url) throws IOException, URISyntaxException {
        GUIUtilities.openBrowser(url.toString());
    }

    public static void openBrowser(File url) throws IOException, URISyntaxException {
        GUIUtilities.openBrowser("file://" + url.getAbsolutePath());
    }

    public static void openBrowser(String url) throws IOException, URISyntaxException {
        if (Desktop.isDesktopSupported()) {
            Desktop.getDesktop().browse(new URI(url.replace('\\', '/')));
            return;
        }
        if (Platform.isWindows) {
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
        } else if (Platform.isMac) {
            Runtime.getRuntime().exec("open " + url);
        } else {
            String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
            StringBuilder cmd = new StringBuilder();
            int i = 0;
            while (i < browsers.length) {
                cmd.append(i == 0 ? "" : " || ").append(browsers[i]).append(" \"").append(url).append("\" ");
                ++i;
            }
            Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd.toString()});
        }
    }

    public static void setRenderingHints(Graphics g) {
        if (Config.JNPAD_ANTIALIAS.getValue().booleanValue()) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        }
    }

    public static enum ColorTone {
        DARKER,
        NORMAL,
        BRIGHTER;

    }

    public static enum ComponentStyle {
        REGULAR,
        SMALL,
        MINI;

    }

    public static enum FontSize {
        TINY,
        SMALL,
        NORMAL,
        LARGE,
        HUGE;

    }

    public static class StringConversion
    implements Serializable {
        private String _text;
        private LineSeparator _lineSeparator;
        private String _result;
        private boolean _removeEndSpaces;
        private int _lineCount;
        private int _tabSize;
        private static final long serialVersionUID = -2212834676400691876L;

        public StringConversion(String text, boolean removeEndSpaces) {
            this(text, removeEndSpaces, Config.TEXT_TAB_ENABLED.getValue() == false ? Config.TEXT_TAB_SIZE.getValue() : -1);
        }

        public StringConversion(String text, boolean removeEndSpaces, int tabSize) {
            this._text = text;
            this._removeEndSpaces = removeEndSpaces;
            this._tabSize = tabSize;
        }

        public void convert() {
            this.detectEOL();
            this.convertText();
        }

        public void detectEOL() {
            int len = this._text.length();
            boolean CRLF = false;
            boolean CROnly = false;
            boolean lastWasCR = false;
            this._lineCount = 0;
            int lastLine = 0;
            int i = 0;
            while (i < len) {
                switch (this._text.charAt(i)) {
                    case '\r': {
                        if (lastWasCR) {
                            CROnly = true;
                            CRLF = false;
                        } else {
                            lastWasCR = true;
                        }
                        ++this._lineCount;
                        lastLine = i + 1;
                        break;
                    }
                    case '\n': {
                        if (lastWasCR) {
                            CROnly = false;
                            CRLF = true;
                            lastWasCR = false;
                            lastLine = i + 1;
                            break;
                        }
                        CROnly = false;
                        CRLF = false;
                        ++this._lineCount;
                        lastLine = i + 1;
                        break;
                    }
                    default: {
                        if (!lastWasCR) break;
                        CROnly = true;
                        CRLF = false;
                        lastWasCR = false;
                    }
                }
                ++i;
            }
            if (this._lineCount != 0) {
                ++this._lineCount;
            }
            this._lineSeparator = this._lineCount == 0 ? LineSeparator.getDefault() : (CRLF ? LineSeparator.DOS : (CROnly ? LineSeparator.MAC : LineSeparator.UNIX));
        }

        public void convertText() {
            StringBuilder sb = new StringBuilder(this._text.length());
            char[] tab = Utilities.spaces(this._tabSize).toCharArray();
            int j = 0;
            int c = 65535;
            try {
                block7: while (j < this._text.length()) {
                    int k = c;
                    if (k != 65535) {
                        c = 65535;
                    } else {
                        k = this._text.charAt(j++);
                    }
                    if ((k == 10 || k == 13) && this._removeEndSpaces) {
                        int l = sb.length() - 1;
                        while (l >= 0 && sb.charAt(l) == ' ') {
                            sb.deleteCharAt(l--);
                        }
                    }
                    switch (k) {
                        case 13: {
                            if (j < this._text.length() && (c = (int)this._text.charAt(j++)) == 10) {
                                c = 65535;
                            }
                        }
                        case 10: {
                            sb.append('\n');
                            continue block7;
                        }
                        case 9: {
                            if (this._tabSize > 0) {
                                sb.append(tab);
                                continue block7;
                            }
                            sb.append('\t');
                            continue block7;
                        }
                    }
                    sb.append((char)k);
                }
                if (this._removeEndSpaces) {
                    int i = sb.length() - 1;
                    while (i >= 0 && sb.charAt(i) == ' ') {
                        sb.deleteCharAt(i--);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._result = sb.toString();
        }

        public LineSeparator getLineSeparator() {
            return this._lineSeparator;
        }

        public String getResult() {
            return this._result;
        }

        public String getText() {
            return this._text;
        }

        public boolean isRemoveEndSpacesEnabled() {
            return this._removeEndSpaces;
        }

        public void setRemoveEndSpacesEnabled(boolean b) {
            this._removeEndSpaces = b;
        }

        public int getLineCount() {
            return this._lineCount;
        }

        public String toString() {
            return this._result;
        }
    }
}

