/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.Box;
import com.sonoransoft.codequill.CqOptionDialog;
import com.sonoransoft.codequill.HelpDialog;
import com.sonoransoft.codequill.Options;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

class PrintOptionDialog
extends CqOptionDialog {
    Choice leftMargin;
    Choice rightMargin;
    Choice topMargin;
    Choice bottomMargin;
    Checkbox printFileName;
    Checkbox printPageNumbers;
    Checkbox printLineNumbers;
    Checkbox printFontBold;
    Choice pointSize;
    Options options;

    public PrintOptionDialog(Frame frame, Options options) {
        super(frame, "CodeQuill Print Options", true);
        this.options = options;
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2));
        Panel panel2 = new Panel();
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(4, 2));
        panel3.add(new Label("Top:  ", 2));
        this.topMargin = new Choice();
        this.addMarginChoices(this.topMargin);
        this.topMargin.select(Double.toString(options.getPrintTopMargin()));
        panel3.add(this.topMargin);
        panel3.add(new Label("Bottom:  ", 2));
        this.bottomMargin = new Choice();
        this.addMarginChoices(this.bottomMargin);
        this.bottomMargin.select(Double.toString(options.getPrintBottomMargin()));
        panel3.add(this.bottomMargin);
        panel3.add(new Label("Left:  ", 2));
        this.leftMargin = new Choice();
        this.addMarginChoices(this.leftMargin);
        this.leftMargin.select(Double.toString(options.getPrintLeftMargin()));
        panel3.add(this.leftMargin);
        panel3.add(new Label("Right:  ", 2));
        this.rightMargin = new Choice();
        this.addMarginChoices(this.rightMargin);
        this.rightMargin.select(Double.toString(options.getPrintRightMargin()));
        panel3.add(this.rightMargin);
        Box box = new Box((Component)panel3, "Margins");
        panel2.add("North", box);
        panel.add(panel2);
        Panel panel4 = new Panel();
        Panel panel5 = new Panel();
        panel5.setLayout(new GridLayout(5, 1));
        this.printFileName = new Checkbox("File name", options.isPrintFileName());
        panel5.add(this.printFileName);
        this.printPageNumbers = new Checkbox("Page numbers", options.isPrintPageNumbers());
        panel5.add(this.printPageNumbers);
        this.printLineNumbers = new Checkbox("Line numbers", options.isPrintLineNumbers());
        panel5.add(this.printLineNumbers);
        this.printFontBold = new Checkbox("Bold", options.isPrintFontBold());
        panel5.add(this.printFontBold);
        Panel panel6 = new Panel();
        panel6.setLayout(new GridLayout(1, 2));
        panel6.add(new Label("Point size:  ", 2));
        this.pointSize = new Choice();
        this.pointSize.add("8");
        this.pointSize.add("9");
        this.pointSize.add("10");
        this.pointSize.add("11");
        this.pointSize.add("12");
        this.pointSize.add("13");
        this.pointSize.add("14");
        this.pointSize.add("15");
        this.pointSize.add("16");
        this.pointSize.add("17");
        this.pointSize.add("18");
        this.pointSize.add("20");
        this.pointSize.add("24");
        this.pointSize.select(Integer.toString(options.getPrintFontPoint()));
        panel6.add(this.pointSize);
        panel5.add(panel6);
        Box box2 = new Box((Component)panel5, "General");
        panel4.add("North", box2);
        panel.add(panel4);
        this.add("Center", panel);
        this.pack();
        this.setResizable(false);
        this.centerDialog();
    }

    private void addMarginChoices(Choice choice) {
        choice.add(Double.toString(0.0));
        choice.add(Double.toString(0.25));
        choice.add(Double.toString(0.5));
        choice.add(Double.toString(0.75));
        choice.add(Double.toString(1.0));
    }

    public boolean updateOptions() {
        this.options.setPrintTopMargin(new Double(this.topMargin.getSelectedItem()));
        this.options.setPrintBottomMargin(new Double(this.bottomMargin.getSelectedItem()));
        this.options.setPrintLeftMargin(new Double(this.leftMargin.getSelectedItem()));
        this.options.setPrintRightMargin(new Double(this.rightMargin.getSelectedItem()));
        this.options.setPrintFileName(this.printFileName.getState());
        this.options.setPrintPageNumbers(this.printPageNumbers.getState());
        this.options.setPrintLineNumbers(this.printLineNumbers.getState());
        this.options.setPrintFontBold(this.printFontBold.getState());
        this.options.setPrintFontPoint(new Integer(this.pointSize.getSelectedItem()));
        return true;
    }

    public void displayHelp() {
        HelpDialog helpDialog = new HelpDialog(this.parent, "Print options help", "PrintOptionsDialogHelp.txt");
        helpDialog.setVisible(true);
        helpDialog.dispose();
    }
}

