/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.DrawnRectangle;
import com.sonoransoft.codequill.Etching;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

public class EtchedRectangle
extends DrawnRectangle {
    protected static Etching _defaultEtching = Etching.IN;
    private Etching etching;

    public EtchedRectangle(Component component) {
        this(component, _defaultEtching, DrawnRectangle._defaultThickness, 0, 0, 0, 0);
    }

    public EtchedRectangle(Component component, int n) {
        this(component, _defaultEtching, n, 0, 0, 0, 0);
    }

    public EtchedRectangle(Component component, int n, int n2, int n3, int n4) {
        this(component, _defaultEtching, DrawnRectangle._defaultThickness, n, n2, n3, n4);
    }

    public EtchedRectangle(Component component, int n, int n2, int n3, int n4, int n5) {
        this(component, _defaultEtching, n, n2, n3, n4, n5);
    }

    public EtchedRectangle(Component component, Etching etching, int n, int n2, int n3, int n4, int n5) {
        super(component, n, n2, n3, n4, n5);
        this.etching = etching;
    }

    public void etchedIn() {
        this.etching = Etching.IN;
    }

    public void etchedOut() {
        this.etching = Etching.OUT;
    }

    public boolean isEtchedIn() {
        return this.etching == Etching.IN;
    }

    public void paint() {
        if (this.etching == Etching.IN) {
            this.paintEtchedIn();
        } else {
            this.paintEtchedOut();
        }
    }

    public void paintEtchedIn() {
        Graphics graphics = this.drawInto.getGraphics();
        if (graphics != null) {
            this.paintEtched(graphics, this.getLineColor(), this.brighter());
        }
        this.etchedIn();
    }

    public void paintEtchedOut() {
        Graphics graphics = this.drawInto.getGraphics();
        if (graphics != null) {
            this.paintEtched(graphics, this.brighter(), this.getLineColor());
        }
        this.etchedOut();
    }

    public String paramString() {
        return super.paramString() + "," + this.etching;
    }

    private void paintEtched(Graphics graphics, Color color, Color color2) {
        int n = this.getThickness();
        int n2 = this.width - n;
        int n3 = this.height - n;
        graphics.setColor(color);
        int n4 = 0;
        while (n4 < n / 2) {
            graphics.drawRect(this.x + n4, this.y + n4, n2, n3);
            ++n4;
        }
        graphics.setColor(color2);
        int n5 = 0;
        while (n5 < n / 2) {
            graphics.drawRect(this.x + n / 2 + n5, this.y + n / 2 + n5, n2, n3);
            ++n5;
        }
    }
}

