/*
 * Decompiled with CFR 0.152.
 */
package com.sonoransoft.codequill;

import com.sonoransoft.codequill.CursorTimer;
import com.sonoransoft.codequill.TimerListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

class EditCursor
implements TimerListener {
    public static final int VERTICAL_BAR = 0;
    public static final int UNDERLINE = 1;
    private int cursorHeight;
    private int cursorVerticalOffset;
    private int cursorWidth;
    private boolean displayed = false;
    private boolean blinkEnabled = false;
    private boolean enabled = false;
    private Rectangle cursor;
    private Canvas canvas;
    private CursorTimer timer;

    public EditCursor(Canvas canvas) {
        this.canvas = canvas;
        this.cursor = new Rectangle();
        this.timer = CursorTimer.getCursorTimer();
        this.blinkEnabled = false;
        this.timer.addTimerListener(this);
    }

    public void processTimerEvent() {
        this.blinkCursor();
    }

    public void setBlinkEnabled(boolean bl) {
        this.blinkEnabled = bl;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void erase(Graphics graphics) {
        this.drawCursor(graphics, this.cursor, true);
    }

    public void erase() {
        this.drawCursor(null, this.cursor, true);
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.erase(graphics);
        if (this.enabled) {
            this.cursor.height = this.cursorHeight;
            this.cursor.width = this.cursorWidth;
            this.cursor.x = n;
            this.cursor.y = n2 - this.cursorVerticalOffset;
            this.drawCursor(graphics, this.cursor, false);
        }
    }

    public void reset() {
        this.displayed = false;
    }

    public void kill() {
        this.timer.removeTimerListener(this);
    }

    private void blinkCursor() {
        if (!this.blinkEnabled || !this.enabled) {
            return;
        }
        this.drawCursor(null, this.cursor, false);
    }

    private synchronized void drawCursor(Graphics graphics, Rectangle rectangle, boolean bl) {
        boolean bl2 = false;
        if (bl && !this.displayed) {
            return;
        }
        if (graphics == null) {
            graphics = this.canvas.getGraphics();
            if (graphics == null) {
                return;
            }
            bl2 = true;
        }
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setPaintMode();
        boolean bl3 = this.displayed = !this.displayed;
        if (bl2) {
            graphics.dispose();
        }
    }

    public void setStyle(int n, FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            return;
        }
        switch (n) {
            case 1: {
                this.cursorVerticalOffset = 0;
                this.cursorHeight = fontMetrics.getHeight() / 5;
                this.cursorWidth = fontMetrics.charWidth('a');
                break;
            }
            default: {
                this.cursorVerticalOffset = fontMetrics.getAscent();
                this.cursorHeight = fontMetrics.getHeight();
                this.cursorWidth = fontMetrics.charWidth('a') / 4;
            }
        }
        if (this.cursorWidth == 0) {
            this.cursorWidth = 1;
        }
        if (this.cursorHeight <= 1) {
            this.cursorHeight = 2;
        }
    }
}

