package de.beagtex.listener.insert;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFileChooser;

import de.beagtex.gui.Editor;
import de.beagtex.gui.MyGraphicsChooser;

/**
 * Listener for inserting a graphic in LaTex-Code; calls a FileChooser
 * 
 * @author Benjamin Haag
 * 
 */
public class GraphicListener implements ActionListener {

	Editor editor;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor
	 */
	public GraphicListener(Editor editor) {

		this.editor = editor;
	}

	public void actionPerformed(ActionEvent e) {

		editor.insert("\\begin{figure}[h]" + "\r\n" + "\\includegraphics{"
				+ getFile() + "}" + "\r\n"
				+ "%YOU CAN INSERT A CAPTION FOR YOUR GRAPHIC HERE! " + "\r\n"
				+ "\\end{figure}", editor.getCaretPosition());
	}

	/**
	 * Opens a FileChooser
	 * 
	 * @return file: Filename
	 */
	public String getFile() {
		String file = "FILENAME";
		JFileChooser choosy = new MyGraphicsChooser(editor);
		choosy.setCurrentDirectory(choosy.getCurrentDirectory());
		choosy.setVisible(true);
		if (choosy.getSelectedFile() != null)
			file = choosy.getSelectedFile().getName();
		return file;
	}
}
