package de.beagtex.listener.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JOptionPane;

import de.beagtex.gui.BFrame;
import de.beagtex.gui.Editor;

/**
 * Listener for Infos
 * 
 * @author Benjamin Haag
 * 
 */
public class InfoListener implements ActionListener {

	Editor editor;
	BFrame bFrame;
	String source;

	/**
	 * Constructor
	 * 
	 * @param pEditor:
	 *            The calling Editor-object
	 * @paran pSource : String with source ("Info" or "Credits")
	 * 
	 */
	public InfoListener(Editor pEditor, String pSource) {

		this.editor = pEditor;
		bFrame = pEditor.getBFrame();
		this.source = pSource;
	}

	public void actionPerformed(ActionEvent arg0) {

		if ("Credits".equalsIgnoreCase(source)) {
			showCreditsMessage();
		} else {
			showInfoMessage();
		}
	}

	/**
	 * Shows Info-Message
	 */
	public static void showInfoMessage() {
		 String info = BFrame.get_prop().getProperty(
		 "beagtex.menu.help.info.text");
		 JOptionPane.showMessageDialog(null, info, "BeaGTex - Info",
		 JOptionPane.INFORMATION_MESSAGE);
//		JOptionPane.showMessageDialog(null, "BeaGTex Version 1.2" + "\r\n"
//				+ "Copyright 2007 Benjamin Haag" + "\r\n"
//				+ "--------------------------------------------------------"
//				+ "\r\n" + "Concept, Layout, Implementation:" + "\r\n"
//				+ " Benjamin Haag" + "\r\n"
//				+ "--------------------------------------------------------"
//				+ "\r\n" + "JUnit - Tests:" + "\r\n" + " Evan Ossher" + "\r\n"
//				+ "--------------------------------------------------------"
//				+ "\r\n" + "Tranalations:" + "\r\n" + " Morais David" + "\r\n"
//				+ "--------------------------------------------------------"
//				+ "\r\n" + "Questions, Critics or suggestions? " + "\r\n"
//				+ " mailto: beagtex@gmx.de" + "\r\n"
//				+ "--------------------------------------------------------"
//				+ "\r\n" + "beagtex.sourceforge.net", "BeaGTex - Info",
//				JOptionPane.INFORMATION_MESSAGE);
	}

	/**
	 * Shows Credits
	 */
	public static void showCreditsMessage() {
		String credits = BFrame.get_prop().getProperty(
				"beagtex.menu.help.credits.text");
		JOptionPane.showMessageDialog(null, credits, "BeaGTex - Credits",
				JOptionPane.INFORMATION_MESSAGE);
//		 JOptionPane
//				.showMessageDialog(
//						null,
//						"--------------------------------------------------------"
//								+ "\r\n"
//								+ "Graphics-Layout and -Design: "
//								+ "\r\n"
//								+ " Katharina Specht"
//								+ "\r\n"
//								+ " www.tarico.de"
//								+ "\r\n"
//								+ "--------------------------------------------------------"
//								+ "\r\n"
//								+ "Structure for Splash-Screen-Graphic: "
//								+ "\r\n"
//								+ " \"simple patterns\" by "
//								+ "\r\n"
//								+ " die-for-love.deviantarts.com"
//								+ "\r\n"
//								+ "--------------------------------------------------------"
//								+ "\r\n" + "beagtex.sourceforge.net" + "\r\n"
//								+ "beagtex@gmx.de", "BeaGTex - Credits",
//						JOptionPane.INFORMATION_MESSAGE);
	}
}
