package de.beagtex.gui;

import java.io.File;

import javax.swing.JFileChooser;

import de.beagtex.control.ExampleFileFilter;

/**
 * JFileChooser for Tex-Files
 * 
 * @author Benjamin Haag
 */
public class MyOpenChooser extends JFileChooser {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	Editor editor;
	File currentDirectory;

	/**
	 * Constructor
	 * 
	 * @param editor:
	 *            the calling editor-object
	 */
	public MyOpenChooser(Editor editor) {
		this.editor = editor;
		ExampleFileFilter filter = new ExampleFileFilter("tex");
		setFileFilter(filter);
		setCurrentDirectory(getCurrentDirectory());
		int returnVal = showOpenDialog(getParent());
		// int returnVal = showSaveDialog(getParent());
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			System.out.println(getSelectedFile().getName());
		}
	}
}
