/*
 * Decompiled with CFR 0.152.
 */
package de.beagtex.gui;

import de.beagtex.gui.BFrame;
import de.beagtex.listener.format.BGColorListener;
import de.beagtex.listener.format.FormatListener;
import de.beagtex.listener.format.StandardColorsListener;
import de.beagtex.listener.format.TextSizeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class FormatBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    JComboBox cbBgColors;
    JComboBox cbSize;
    JComboBox cbColors;
    JComboBox cbFormats;
    BFrame bFrame;

    public FormatBar(BFrame pBFrame, int pOrientation) {
        super(pOrientation);
        this.bFrame = pBFrame;
        this.createContent(this);
    }

    private void createContent(FormatBar pFL) {
        String[] textSize = new String[]{"tiny", "scriptsize", "footnotesize", "small", "normalsize", "large", "Large", "LARGE", "huge", "Huge"};
        this.cbSize = new JComboBox<String>(textSize);
        JLabel lSize = new JLabel(String.valueOf(BFrame.get_prop().getProperty("beagtex.format.size")) + "  ");
        this.cbSize.addActionListener(new TextSizeListener(this.bFrame.getEdit()));
        String[] formats = new String[]{"part", "part*", "chapter (book, report)", "chapter* (book, report)", "section", "section*", "subsection", "subsection*", "subsubsection", "subsubsection*"};
        this.cbFormats = new JComboBox<String>(formats);
        JLabel lFormats = new JLabel("  " + BFrame.get_prop().getProperty("beagtex.format.formats") + "   ");
        this.cbFormats.addActionListener(new FormatListener(this.bFrame.getEdit()));
        String[] colors = new String[]{"red", "yellow", "green", "blue", "black", "white"};
        this.cbColors = new JComboBox<String>(colors);
        JLabel lColors = new JLabel("  " + BFrame.get_prop().getProperty("beagtex.format.textcolor") + "  ");
        this.cbColors.addActionListener(new StandardColorsListener(this.bFrame.getEdit()));
        this.cbBgColors = new JComboBox<String>(colors);
        JLabel bgColorL = new JLabel("   " + BFrame.get_prop().getProperty("beagtex.format.bgcolor") + "  ");
        this.cbBgColors.addActionListener(new BGColorListener(this.bFrame.getEdit()));
        pFL.add(lSize);
        pFL.add(this.cbSize);
        pFL.add(lFormats);
        pFL.add(this.cbFormats);
        pFL.add(lColors);
        pFL.add(this.cbColors);
        pFL.add(bgColorL);
        pFL.add(this.cbBgColors);
    }

    private void createContent(FormatBar pFL, boolean isGerman) {
        String[] textSize = new String[]{"tiny", "scriptsize", "footnotesize", "small", "normalsize", "large", "Large", "LARGE", "huge", "Huge"};
        this.cbSize = new JComboBox<String>(textSize);
        JLabel lSize = new JLabel("TextSize ");
        this.cbSize.addActionListener(new TextSizeListener(this.bFrame.getEdit()));
        String[] formats = new String[]{"part", "part*", "chapter (book, report)", "chapter* (book, report)", "section", "section*", "subsection", "subsection*", "subsubsection", "subsubsection*"};
        this.cbFormats = new JComboBox<String>(formats);
        JLabel lFormats = new JLabel("    Formats ");
        this.cbFormats.addActionListener(new FormatListener(this.bFrame.getEdit()));
        String[] colors = new String[]{"red", "yellow", "green", "blue", "black", "white"};
        this.cbColors = new JComboBox<String>(colors);
        JLabel lColors = new JLabel("    Text-Color ");
        this.cbColors.addActionListener(new StandardColorsListener(this.bFrame.getEdit()));
        this.cbBgColors = new JComboBox<String>(colors);
        JLabel bgColorL = new JLabel("    Background-Color ");
        this.cbBgColors.addActionListener(new BGColorListener(this.bFrame.getEdit()));
        pFL.add(lSize);
        pFL.add(this.cbSize);
        pFL.add(lFormats);
        pFL.add(this.cbFormats);
        pFL.add(lColors);
        pFL.add(this.cbColors);
        pFL.add(bgColorL);
        pFL.add(this.cbBgColors);
    }

    public JComboBox getCbBgColors() {
        return this.cbBgColors;
    }

    public JComboBox getCbSize() {
        return this.cbSize;
    }

    public JComboBox getCbColors() {
        return this.cbColors;
    }

    public JComboBox getCbFormats() {
        return this.cbFormats;
    }
}

