/*
 * Decompiled with CFR 0.152.
 */
package de.beagtex.gui;

import de.beagtex.control.FileWorkMethods;
import de.beagtex.control.RedoAction;
import de.beagtex.control.UndoAction;
import de.beagtex.gui.BWindow;
import de.beagtex.gui.ButtonBar;
import de.beagtex.gui.Editor;
import de.beagtex.gui.FormatBar;
import de.beagtex.gui.LanguageChoiceWindow;
import de.beagtex.gui.MainMenu;
import de.beagtex.gui.StartChoiceWindow;
import de.beagtex.listener.gui.MyWindowListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.TextAction;

public class BFrame
extends BWindow {
    private static final long serialVersionUID = 1L;
    Editor edit;
    ButtonBar blButtons;
    FormatBar formate;
    Hashtable commands = null;
    public UndoAction undoAction = new UndoAction(this.edit);
    public RedoAction redoAction = new RedoAction(this.edit);
    private Action[] defaultActions = new Action[]{this.undoAction, this.redoAction};
    private static String language = "";
    private static final String BEAGTEX_DEFAULT_PROP = "data/text_engl.properties";
    private static final String BEAGTEX_GER_PROP = "data/text_ger.properties";
    private static Properties _prop = new Properties();

    public BFrame() {
        this.setTitle("BeaGTex");
        this.setSize(850, 625);
        this.addWindowListener(new MyWindowListener(this));
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        BFrame.setLanguage(this.readLanguageFile());
        String lang = BFrame.getLanguage();
        if (lang.equalsIgnoreCase("first")) {
            this.loadProperties(BEAGTEX_GER_PROP);
        } else if (lang.equalsIgnoreCase("German")) {
            this.loadProperties(BEAGTEX_GER_PROP);
        } else {
            this.loadProperties(BEAGTEX_DEFAULT_PROP);
        }
        this.edit = new Editor(this);
        Hashtable<Object, Action> commands = new Hashtable<Object, Action>();
        Action[] actions = this.edit.getActions();
        int i = 0;
        while (i < actions.length) {
            Action a = actions[i];
            commands.put(a.getValue("Name"), a);
            ++i;
        }
        JScrollPane pEdit = new JScrollPane(this.edit);
        this.setContentPane(pEdit);
        JPanel pan = new JPanel();
        pan.setLayout(new FlowLayout(-1));
        pan.add(new MainMenu(this));
        this.setContentPane(pan);
        this.blButtons = new ButtonBar(this, 1);
        this.setContentPane(this.blButtons);
        this.formate = new FormatBar(this, 0);
        this.setContentPane(this.formate);
        JToolBar tbLinks = new JToolBar(1);
        this.setContentPane(tbLinks);
        Container conty = new Container();
        conty.setLayout(new BorderLayout());
        conty.add((Component)pEdit, "Center");
        conty.add((Component)pan, "North");
        conty.add((Component)this.blButtons, "East");
        conty.add((Component)this.formate, "South");
        conty.add((Component)tbLinks, "West");
        this.setContentPane(conty);
    }

    public static void main(String[] args) {
        BFrame test = new BFrame();
        test.setVisible(true);
    }

    public static void start(BFrame pStartFrame) {
        StartChoiceWindow starty = new StartChoiceWindow(pStartFrame);
        starty.show(400, 150);
    }

    public static void startLangChoice() {
        BFrame startFrame = new BFrame();
        BFrame.setLanguage(startFrame.readLanguageFile());
        String lang = BFrame.getLanguage();
        if (lang.equalsIgnoreCase("first")) {
            LanguageChoiceWindow lcw = new LanguageChoiceWindow(startFrame);
            lcw.show(200, 100);
        } else if (lang.equalsIgnoreCase("German")) {
            startFrame.loadProperties(BEAGTEX_GER_PROP);
            _prop.toString();
            BFrame.start(startFrame);
        } else {
            startFrame.loadProperties(BEAGTEX_DEFAULT_PROP);
            _prop.toString();
            BFrame.start(startFrame);
        }
    }

    private String readLanguageFile() {
        String lang = "";
        try {
            StringBuffer buffy = FileWorkMethods.createStringBufferFromFile("data/lang.txt");
            lang = buffy.toString();
            StringTokenizer toky = new StringTokenizer(lang);
            lang = toky.nextToken();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lang;
    }

    private void loadProperties(String pProperties) {
        try {
            _prop.clear();
            if (pProperties.equals("")) {
                _prop.load(ClassLoader.getSystemResourceAsStream(BEAGTEX_DEFAULT_PROP));
            } else {
                _prop.load(new FileInputStream(new File(pProperties)));
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Action[] getActions() {
        return TextAction.augmentList(this.edit.getActions(), this.defaultActions);
    }

    public Editor getEdit() {
        return this.edit;
    }

    public ButtonBar getBlButtons() {
        return this.blButtons;
    }

    public FormatBar getFormate() {
        return this.formate;
    }

    public static String getLanguage() {
        return language;
    }

    public static void setLanguage(String pLanguage) {
        language = pLanguage;
    }

    public static Properties get_prop() {
        return _prop;
    }
}

