/*
 * Decompiled with CFR 0.152.
 */
package bin;

import bin.Display;
import bin.Language;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class FontChooser
extends JFrame {
    private static final long serialVersionUID = -2199129831318388166L;
    private static boolean chooserOpen = false;

    public FontChooser(final Display callerObject, String defaultFont) {
        chooserOpen = true;
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                chooserOpen = false;
                FontChooser.this.dispose();
            }
        });
        this.setLayout(new FlowLayout());
        this.add(new JLabel(Language.getText(7)));
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        final JComboBox<String> fonts = new JComboBox<String>(gEnv.getAvailableFontFamilyNames());
        fonts.setSelectedItem(defaultFont);
        fonts.setMaximumRowCount(5);
        this.add(fonts);
        this.add(new JLabel(Language.getText(8)));
        String[] styleNames = new String[]{Language.getText(9), Language.getText(10), Language.getText(11), Language.getText(12)};
        final JComboBox<String> styles = new JComboBox<String>(styleNames);
        this.add(styles);
        this.add(new JLabel(Language.getText(13)));
        final JSpinner sizes = new JSpinner(new SpinnerNumberModel(12, 6, 36, 1));
        this.add(sizes);
        JButton apply = new JButton(Language.getText(14));
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                callerObject.changeFont(new Font((String)fonts.getSelectedItem(), styles.getSelectedIndex(), Integer.parseInt(sizes.getModel().getValue().toString())));
                chooserOpen = false;
                FontChooser.this.dispose();
            }
        });
        this.add(apply);
        this.pack();
    }

    public static boolean isAlreadyOpen() {
        return chooserOpen;
    }
}

