/*
 * Decompiled with CFR 0.152.
 */
package bin;

import bin.AnimatedNotifier;
import bin.Configurations;
import bin.Language;
import bin.Menu;
import bin.Paginator;
import bin.ReadFiles;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferStrategy;
import java.io.File;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Display
extends JFrame
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -2504741879991406219L;
    private Thread relaxLoop;
    private static final AnimatedNotifier fntNotify = new AnimatedNotifier("fnt");
    private static final AnimatedNotifier readNotify = new AnimatedNotifier("readin");
    public static final int PAGEWIDTH = 500;
    public static final int PAGEHEIGHT = 700;
    private static final int marginH = 50;
    private static final int marginV = 70;
    private Configurations cf;
    private Image BGImage;
    private BufferStrategy bs = null;
    private Paginator paginator = null;
    private String cont;
    private Menu menu;
    private String currentPage;
    private Point location;
    private MouseEvent pressed;
    private int relaxVal = 128;

    public Display() {
        super(Language.getText(4));
        this.setSize(500, 700);
        this.setResizable(false);
        this.setUndecorated(true);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        readNotify.start();
        this.cf = new Configurations();
        this.cf.loadConfigurations();
        this.menu = new Menu(this, this.cf);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ev) {
                Display.this.pressKey(ev);
            }
        });
        this.createRelaxLoop();
        try {
            this.BGImage = ImageIO.read(new File(this.cf.getBGImagePath()));
        }
        catch (Exception ex) {
            this.BGImage = null;
        }
        try {
            this.cont = ReadFiles.readPlainFile(this.cf.getBookPath());
        }
        catch (Exception e) {
            this.cont = Language.getHelp();
        }
        readNotify.stop();
        this.changeFont(this.cf.getFont());
    }

    public void createRelaxLoop() {
        this.relaxLoop = new Thread(){

            @Override
            public void run() {
                while (Display.this.isVisible()) {
                    if (Display.this.cf.getRelax()) {
                        Display.this.relaxVal = Display.this.relaxVal + 1 & 0xFF;
                        Display.this.repaint();
                    }
                    AnimatedNotifier.wait(50);
                }
            }
        };
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && !this.relaxLoop.isAlive()) {
            this.createRelaxLoop();
            this.relaxLoop.start();
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.pressed = me;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.location = this.getLocation(this.location);
        if (this.menu.isIdle(this.pressed)) {
            int x = this.location.x - this.pressed.getX() + me.getX();
            int y = this.location.y - this.pressed.getY() + me.getY();
            this.setLocation(x, y);
        }
        me.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.menu.mouseReleased(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.menu.mouseMoved(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void paint(Graphics gee) {
        try {
            this.bs = this.getBufferStrategy();
            Graphics g = this.bs.getDrawGraphics();
            this.draw(g);
            g.dispose();
            this.bs.show();
        }
        catch (Exception e) {
            this.draw(gee);
        }
    }

    private void draw(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(this.cf.getBackColor());
        g2d.fillRect(0, 0, 500, 700);
        if (this.BGImage != null && this.cf.isUseBGImage()) {
            g2d.drawImage(this.BGImage, 0, 0, 500, 700, null);
        }
        this.printPage(g2d, this.currentPage);
        if (this.cf.getRelax()) {
            g2d.setColor(new Color(0, 0, 0, this.relaxVal > 128 ? this.relaxVal - 128 : 128 - this.relaxVal));
            g2d.fillRect(0, 0, 500, 700);
        }
        this.menu.render(g2d);
    }

    public void changeFont(Font font) {
        this.changeFont(this.cont, font);
    }

    private void changeFont(final String content, final Font font) {
        if (font.equals(this.getFont())) {
            return;
        }
        fntNotify.start();
        this.setVisible(false);
        this.setFont(font);
        this.cf.setFont(font);
        this.updateConfig();
        new Thread(){

            @Override
            public void run() {
                FontMetrics metrics = Display.this.getFontMetrics(font);
                Display.this.paginator = new Paginator(content, metrics, 400, 560);
                Display.this.currentPage = Display.this.paginator.getPage(Display.this.cf.getPageNum());
                fntNotify.stop();
                Display.this.setVisible(true);
                Display.this.createBufferStrategy(2);
                Display.this.repaint();
            }
        }.start();
    }

    private void printPage(Graphics2D g2d, String bufferText) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        g2d.setFont(this.getFont());
        g2d.setColor(this.cf.getFontColor());
        int spaceRemaining = 400;
        int h = metrics.getAscent();
        StringTokenizer sT = new StringTokenizer(bufferText, "\n\t", true);
        while (sT.hasMoreTokens()) {
            String nT = sT.nextToken();
            if (nT.equals("\n")) {
                spaceRemaining = 400;
                h += metrics.getAscent();
                continue;
            }
            if (nT.equals("\t")) {
                spaceRemaining = (spaceRemaining * 10 - 1) / 400 * 400 / 10;
                continue;
            }
            g2d.drawString(nT, 500 - (spaceRemaining + 50), h + 70);
            spaceRemaining -= metrics.stringWidth(nT);
        }
        String pageNumString = String.valueOf(this.paginator.getCurrentPageNum() + 1) + "/" + this.paginator.getPageCount();
        g2d.drawString(pageNumString, 500 - metrics.stringWidth(pageNumString) - 50, 70 - metrics.getAscent());
    }

    public void updateConfig() {
        this.cf.setFont(this.getFont());
        this.cf.saveConfigurations();
    }

    public void prevPage() {
        this.currentPage = this.paginator.getPrevPage();
        this.updatePageChange();
    }

    public void nextPage() {
        this.currentPage = this.paginator.getNextPage();
        this.updatePageChange();
    }

    public void lastPage() {
        this.currentPage = this.paginator.getPage(this.paginator.getPageCount() - 1);
        this.updatePageChange();
    }

    public void firstPage() {
        this.currentPage = this.paginator.getPage(0);
        this.updatePageChange();
    }

    public void toPage(int i) {
        this.currentPage = this.paginator.getPage(i);
        this.updatePageChange();
    }

    private void updatePageChange() {
        this.repaint();
        this.cf.setPageNum(this.paginator.getCurrentPageNum());
        this.updateConfig();
    }

    public void changeBGImage() {
        int returnVal = -1;
        JFileChooser chooser = new JFileChooser("./images/backgrounds/");
        chooser.setFileFilter(new FileNameExtensionFilter(String.valueOf(Language.getText(1)) + " (Gif, Png, Jpg, Png)", "gif", "jpg", "bmp", "png"));
        returnVal = chooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        this.setBGImage(chooser.getSelectedFile().getPath());
        this.repaint();
        this.updateConfig();
    }

    public void setBGImage(String tempPath) {
        try {
            this.BGImage = ImageIO.read(new File(tempPath));
            this.cf.setBGImagePath(tempPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pressKey(KeyEvent ev) {
        if (ev.getKeyCode() == 37 || ev.getKeyCode() == 38) {
            this.prevPage();
        } else if (ev.getKeyCode() == 39 || ev.getKeyCode() == 40) {
            this.nextPage();
        } else if (ev.getKeyCode() == 27) {
            System.exit(0);
        } else if (ev.getKeyCode() == 82) {
            this.relaxVal = 128;
            this.cf.setRelax(!this.cf.getRelax());
            this.repaint();
            this.updateConfig();
        }
    }
}

