/*
 * Decompiled with CFR 0.152.
 */
package xBaseJ;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import xBaseJ.xBaseJException;

public abstract class Field
implements Cloneable {
    protected String Name;
    protected int Length;
    protected byte[] buffer;
    protected boolean Deleted;
    protected RandomAccessFile file;

    protected Object clone() throws CloneNotSupportedException {
        Field field = (Field)super.clone();
        field.Name = new String(this.Name);
        field.Length = this.Length;
        return field;
    }

    private void validateName(String string) throws xBaseJException {
        if (string == null) {
            throw new xBaseJException("Missing field name");
        }
        if (string.length() == 0) {
            throw new xBaseJException("Missing field name");
        }
        if (string.length() > 10) {
            throw new xBaseJException("Invalid field name " + string);
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isLetter(string.charAt(n)) && !Character.isDigit(string.charAt(n)) && string.charAt(n) != '_') {
                throw new xBaseJException("Invalid field name " + string + ", character invalid at " + n);
            }
            ++n;
        }
    }

    protected Field() {
        int n = this.Length == 0 ? 1 : this.Length;
        this.buffer = new byte[n];
        this.buffer[0] = 32;
    }

    protected void setField(String string, int n, RandomAccessFile randomAccessFile) throws xBaseJException {
        this.Name = string.trim();
        this.validateName(this.Name);
        this.Length = n;
        this.setFile(randomAccessFile);
        this.buffer = new byte[this.Length];
    }

    protected void setFile(RandomAccessFile randomAccessFile) {
        this.file = randomAccessFile;
    }

    public String name() {
        return this.Name;
    }

    public String getName() {
        return this.Name;
    }

    public int length() {
        return this.Length;
    }

    public int getLength() {
        return this.Length;
    }

    public char type() throws xBaseJException {
        throw new xBaseJException("Undefined field");
    }

    public char getType() throws xBaseJException {
        throw new xBaseJException("Undefined field");
    }

    public int decPoint() {
        return 0;
    }

    public int getDecimalPositionCount() {
        return 0;
    }

    protected void read() throws IOException, xBaseJException {
        this.file.readFully(this.buffer, 0, this.Length);
    }

    public String get() {
        String string;
        int n = 0;
        while (n < this.Length && this.buffer[n] != 0) {
            ++n;
        }
        try {
            string = new String(this.buffer, 0, n, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(this.buffer, 0, n);
        }
        return string;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    protected void write() throws IOException, xBaseJException {
        this.file.write(this.buffer, 0, this.Length);
    }

    protected void update() throws IOException, xBaseJException {
        this.file.write(this.buffer, 0, this.Length);
    }

    public void put(String string) throws xBaseJException {
        byte[] byArray;
        if (string.length() > this.Length) {
            throw new xBaseJException("Field length too long");
        }
        int n = Math.min(string.length(), this.Length);
        try {
            byArray = string.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        n = 0;
        while (n < byArray.length) {
            this.buffer[n] = byArray[n];
            ++n;
        }
        n = string.length();
        while (n < this.Length) {
            this.buffer[n] = 32;
            ++n;
        }
    }
}

