/* $Id: ParsedRow.java,v 2.1 1999/07/06 05:51:00 borg Exp $ */
/* Copyright  1999 George Reese, All Rights Reserved */
package com.imaginary.sql.msql;

import java.sql.SQLException;
import java.util.Iterator;

/**
 * Uniform interface for any object representing a row parsed from
 * the database. Other classes in the package concretely define
 * actual rows by implementing this interface.
 * <BR>
 * Last modified $Date: 1999/07/06 05:51:00 $
 * @version $Revision: 2.1 $
 * @author George Reese (borg@imaginary.com)
 */
public interface ParsedRow {
    /**
     * Provides an iterator that lets a class run through each of the
     * column values.
     * @return the iterator of column values
     * @throws java.sql.SQLException the columns could not be properly parsed
     */
    Iterator columns() throws SQLException;

    /**
     * Provides a specific column value.
     * @param col the desired column
     * @return the value for the specified column
     * @throws java.sql.SQLException the columns could not be properly parsed
     */
    String get(int col) throws SQLException;

    /**
     * Lets you know if the specified column exists.
     * @param col the desired column number
     * @return true if the column exists, false otherwise
     * @throws java.sql.SQLException the columns could not be properly parsed
     */     
    boolean hasColumn(int col) throws SQLException;

    /**
     * Assigns a new value to the specified column.
     * @param col the col to be modified
     * @param val the new value for the column
     * @throws java.sql.SQLException the columns could not be properly parsed
     */
    void set(int col, String val) throws SQLException;

    /**
     * @return the number of columns in the row
     * @throws java.sql.SQLException the columns could not be properly parsed
     */
    int size() throws SQLException;
}
