/* $Id: MsqlEmptyResultSet.java,v 2.2 1999/03/03 03:27:08 borg Exp $ */
/* Copyright (c) 1997 George Reese */
package com.imaginary.sql.msql;

import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * The MsqlEmptyResultSet class implements the JDBC ResultSet interface for
 * fake result sets with no data.
 * Last modified $Date: 1999/03/03 03:27:08 $
 * @version $Revision: 2.2 $
 * @author George Reese (borg@imaginary.com)
 */
public class MsqlEmptyResultSet extends MsqlResultSet {
    /**
     * Constructs an empty result set.
     */
    MsqlEmptyResultSet(int ll) throws SQLException {
	super(null, ll);
    }

    public boolean absolute(int row) throws SQLException {
	return false;
    }
    
    /**
     * @param name the name of the desired column
     * @return the column number for the specified column name
     * @exception java.sql.SQLException thrown on a read error
     */
    public int findColumn(String name) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    /**
     * @param column the column number for the desired column
     * @return never
     * @exception java.sql.SQLException thrown when the columb cannot be read
     */
    public InputStream getAsciiStream(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public InputStream getBinaryStream(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }
  
    public boolean getBoolean(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public byte getByte(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public byte[] getBytes(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public ResultSetMetaData getMetaData() throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public int getRow() throws SQLException {
	return 0;
    }
    
    public synchronized String getString(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    /**
     * @deprecated
     */
    public InputStream getUnicodeStream(int column) throws SQLException {
	throw new SQLException("Result set contains no data.");
    }

    public boolean isLast() throws SQLException {
	return false;
    }
    
    /**
     * Moves to the next row of data for processing.  If there are no
     * more rows to be processed, then it will return false.
     * @return true if there are results to be processed, false otherwise
     * @exception java.sql.SQLException thrown if a read error occurs
     */
    public boolean next() throws SQLException {
	return false;
    }

    public boolean previous() throws SQLException {
	return false;
    }

    public boolean relative(int count) throws SQLException {
	throw new MsqlException("No current row.");
    }
    
    /**
     * @return true if the last value read was null
     * @exception java.sql.SQLException never thrown
     */
    public boolean wasNull() throws SQLException {
	return false;
    }
}
