/*
 * Decompiled with CFR 0.152.
 */
package de.dlcc.callnotify;

import de.dlcc.callnotify.CallNotifyMessage;
import de.dlcc.callnotify.MessageSender;
import de.dlcc.callnotify.ObjectListener;
import de.dlcc.callnotify.ObjectReceiver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CallNotifyClient
extends Frame
implements ObjectReceiver {
    String notifyServer;
    static int listenPort = 0;
    static int sendPort = 0;
    InetAddress ownIP;
    InetAddress serverIP;
    JTextArea ta;
    Properties p = new Properties();
    int sizeX;
    int sizeY;
    double posX;
    double posY;
    static String version = "0.1  ";
    CallNotifyMessage msg;
    MessageSender ms;

    public CallNotifyClient() {
        super("DLCC CallNotify");
        CallNotifyClient.printProgramInfo();
        this.getProps();
        try {
            this.ownIP = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("UnknownHostException getting own IP, quitting.");
            System.exit(0);
        }
        ((Component)this).setSize(new Dimension(this.sizeX, this.sizeY));
        ((Component)this).setLocation(new Point((int)this.posX, (int)this.posY));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CallNotifyClient.this.quitApp();
            }
        });
        this.createUI();
    }

    private void register() {
        this.msg = new CallNotifyMessage(1, "", this.ownIP);
        this.ms = new MessageSender(this.serverIP, this.msg, listenPort, sendPort);
        this.ms.start();
    }

    private void deregister() {
        this.msg = new CallNotifyMessage(2, "", this.ownIP);
        this.ms = new MessageSender(this.serverIP, this.msg, listenPort, sendPort);
        this.ms.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        CallNotifyClient callNotifyClient = new CallNotifyClient();
        ObjectListener objectListener = new ObjectListener(listenPort, callNotifyClient);
        objectListener.start();
        callNotifyClient.register();
        ((Component)callNotifyClient).setVisible(true);
    }

    public void newObject(Object object) {
        this.msg = (CallNotifyMessage)object;
        int n = this.msg.getType();
        switch (n) {
            case 7: {
                String string = new String(this.msg.getDetails() + "\n");
                this.ta.insert(string, 0);
                this.toFront();
                Toolkit.getDefaultToolkit().beep();
                break;
            }
            case 4: {
                this.ta.insert("CallNotify ready.\n", 0);
                break;
            }
            case 5: {
                this.ta.insert("Server rejected connection!", 0);
            }
        }
    }

    private void getProps() {
        try {
            FileInputStream fileInputStream = new FileInputStream("config.txt");
            this.p.load(fileInputStream);
            if (this.p.getProperty("serverAddress") != null && this.p.getProperty("listenPort") != null && this.p.getProperty("sendPort") != null) {
                System.out.println("Using server " + this.p.getProperty("serverAddress"));
                this.notifyServer = this.p.getProperty("serverAddress");
                this.serverIP = InetAddress.getByName(this.notifyServer);
                System.out.println("Using listen port " + this.p.getProperty("listenPort"));
                listenPort = Integer.parseInt(this.p.getProperty("listenPort"));
                System.out.println("Using send port " + this.p.getProperty("sendPort"));
                sendPort = Integer.parseInt(this.p.getProperty("sendPort"));
                this.sizeX = this.p.getProperty("sizeX") != null ? Integer.parseInt(this.p.getProperty("sizeX")) : 300;
                this.sizeY = this.p.getProperty("sizeY") != null ? Integer.parseInt(this.p.getProperty("sizeY")) : 105;
                this.posX = this.p.getProperty("posX") != null ? (double)Integer.parseInt(this.p.getProperty("posX")) : 50.0;
                this.posY = this.p.getProperty("posY") != null ? (double)Integer.parseInt(this.p.getProperty("posY")) : 50.0;
            } else {
                System.out.println("Please make sure you have the properties serverAddress and clientListenPort set in your config.txt file, eg.\n\nserverAddress=192.168.1.1\nlistenPort=1888\nsendPort=1887");
                System.exit(0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("No config file found, cannot start.\nCreating a config file template, please edit this file according to your\nenvironment and try again.");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("config.txt");
                String string = new String("serverAddress=192.168.1.1\n\r");
                fileOutputStream.write(string.getBytes());
                string = new String("logFile=caller_id.log\n\r");
                fileOutputStream.write(string.getBytes());
                string = new String("listenPort=1888\n\r");
                fileOutputStream.write(string.getBytes());
                string = new String("sendPort=1887\n\r");
                fileOutputStream.write(string.getBytes());
                fileOutputStream.flush();
                fileOutputStream.close();
                System.exit(0);
            }
            catch (FileNotFoundException fileNotFoundException2) {
                System.out.println("Couldn't create file.");
                System.exit(0);
            }
            catch (IOException iOException) {
                System.out.println("IO Exception!");
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            System.out.println("IO Exception!");
            System.exit(0);
        }
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.ta = new JTextArea();
        this.ta.setEditable(false);
        this.add((Component)new JScrollPane(this.ta), "Center");
    }

    private void quitApp() {
        this.deregister();
        Properties properties = System.getProperties();
        String string = properties.getProperty("java.version");
        if (string.startsWith("1.1")) {
            System.exit(0);
        }
        Dimension dimension = this.getSize();
        this.sizeX = dimension.width;
        this.sizeY = dimension.height;
        this.p.setProperty("sizeX", Integer.toString(this.sizeX));
        this.p.setProperty("sizeY", Integer.toString(this.sizeY));
        Point point = this.getLocationOnScreen();
        this.posX = point.getX();
        this.posY = point.getY();
        this.p.setProperty("posX", Integer.toString((int)this.posX));
        this.p.setProperty("posY", Integer.toString((int)this.posY));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("config.txt");
            this.p.store(fileOutputStream, "DLCC CallNotify Properties");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error saving properties.");
        }
        System.exit(0);
    }

    public static void printProgramInfo() {
        System.out.println("***************************************************");
        System.out.println("* CallNotifyClient                 Version " + version + "  *");
        System.out.println("* (c) 2002 Dennis Luemkemann                      *");
        System.out.println("***************************************************");
    }
}

