/*
 * Decompiled with CFR 0.152.
 */
package de.dlcc.callnotify;

import de.dlcc.callnotify.CallData;
import de.dlcc.callnotify.CallNotifyMessage;
import de.dlcc.callnotify.ListenClient;
import de.dlcc.callnotify.MessageSender;
import de.dlcc.callnotify.ObjectListener;
import de.dlcc.callnotify.ObjectReceiver;
import de.dlcc.callnotify.RegisteredClients;
import java.net.InetAddress;
import java.util.Enumeration;

public class CallNotifyBroker
implements ObjectReceiver {
    RegisteredClients clients;
    int listenPort;
    int sendPort;
    CallNotifyMessage msg;
    MessageSender ms;

    public CallNotifyBroker(int n, int n2) {
        this.listenPort = n;
        this.sendPort = n2;
        this.clients = new RegisteredClients();
        ObjectListener objectListener = new ObjectListener(n, this);
        objectListener.start();
        System.out.println("Broker initialized");
    }

    public void newObject(Object object) {
        this.msg = (CallNotifyMessage)object;
        if (this.msg.getType() == 1) {
            this.registerClient(this.msg.getInetAddress());
        }
        if (this.msg.getType() == 2) {
            this.deregisterClient(this.msg.getInetAddress());
        }
    }

    public boolean incomingCall(CallData callData) {
        Enumeration enumeration = this.clients.elements();
        while (enumeration.hasMoreElements()) {
            CallNotifyMessage callNotifyMessage = new CallNotifyMessage(7, callData.getAll(), null);
            MessageSender messageSender = new MessageSender(((ListenClient)enumeration.nextElement()).getAddress(), callNotifyMessage, this.listenPort, this.sendPort);
            messageSender.start();
        }
        return true;
    }

    public void registerClient(InetAddress inetAddress) {
        ListenClient listenClient = new ListenClient(inetAddress);
        if (this.clients.addClient(listenClient)) {
            System.out.println("Registered client " + inetAddress.getHostAddress());
            this.msg = new CallNotifyMessage(4, "", null);
            this.ms = new MessageSender(inetAddress, this.msg, this.listenPort, this.sendPort);
            this.ms.start();
        } else {
            System.out.println("Rejected client " + inetAddress.getHostAddress());
            this.msg = new CallNotifyMessage(5, "", null);
            this.ms = new MessageSender(inetAddress, this.msg, this.listenPort, this.sendPort);
            this.ms.start();
        }
    }

    public void deregisterClient(InetAddress inetAddress) {
        ListenClient listenClient = new ListenClient(inetAddress);
        if (this.clients.removeClient(listenClient)) {
            System.out.println("Deregistered client " + inetAddress.getHostAddress());
        } else {
            System.out.println("Couldn't deregister client " + inetAddress.getHostAddress());
        }
    }
}

