/*
 * Decompiled with CFR 0.152.
 */
package de.dlcc.callnotify;

import de.dlcc.callnotify.CallNotifyBroker;
import de.dlcc.callnotify.LogWatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class CallNotifyServer {
    File callerLog;
    long logLastModified;
    CallNotifyBroker broker;
    int listenPort = 0;
    int sendPort = 0;
    static String version = "0.1  ";

    public CallNotifyServer() {
        this.getProps();
        this.logLastModified = this.callerLog.lastModified();
        this.broker = new CallNotifyBroker(this.listenPort, this.sendPort);
        LogWatcher logWatcher = new LogWatcher(this.callerLog, this.broker);
        logWatcher.start();
    }

    public static void main(String[] stringArray) {
        CallNotifyServer.printProgramInfo();
        CallNotifyServer callNotifyServer = new CallNotifyServer();
    }

    private void getProps() {
        try {
            FileInputStream fileInputStream = new FileInputStream("config.txt");
            Properties properties = new Properties();
            properties.load(fileInputStream);
            if (properties.getProperty("logFile") != null & properties.getProperty("listenPort") != null & properties.getProperty("sendPort") != null) {
                System.out.println("Using caller log " + properties.getProperty("logFile"));
                this.callerLog = new File(properties.getProperty("logFile"));
                System.out.println("Using listen port " + properties.getProperty("listenPort"));
                this.listenPort = Integer.parseInt(properties.getProperty("listenPort"));
                System.out.println("Using send port " + properties.getProperty("sendPort"));
                this.sendPort = Integer.parseInt(properties.getProperty("sendPort"));
            } else {
                System.out.println("Config file is incomplete or corrupted, please review config.txt.");
                System.exit(0);
            }
            if (!this.callerLog.exists()) {
                System.out.println("Sorry, couldn't find the specified caller log.");
                System.exit(0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("No config file found, cannot start.\nCreating a config file template, please edit this file (config.txt)\naccording to your environment and try again.");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("config.txt");
                String string = new String("logFile=caller_id.log\n\r");
                fileOutputStream.write(string.getBytes());
                string = new String("listenPort=1888\n\r");
                fileOutputStream.write(string.getBytes());
                string = new String("sendPort=1887\n\r");
                fileOutputStream.write(string.getBytes());
                string = new String("serverAddress=192.168.1.1\n\r");
                fileOutputStream.write(string.getBytes());
                fileOutputStream.flush();
                fileOutputStream.close();
                System.exit(0);
            }
            catch (FileNotFoundException fileNotFoundException2) {
                System.out.println("Couldn't create file.");
                System.exit(0);
            }
            catch (IOException iOException) {
                System.out.println("IO Exception!");
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            System.out.println("Server: IOException while getting properties.");
            System.exit(0);
        }
    }

    public static void printProgramInfo() {
        System.out.println("***************************************************");
        System.out.println("* CallNotifyServer                 Version " + version + "  *");
        System.out.println("* (c) 2002 Dennis Luemkemann                      *");
        System.out.println("***************************************************");
    }
}

