/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jscicalc.graph.Graph;
import jscicalc.graph.Model;
import jscicalc.graph.Transformation;

public class View
extends JPanel {
    protected Graph graph;
    protected Model model;
    protected Transformation transformation;
    protected double distanceValue;
    public static final double delta = 0.001;
    private int lastWidth;
    private int lastHeight;
    AtomicBoolean forceUpdateBool;
    private static final long serialVersionUID = 1L;

    public View(Model model, Graph graph) {
        this.model = model;
        this.graph = graph;
        this.forceUpdateBool = new AtomicBoolean(false);
        this.transformation = new Transformation(this);
        Font font = UIManager.getFont("Label.font");
        this.setFont(font.deriveFont(10.0f));
        this.distanceValue = 1.0;
        this.lastHeight = 0;
        this.lastWidth = 0;
    }

    public void forceUpdate() {
        this.forceUpdateBool.set(true);
    }

    public void paintComponent(Graphics graphics) {
        if (this.lastWidth != this.getWidth() || this.lastHeight != this.getHeight() || this.forceUpdateBool.compareAndSet(true, false)) {
            System.out.println("*** changed size  or forced update *** ");
            this.graph.updateMenu();
            this.setCursor(new Cursor(3));
            this.model.updatePaths();
            this.lastWidth = this.getWidth();
            this.lastHeight = this.getHeight();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.lastWidth, this.lastHeight);
        graphics2D.setColor(Color.BLACK);
        this.model.draw(this, graphics2D);
        System.out.println("finished updating view");
    }

    public final Transformation getTransformation() {
        return this.transformation;
    }

    public Model getModel() {
        return this.model;
    }

    double distance() {
        return this.distanceValue;
    }
}

