/*
 * Decompiled with CFR 0.152.
 */
package jscicalc.expression;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import jscicalc.Base;
import jscicalc.Error;
import jscicalc.Notation;
import jscicalc.OObject;
import jscicalc.StringArray;
import jscicalc.Substitution;
import jscicalc.complex.Complex;
import jscicalc.expression.Expression;
import jscicalc.expression.Product;
import jscicalc.expression.SumOrProduct;
import jscicalc.expression.Variable;

public class Sum
extends SumOrProduct
implements Cloneable {
    public Sum(Expression expression) {
        if (expression instanceof Sum) {
            Sum sum = (Sum)expression;
            this.complex = sum.complex;
            this.expressionList = sum.expressionList;
        }
        this.complex = new Complex();
        this.expressionList = new LinkedList();
        this.expressionList.add(expression);
    }

    public Sum() {
        this.complex = new Complex();
        this.expressionList = new LinkedList();
    }

    public Sum add(Complex complex) {
        Sum sum = this.clone();
        sum.complex = this.complex.add(complex);
        return sum;
    }

    public Sum clone() {
        Sum sum = new Sum();
        sum.complex = new Complex(this.complex.real(), this.complex.imaginary());
        sum.expressionList = new LinkedList();
        ListIterator listIterator = this.getExpressionList().listIterator();
        while (listIterator.hasNext()) {
            sum.expressionList.add(listIterator.next());
        }
        return sum;
    }

    public boolean isNegative() {
        if (this.complex.isZero()) {
            if (this.expressionList.isEmpty()) {
                return false;
            }
            return ((Expression)this.expressionList.getFirst()).isNegative();
        }
        return this.complex.isNegative();
    }

    public StringArray toHTMLSubString(int n, int n2, Base base, Notation notation, double d) {
        StringArray stringArray = new StringArray();
        boolean bl = false;
        Object object = this.expressionList.listIterator();
        while (object.hasNext()) {
            Expression expression = (Expression)object.next();
            StringArray stringArray2 = expression.toHTMLSubString(n, n2, base, notation, d);
            if (bl && (!expression.isNegative() || stringArray2.size() > 0 && ((String)((Vector)stringArray2.firstElement()).firstElement()).equals("("))) {
                stringArray.add("+");
            }
            stringArray.addAll(stringArray2);
            bl = true;
        }
        object = this.complex.toHTMLSubString(n, n2, base, notation, d);
        if (!((StringArray)object).isZero()) {
            if (bl && !this.complex.isNegative()) {
                stringArray.add("+");
            }
            stringArray.addAll(object);
        }
        return stringArray;
    }

    public StringArray toHTMLParenString(int n, int n2, Base base, Notation notation, double d) {
        if (this.getExpressionList().isEmpty()) {
            return this.complex.toHTMLParenString(n, n2, base, notation, d);
        }
        if (this.complex.isZero() && this.getExpressionList().size() == 1) {
            return this.getExpressionList().getFirst().toHTMLParenString(n, n2, base, notation, d);
        }
        StringArray stringArray = new StringArray();
        stringArray.add("(");
        stringArray.addAll(this.toHTMLSubString(n, n2, base, notation, d));
        stringArray.add(")");
        return stringArray;
    }

    public OObject add(Product product) {
        System.out.println("Adding product to sum: FIXME");
        Sum sum = this.clone();
        System.out.println("Clone complete: FIXME");
        OObject oObject = product.unBox();
        if (oObject instanceof Complex) {
            sum.complex = sum.complex.add((Complex)oObject);
        } else if (oObject instanceof Expression) {
            sum.expressionList.add((Expression)oObject);
        } else {
            return new Error("Sum.add() error");
        }
        return sum;
    }

    public OObject add(Sum sum) {
        Sum sum2 = this.clone();
        sum2.complex = sum2.complex.add(sum.complex);
        OObject oObject = sum2;
        ListIterator listIterator = sum.expressionList.listIterator();
        while (listIterator.hasNext()) {
            oObject = oObject.add((OObject)listIterator.next());
        }
        return oObject;
    }

    public Sum negate() {
        Sum sum = new Sum();
        sum.complex = this.complex.negate();
        ListIterator listIterator = this.expressionList.listIterator();
        while (listIterator.hasNext()) {
            sum.expressionList.add(((Expression)listIterator.next()).negate());
        }
        return sum;
    }

    private OObject rMultiply(OObject oObject) {
        if (!(oObject instanceof Complex) && !(oObject instanceof Expression)) {
            return new Error("Error in Sum.rMultiply");
        }
        Sum sum = new Sum();
        OObject oObject2 = oObject.multiply(this.complex);
        if (oObject2 instanceof Complex) {
            sum.complex = sum.complex.add((Complex)oObject2);
        } else if (oObject2 instanceof Expression) {
            sum.expressionList.add((Expression)oObject2);
        } else {
            return new Error("Error in Sum.lMultiply");
        }
        ListIterator listIterator = this.getExpressionList().listIterator();
        while (listIterator.hasNext()) {
            oObject2 = ((Expression)listIterator.next()).multiply(oObject);
            if (oObject2 instanceof Complex) {
                sum.complex = sum.complex.add((Complex)oObject2);
                continue;
            }
            if (oObject2 instanceof Expression) {
                sum.expressionList.add((Expression)oObject2);
                continue;
            }
            return new Error("Error in Sum.rMultiply");
        }
        return sum;
    }

    OObject multiply(Sum sum) {
        Sum sum2 = new Sum();
        OObject oObject = this.rMultiply(sum.complex);
        if (oObject instanceof Complex) {
            sum2.complex = sum2.complex.add((Complex)oObject);
        } else if (oObject instanceof Expression) {
            sum2.expressionList.add((Expression)oObject);
        } else {
            return new Error("Error in Sum.multiply");
        }
        ListIterator listIterator = sum.getExpressionList().listIterator();
        while (listIterator.hasNext()) {
            Expression expression = (Expression)listIterator.next();
            oObject = this.rMultiply(expression);
            if (oObject instanceof Complex) {
                sum2.complex = sum2.complex.add((Complex)oObject);
                continue;
            }
            if (oObject instanceof Expression) {
                sum2.expressionList.add((Expression)oObject);
                continue;
            }
            return new Error("Error in Sum.multiply");
        }
        return sum2;
    }

    public OObject unBox() {
        if (this.expressionList.size() == 1 && this.complex.isZero()) {
            return (OObject)this.expressionList.getFirst();
        }
        if (this.expressionList.isEmpty()) {
            return this.complex;
        }
        return this;
    }

    public int compareTo(Sum sum) {
        this.sort();
        int n = Sum.compare(this.expressionList, sum.expressionList);
        if (n != 0) {
            return n;
        }
        return this.complex.compareTo(sum.complex);
    }

    public OObject auto_simplify() {
        OObject oObject;
        ListIterator<Expression> listIterator = this.expressionList.listIterator();
        while (listIterator.hasNext()) {
            oObject = ((Expression)listIterator.next()).auto_simplify();
            if (oObject instanceof Complex) {
                this.complex = this.complex.multiply((Complex)oObject);
                listIterator.remove();
                continue;
            }
            if (oObject instanceof Expression) {
                listIterator.set((Expression)oObject);
                continue;
            }
            return new Error("Product.auto_simplify() error");
        }
        this.sort();
        if (this.expressionList.isEmpty()) {
            return this.unBox();
        }
        listIterator = this.expressionList.listIterator();
        oObject = null;
        OObject oObject2 = (Expression)listIterator.next();
        while (listIterator.hasNext()) {
            Product product = null;
            product = oObject2 instanceof Product ? (Product)oObject2 : new Product((Expression)oObject2, false);
            oObject = (Expression)listIterator.next();
            Product product2 = null;
            product2 = oObject instanceof Product ? (Product)oObject : new Product((Expression)oObject, false);
            if (product.compareTo(product2) == 0) {
                System.out.println("Adding comparable expressions");
                Product product3 = new Product(product, false);
                product3.setComplex(product.getComplex().add(product2.getComplex()));
                OObject oObject3 = product3.unBox();
                if (oObject3 instanceof Complex) {
                    this.complex = this.complex.add((Complex)oObject3);
                    listIterator.remove();
                    listIterator.previous();
                    listIterator.remove();
                    if (listIterator.hasNext()) {
                        oObject2 = (Expression)listIterator.next();
                    }
                } else if (oObject3 instanceof Expression) {
                    listIterator.remove();
                    listIterator.previous();
                    listIterator.set((Expression)oObject3);
                    oObject = (Expression)listIterator.next();
                } else {
                    return new Error("Sum.auto_simplify() error");
                }
            }
            oObject2 = oObject;
        }
        return this.unBox();
    }

    public OObject substitute(Substitution substitution) {
        Sum sum = this.clone();
        ListIterator<Expression> listIterator = sum.expressionList.listIterator();
        while (listIterator.hasNext()) {
            Expression expression = (Expression)listIterator.next();
            OObject oObject = expression.substitute(substitution);
            if (oObject instanceof Complex) {
                listIterator.remove();
                sum.complex = sum.complex.add((Complex)oObject);
                continue;
            }
            if (oObject instanceof Expression) {
                listIterator.set((Expression)oObject);
                continue;
            }
            return new Error("Product.substitution() Error");
        }
        return sum.auto_simplify();
    }

    public static void main(String[] stringArray) {
        Variable variable = new Variable(new jscicalc.pobject.Variable('x'));
        Sum sum = new Sum(variable);
    }
}

