/*
 * Decompiled with CFR 0.152.
 */
package jscicalc;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jscicalc.Base;
import jscicalc.complex.Complex;

class ParseBase {
    public static final long BIAS = 1023L;
    public static final long E_MAX = 1023L;
    public static final long E_MIN = -1022L;

    ParseBase() {
    }

    private static long getDigit(char c) {
        switch (c) {
            case '0': {
                return 0L;
            }
            case '1': {
                return 1L;
            }
            case '2': {
                return 2L;
            }
            case '3': {
                return 3L;
            }
            case '4': {
                return 4L;
            }
            case '5': {
                return 5L;
            }
            case '6': {
                return 6L;
            }
            case '7': {
                return 7L;
            }
            case '8': {
                return 8L;
            }
            case '9': {
                return 9L;
            }
            case 'A': {
                return 10L;
            }
            case 'B': {
                return 11L;
            }
            case 'C': {
                return 12L;
            }
            case 'D': {
                return 13L;
            }
            case 'E': {
                return 14L;
            }
            case 'F': {
                return 15L;
            }
        }
        return -1L;
    }

    public static Complex parseString(String string, Base base) {
        return new Complex(ParseBase.dparseString(string, base));
    }

    public static double dparseString(String string, Base base) {
        if (base == Base.DECIMAL) {
            Matcher matcher = Number.pattern.matcher(string);
            matcher.matches();
            return new BigDecimal(string).doubleValue();
        }
        Number number = Number.parseString(string, base);
        if (number.significand == 0L) {
            return 0.0;
        }
        switch (base) {
            case HEXADECIMAL: {
                number.significand >>>= 4;
                break;
            }
            case OCTAL: {
                number.significand >>>= 5;
                break;
            }
            default: {
                number.significand >>>= 7;
            }
        }
        while ((number.significand & 0xFFE0000000000000L) != 0L) {
            number.significand >>>= 1;
            ++number.exponent;
        }
        if (number.exponent > 1023L) {
            if (number.negative) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (number.exponent < -1022L) {
            if (number.exponent < -1074L) {
                return 0.0;
            }
            while (number.exponent < -1022L) {
                number.significand >>>= 1;
                ++number.exponent;
            }
            number.exponent = -1023L;
        }
        long l = number.exponent + 1023L;
        l <<= 52;
        l = number.negative ? (l |= Long.MIN_VALUE) : (l &= Long.MAX_VALUE);
        return Double.longBitsToDouble(l |= number.significand & 0xFFFFFFFFFFFFFL);
    }

    public static void main(String[] stringArray) {
        System.out.println(ParseBase.parseString("777", Base.OCTAL).real());
        System.out.println(ParseBase.parseString("77.7", Base.OCTAL).real());
        System.out.println(ParseBase.parseString("177", Base.OCTAL).real());
        System.out.println(ParseBase.parseString("077", Base.OCTAL).real());
        System.out.println(ParseBase.parseString("0.01", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("0.01", Base.OCTAL).real());
        System.out.println(ParseBase.parseString("0.01", Base.BINARY).real());
        System.out.println(ParseBase.parseString("-0.01", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("-0.01", Base.OCTAL).real());
        System.out.println(ParseBase.parseString("-0.01", Base.BINARY).real());
        System.out.println(ParseBase.parseString("1e3", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("1e3", Base.OCTAL).real());
        System.out.println(ParseBase.parseString("1e11", Base.BINARY).real());
        System.out.println(ParseBase.parseString("1e-3", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("1e-3", Base.OCTAL).real());
        System.out.println(ParseBase.parseString("-1e-11", Base.BINARY).real());
        System.out.println(ParseBase.parseString("1e-13", Base.OCTAL).real());
        System.out.println(ParseBase.parseString("1e+1111111111", Base.BINARY).real());
        System.out.println(ParseBase.parseString("1e+10000000000", Base.BINARY).real());
        System.out.println(ParseBase.parseString("1e-10000000000", Base.BINARY).real());
        System.out.println(ParseBase.parseString("1e-10000000000", Base.BINARY).real());
        System.out.println(ParseBase.parseString("1e-100000000000", Base.BINARY).real());
        System.out.println(ParseBase.parseString("1e-1000000000000", Base.BINARY).real());
        System.out.println(ParseBase.parseString("8e+FF", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("1e+100", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("8e2", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("8e-FF", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("1e-108", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("1e-109", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("1e-109", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("1e-10A", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("1e-10C", Base.HEXADECIMAL).real());
        System.out.println(ParseBase.parseString("1e+8", Base.HEXADECIMAL).real());
    }

    private static class Number {
        public long significand;
        public long exponent;
        public boolean negative;
        public boolean exponentNegative;
        public Base base;
        private static Pattern pattern = Pattern.compile("([-|+]?[0-9A-F]+|[-|+]?[0-9A-F]+[.][0-9A-F]*|[-|+]?[0-9A-F]*[.][0-9A-F]+)(e[-|+]?[0-9A-F]+|)");

        public Number(Base base) {
            this.base = base;
            this.exponent = 0L;
            this.significand = 0L;
        }

        public static Number parseSignificand(String string, Base base) {
            Number number = new Number(base);
            int n = 15;
            int n2 = 4;
            if (base == Base.BINARY) {
                n = 60;
                n2 = 1;
            } else if (base == Base.OCTAL) {
                n = 20;
                n2 = 3;
            }
            number.negative = string.charAt(0) == '-';
            int n3 = number.negative ? 1 : 0;
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                long l = 0L;
                if (i + n3 < string.length()) {
                    l = ParseBase.getDigit(string.charAt(i + n3));
                }
                if (l < 0L) {
                    ++n3;
                    --i;
                    continue;
                }
                if (bl) {
                    if (l == 0L && n3 < n) {
                        ++n3;
                        --i;
                        continue;
                    }
                    bl = false;
                }
                number.significand <<= n2;
                number.significand |= l;
            }
            return number;
        }

        private void parseExponent(String string) {
            int n = 0;
            switch (this.base) {
                case BINARY: {
                    n = 1;
                    break;
                }
                case OCTAL: {
                    n = 3;
                    break;
                }
                default: {
                    n = 4;
                }
            }
            this.exponentNegative = false;
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                long l;
                Character c = Character.valueOf(cArray[i]);
                if (c.charValue() == '-') {
                    boolean bl = this.exponentNegative = !this.exponentNegative;
                }
                if ((l = ParseBase.getDigit(c.charValue())) < 0L) continue;
                this.exponent <<= n;
                if ((this.exponent & 0x1000L) != 0L) break;
                this.exponent += l * (long)n;
            }
            if (this.exponentNegative) {
                this.exponent = -this.exponent;
            }
        }

        private void parsePoint(String string) {
            Character c;
            int n;
            boolean bl = false;
            int n2 = 0;
            int n3 = 0;
            char[] cArray = string.toCharArray();
            int n4 = cArray.length;
            for (n = 0; n < n4; ++n) {
                Character c2 = Character.valueOf(cArray[n]);
                if (c2.charValue() == '.') {
                    bl = true;
                    continue;
                }
                if (c2.charValue() != '0') break;
                if (bl) {
                    ++n3;
                    continue;
                }
                ++n2;
            }
            int n5 = 0;
            char[] cArray2 = string.toCharArray();
            n = cArray2.length;
            for (int i = 0; i < n && (c = Character.valueOf(cArray2[i])).charValue() != '.'; ++i) {
                ++n5;
            }
            int n6 = n5 - n2 - n3 - 1;
            if (this.base == Base.HEXADECIMAL) {
                n6 *= 4;
            } else if (this.base == Base.OCTAL) {
                n6 *= 3;
            }
            this.exponent += (long)n6;
        }

        private static Number parseStrings(String string, String string2, Base base) {
            Number number = Number.parseSignificand(string, base);
            if (string2.length() > 0) {
                number.parseExponent(string2);
            }
            number.parsePoint(string);
            return number;
        }

        public static Number parseString(String string, Base base) {
            Matcher matcher = pattern.matcher(string);
            matcher.matches();
            return Number.parseStrings(matcher.group(1), matcher.group(2), base);
        }
    }
}

