#!/bin/bash

# fi/joensuu/joyds1/calendar//test/make-tester.sh
#   Copyright (C) 2003, 2009 Hannu Väisänen
#
# This library is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This library is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this library; see the file COPYING.  If not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# 02111-1307 USA.
#
# Linking this library statically or dynamically with other modules is
# making a combined work based on this library.  Thus, the terms and
# conditions of the GNU General Public License cover the whole
# combination.


# Make a class 'Tester.java' that tests calendars.
#
# Command './make-tester.sh' creates tests for all calendars
#
# Running the resulting program takes a very, very long time!
#
# You can give a file name as a parameter. For example, command
#
# ./make-tester.sh ../GregorianCalendar.java
#
# creates a test for only for GregorianCalendar.
#
# Running the resulting program is not fast, either. (-:
#
# This scripts compiles and runs the file Tester.java like this:
#
# javac Tester.java
# java fi.joensuu.joyds1.calendar.test.Tester


function f()
{
  echo '    {'
  echo '      System.out.println ("'$1'");'
  echo '      final int J0 = '$1'.FIRST_JULIAN_DAY;'
  echo '      Calendar c1 = new '$1 '(J0);'
  echo '      Calendar c2 = new '$1 '(J0);'
  echo '      final int FIRST_YEAR = c1.getYear();'
  echo '      System.out.println ("test1");'
  echo '      TestCalendar.test1 (c1, c2, (int)('$2'*365.25));'
  echo '      System.out.println ("test2");'
  echo '      TestCalendar.test2 (c1, c2, '$2', FIRST_YEAR);'
  echo '      System.out.println ("test3");'
  echo '      final int L0 = J0 + (int)('$2'*365.25);'
  echo '      for (int i = J0; i < L0; i++) {'
  echo '        c1 = new '$1 '(i);'
  echo '        c2 = new '$1 '(i);'
  echo '        TestCalendar.test3 (c1, c2);'
  echo '      }'
  echo '    }'
}


function g()
{
  echo 'package fi.joensuu.joyds1.calendar.test;'
  echo 'import fi.joensuu.joyds1.calendar.*;'
  echo 'import fi.joensuu.joyds1.calendar.format.*;'

  echo 'class Tester {'
  echo '  public static void main (String[] args)'
  echo '  {'

  for i in $1
  do
     f `basename $i .java` 10000
  done

  echo '  }'
  echo '}'
}


if [[ $* == "" ]]
then
  F=`ls ../*Calendar.java | grep -vE '(/Calendar|CopticE|JulianG|Generator|Mayan|Old|Test)'`
else
  F=`ls $*`
fi

echo 'F ' $F

g $F >Tester.java

echo Compiling Tester.java...
javac Tester.java

echo Running Tester... this can take a long time.
java fi.joensuu.joyds1.calendar.test.Tester
