/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokentime;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Time {
    private int hours;
    private int minutes;
    public static final int FORMAT24H = 24;
    public static final int FORMATDEC = 10;
    public static final int FORMAT12H = 12;

    public Time() {
        this.hours = 0;
        this.minutes = 0;
    }

    public Time(int minutes) {
        this.hours = minutes / 60;
        this.hours %= 24;
        this.minutes = minutes % 60;
    }

    public Time(int hours, int minutes) {
        this.hours = hours;
        this.minutes = minutes;
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void addMinutes(int m) {
        while (m > 0) {
            ++this.minutes;
            if (this.minutes > 59) {
                this.minutes = 0;
                ++this.hours;
            }
            if (this.hours > 23) {
                this.hours = 0;
            }
            --m;
        }
        while (m < 0) {
            --this.minutes;
            if (this.minutes < 0) {
                --this.hours;
                this.minutes = 59;
            }
            if (this.hours < 0) {
                this.hours = 23;
            }
            ++m;
        }
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public String toString() {
        return String.format("%02d:%02d", this.hours, this.minutes);
    }

    public static String format(Time time, int format) {
        switch (format) {
            case 24: {
                return String.format("%02d:%02d", time.getHours(), time.getMinutes());
            }
            case 12: {
                int hour = time.getHours();
                boolean am = true;
                if (hour >= 12) {
                    hour -= 12;
                    am = false;
                }
                if (hour == 0) {
                    hour = 12;
                }
                String ampm = am ? "am" : "pm";
                return String.format("%02d:%02d %s", hour, time.getMinutes(), ampm);
            }
            case 10: {
                return Integer.toString(time.getHours() * 100 + time.getMinutes());
            }
        }
        throw new IllegalArgumentException("inernal error");
    }

    public static Time parse(String input, int format) throws IllegalArgumentException {
        Time time = new Time();
        int minutes = 0;
        int hours = 0;
        switch (format) {
            case 24: {
                String REGEX24H = "(\\d{2})[ \\.:](\\d{2})";
                Pattern pattern24h = Pattern.compile("(\\d{2})[ \\.:](\\d{2})", 2);
                Matcher matcher24h = pattern24h.matcher(input);
                if (matcher24h.find()) {
                    hours = Integer.parseInt(matcher24h.group(1));
                    minutes = Integer.parseInt(matcher24h.group(2));
                    if (hours > 23 || minutes > 59) {
                        throw new IllegalArgumentException("invalid");
                    }
                } else {
                    throw new IllegalArgumentException("invalid");
                }
                time.setHours(hours);
                time.setMinutes(minutes);
                break;
            }
            case 12: {
                String REGEX12H = "(\\d{2})[ \\.:](\\d{2})\\s+([ap]m)";
                Pattern pattern12h = Pattern.compile("(\\d{2})[ \\.:](\\d{2})\\s+([ap]m)", 2);
                Matcher matcher12h = pattern12h.matcher(input);
                if (matcher12h.find()) {
                    hours = Integer.parseInt(matcher12h.group(1));
                    minutes = Integer.parseInt(matcher12h.group(2));
                    if (hours == 12) {
                        hours = 0;
                    }
                    if (matcher12h.group(3).equalsIgnoreCase("pm")) {
                        hours += 12;
                    }
                    if (hours > 23 || minutes > 59) {
                        throw new IllegalArgumentException("invalid");
                    }
                } else {
                    throw new IllegalArgumentException("invalid");
                }
                time.setHours(hours);
                time.setMinutes(minutes);
                break;
            }
            case 10: {
                try {
                    int value = Integer.parseInt(input);
                    int hour = value / 100;
                    int minute = value % 100;
                    time.setHours(hour);
                    time.setMinutes(minute);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
        }
        return time;
    }
}

