/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import java.math.BigInteger;
import java.util.ArrayList;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.util.spokennumbers.AudioThread;

public abstract class SpokenNumber {
    public static final int NUMBER = 0;
    public static final int DIGITS = 1;
    public static final int YEAR = 2;
    protected int MAX_DIGITS = 0;
    protected BigInteger MAX_VALUE = BigInteger.ZERO;
    protected BigInteger MIN_VALUE = BigInteger.ZERO;
    protected String SOUND_DIR = null;
    public static String ERROR_TOOBIG = "Number is too big [maximum is (10^{0})-1]";
    public static String ERROR_TOOSMALL = "Number is too small [minimum is -(10^{0})-1]";
    protected String number;
    protected ArrayList<String> syllables = new ArrayList();
    protected int[] digits;
    protected AudioThread audioThread = null;
    protected int waitAfterASyllable = 0;
    protected int numberType = 0;
    protected boolean appendBlank = true;

    public SpokenNumber() {
        this.init();
        try {
            this.setNumber(0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SpokenNumber(long number) throws Exception {
        this.init();
        this.setNumber(number);
    }

    public SpokenNumber(String number) throws Exception {
        this.init();
        this.setNumber(number);
    }

    public void setNumber(long number) throws Exception {
        this.syllables.clear();
        this.checkNumber(Long.toString(number));
        this.number = Long.toString(number);
        this.convert2Syllables();
    }

    public ArrayList<String> getSyllables() {
        return this.syllables;
    }

    public void setNumber(String number) throws Exception {
        this.syllables.clear();
        this.checkNumber(number);
        this.number = number;
        this.convert2Syllables();
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumberType(int numberType) {
        this.numberType = numberType;
    }

    public int getNumberType() {
        return this.numberType;
    }

    protected void checkNumber(String number) throws Exception {
        BigInteger big = new BigInteger(number);
        if (this.numberType != 0) {
            return;
        }
        if (big.compareTo(this.MAX_VALUE) > 0) {
            throw new Exception(GeneralString.message(ERROR_TOOBIG, this.MAX_DIGITS));
        }
        if (big.compareTo(this.MIN_VALUE) < 0) {
            throw new Exception(GeneralString.message(ERROR_TOOSMALL, this.MAX_DIGITS));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.syllables.size(); ++i) {
            sb.append(this.syllables.get(i).toString());
            if (this.numberType != 1 || !this.appendBlank) continue;
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    protected abstract void convert2Syllables() throws Exception;

    protected void init() {
        this.MAX_DIGITS = this.getSupportedDigits();
        this.digits = new int[this.MAX_DIGITS];
        this.MAX_VALUE = new BigInteger(SpokenNumber.getMaximum(this.MAX_DIGITS));
        this.MIN_VALUE = new BigInteger("-" + this.MAX_VALUE);
    }

    protected abstract int getSupportedDigits();

    public abstract String getSoundDir();

    public void play() {
        String dir = this.getSoundDir();
        if (dir != null) {
            if (this.audioThread != null) {
                this.audioThread.interrupt();
                while (this.audioThread.isAlive()) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.audioThread = new AudioThread(this.syllables, dir);
            this.audioThread.setWaitAfterASyllable(this.waitAfterASyllable);
            this.audioThread.start();
        }
    }

    public void stopPlaying() {
        if (this.audioThread != null) {
            this.audioThread.interrupt();
        }
    }

    public void fillSyllables(String Null, String[] _1to9) {
        for (int i = 0; i < this.number.length(); ++i) {
            int digit = 0;
            try {
                digit = Integer.parseInt(this.number.substring(i, i + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (digit == 0) {
                this.syllables.add(Null);
                continue;
            }
            this.syllables.add(_1to9[digit - 1]);
        }
    }

    public void fillSyllables(String[] _0to9) {
        for (int i = 0; i < this.number.length(); ++i) {
            int digit = 0;
            try {
                digit = Integer.parseInt(this.number.substring(i, i + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.syllables.add(_0to9[digit]);
        }
    }

    protected void number2digits() {
        int i;
        int offset = this.number.charAt(0) == '-' ? 1 : 0;
        for (i = offset; i < this.number.length(); ++i) {
            int digit = 0;
            try {
                int start = this.number.length() - i - 1;
                digit = Integer.parseInt(this.number.substring(start += offset, start + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.digits[i - offset] = digit;
        }
        for (i = this.number.length(); i < this.MAX_DIGITS; ++i) {
            this.digits[i - offset] = 0;
        }
    }

    public static String getMaximum(int digits) {
        StringBuilder sb = new StringBuilder(digits);
        sb.setLength(digits);
        for (int i = 0; i < digits; ++i) {
            sb.setCharAt(i, '9');
        }
        return sb.toString();
    }
}

