/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class PolishNumber
extends SpokenNumber {
    private static final String[] field = new String[]{"jeden", "dwa", "trzy", "cztery", "pi\u0119\u0107", "sze\u015b\u0107", "siedem", "osiem", "dziewi\u0119\u0107"};
    private static final String NULL = "zero";
    private static final String MINUS = "minus";

    public PolishNumber() {
    }

    public PolishNumber(long number) throws Exception {
        super(number);
    }

    public PolishNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 1;
    }

    @Override
    public String getSoundDir() {
        return "polish";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("minus ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, field);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(NULL);
        } else {
            this.syllables.add(field[this.digits[0] - 1]);
        }
    }

    public static String toString(long number) throws Exception {
        return new PolishNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new PolishNumber(number).toString();
    }
}

