/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class KlingonNumber
extends SpokenNumber {
    protected static final String[] field = new String[]{"wa'", "cha'", "wej", "loS", "vagh", "jav", "Soch", "chorgh", "Hut"};
    protected static final String[] amount = new String[]{"maH ", "vatlh ", "SaD ", "netlh ", "bIp ", "'uy' "};
    protected static final String NULL = "pagh";
    protected static final String MINUS = "-";
    protected static final String BLANK = " ";
    protected static final String DASH = "-";

    public KlingonNumber() {
    }

    public KlingonNumber(long number) throws Exception {
        super(number);
    }

    public KlingonNumber(String number) throws Exception {
        super(number);
    }

    @Override
    public String getSoundDir() {
        return "klingon";
    }

    public static String toString(long number) throws Exception {
        return new KlingonNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new KlingonNumber(number).toString();
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("-");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, field);
            return;
        }
        this.number2digits();
        if (this.number.equals("0")) {
            this.syllables.add(NULL);
        } else {
            for (int i = this.getSupportedDigits() - 1; i > 0; --i) {
                if (this.digits[i] <= 0) continue;
                this.syllables.add(field[this.digits[i] - 1]);
                this.syllables.add(amount[i - 1]);
            }
            if (this.digits[0] > 0) {
                this.syllables.add(field[this.digits[0] - 1]);
            }
        }
    }

    @Override
    protected int getSupportedDigits() {
        return 7;
    }
}

