/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class GermanNumber
extends SpokenNumber {
    protected static final String[] line1 = new String[]{"ein", "zwei", "drei", "vier", "f\u00fcnf", "sechs", "sieben", "acht", "neun"};
    protected static final String[] line2 = new String[]{"elf", "zw\u00f6lf", "dreizehn", "vierzehn", "f\u00fcnfzehn", "sechzehn", "siebzehn", "achtzehn", "neunzehn"};
    protected static final String[] line3 = new String[]{"zehn", "zwanzig", "drei\u00dfig", "vierzig", "f\u00fcnfzig", "sechzig", "siebzig", "achtzig", "neunzig"};
    private static final String[][] FIELD = new String[][]{line1, line2, line3};
    private static final String[][] amount = new String[][]{{"tausend", "tausend"}, {" Million ", " Millionen "}, {" Milliarde ", " Milliarden "}, {" Billion ", " Billionen "}, {" Billiarde ", " Billiarden "}, {" Trillion ", " Trillionen "}, {" Trilliarde ", " Trilliarden "}, {" Quadrillion ", " Quadrillionen "}, {" Quadrilliarde ", " Quadrilliarden "}, {" Quintillion ", " Quintillionen "}, {" Quintilliarde ", " Quintilliarden "}, {" Sextillion ", " Sextillionen "}, {" Sextilliarde ", " Sextilliarden "}, {" Septillion ", " Septillionen "}, {" Septilliarde ", " Septilliarden "}, {" Oktillion ", " Oktillionen "}, {" Oktilliarde ", " Oktilliarden "}, {" Nonillion ", " Nonillionen "}, {" Nonilliarde ", " Nonilliarden "}, {" Dezillion ", " Dezillionen "}, {" Dezilliarde ", " Dezilliarden "}, {" Undezillion ", " Undezillionen "}, {" Undezilliarde ", " Undezilliarden "}, {" Duodezillion ", " Duodezillionen "}, {" Duodezilliarde ", " Duodezilliarden "}, {" Tredizillion ", " Tredizillionen "}, {" Tredizilliarde ", " Tredizilliarden "}, {" Quattuordezillion ", " Quattuordezillionen "}, {" Quattuordezilliarde ", " Quattuordezilliarden "}, {" Quindezillion ", " Quindezillionen "}, {" Quindezilliarde ", " Quindezilliarden "}};
    private static final String NULL = "null";
    private static final String MINUS = "minus";
    private static final String EINS = "eins";
    private static final String UND = "und";
    private static final String HUNDERT = "hundert";
    public static final String EIN = "ein";
    public static final String EINE = "eine";
    protected String[] _1to9 = new String[]{"eins", "zwei", "drei", "vier", "f\u00fcnf", "sechs", "sieben", "acht", "neun"};

    public GermanNumber() {
    }

    public GermanNumber(long number) throws Exception {
        super(number);
    }

    public GermanNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 96;
    }

    @Override
    public String getSoundDir() {
        return "german";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("minus ");
        }
        if (this.numberType == 0) {
            this.number2digits();
            if (this.number.equalsIgnoreCase("0")) {
                this.syllables.add(NULL);
            } else {
                int counter = amount.length - 1;
                for (int i = this.MAX_DIGITS - 3; i > 0; i -= 3) {
                    this.xtriple(i, i == 3 ? EIN : EINE, amount[counter][0], amount[counter][1]);
                    --counter;
                }
                this.triple(0, EINS);
            }
        } else if (this.numberType == 1) {
            this.fillSyllables(NULL, this._1to9);
        }
    }

    protected void triple(int index, String smallestNumber) {
        this.triple(FIELD, index, smallestNumber);
    }

    protected void triple(String[][] field, int index, String smallestNumber) {
        if (this.digits[index + 2] > 0) {
            this.syllables.add(field[0][this.digits[index + 2] - 1]);
            this.syllables.add(HUNDERT);
        }
        if (this.digits[index + 1] == 0 && this.digits[index] == 1) {
            this.syllables.add(smallestNumber);
        } else if (this.digits[index + 1] == 1 && this.digits[index] > 0) {
            this.syllables.add(field[1][this.digits[index] - 1]);
        } else if (this.digits[index + 1] == 1 && this.digits[index] == 0) {
            this.syllables.add(field[2][this.digits[index + 1] - 1]);
        } else if (this.digits[index + 1] != 1) {
            if (this.digits[index + 0] > 0) {
                this.syllables.add(field[0][this.digits[index] - 1]);
            }
            if (this.digits[index + 1] > 0) {
                if (this.digits[index + 0] > 0) {
                    this.syllables.add(UND);
                }
                this.syllables.add(field[2][this.digits[index + 1] - 1]);
            }
        }
    }

    private void xtriple(int index, String minimum, String singular, String plural) {
        if (this.digits[index] + this.digits[index + 1] + this.digits[index + 2] > 0) {
            this.triple(index, minimum);
            int sum = this.digits[index] + this.digits[index + 1] * 10 + this.digits[index + 2] * 100;
            if (sum >= 2) {
                this.syllables.add(plural);
            } else {
                this.syllables.add(singular);
            }
        }
    }

    public static String toString(long number) throws Exception {
        return new GermanNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new GermanNumber(number).toString();
    }
}

