/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.spokennumbers;

import net.numericalchameleon.util.spokennumbers.SpokenNumber;

public class FrenchBelgiumNumber
extends SpokenNumber {
    private static final String[][] field = new String[][]{{"un", "deux", "trois", "quatre", "cinq", "six", "sept", "huit", "neuf"}, {"onze", "douze", "treize", "quatorze", "quinze", "seize", "dix-sept", "dix-huit", "dix-neuf"}, {"dix", "vingt", "trente", "quarante", "cinquante", "soixante", "septante", "quatre-vingt", "nonante"}};
    private static final String[] amount = new String[]{" mille", " million", " milliard", " billion", " billiard", " trillion", " trilliard", " quadrillion", " quadrilliard", " quintillion", " quintilliard", " sextillion", " sextilliard", " septillion", " septilliard", " octillion", " octilliard", " nonillion", " nonilliard", " decillion", " decilliard", " undecillion", " undecilliard", " duodecillion", " duodecilliard", " tredicillion", " tredicilliard", " quattuordecillion", " quattuordecilliard", " quindecillion", " quindecilliard"};
    private static final String ET = " et ";
    private static final String DASH = "-";
    private static final String NULL = "z\u00e9ro";
    private static final String MINUS = "moins";
    private static final String CENT = " cent";
    private static final String CENTS = " cents";
    private static final String PLURAL = "s";

    public FrenchBelgiumNumber() {
    }

    public FrenchBelgiumNumber(long number) throws Exception {
        super(number);
    }

    public FrenchBelgiumNumber(String number) throws Exception {
        super(number);
    }

    @Override
    protected int getSupportedDigits() {
        return 96;
    }

    @Override
    public String getSoundDir() {
        return "french";
    }

    @Override
    protected void convert2Syllables() throws Exception {
        if (this.number.charAt(0) == '-') {
            this.number = this.number.substring(1);
            this.syllables.add("moins ");
        }
        if (this.numberType == 1) {
            this.fillSyllables(NULL, field[0]);
            return;
        }
        this.number2digits();
        if (this.number.equalsIgnoreCase("0") || this.number.matches("^0+$")) {
            this.syllables.add(NULL);
        } else {
            int counter = amount.length - 1;
            for (int i = this.MAX_DIGITS - 3; i > 0; i -= 3) {
                this.xtriple(i, amount[counter]);
                --counter;
            }
            this.triple(0);
        }
    }

    private void triple(int index) {
        if (this.digits[index + 2] > 0) {
            if (this.digits[index + 2] > 1) {
                this.syllables.add(field[0][this.digits[index + 2] - 1]);
                String temp = CENT;
                int sum = this.digits[index] + this.digits[index + 1] * 10;
                if (sum == 0 && index != 3) {
                    temp = CENTS;
                }
                this.syllables.add(temp);
            } else {
                this.syllables.add(CENT);
            }
            this.syllables.add(" ");
        }
        if (this.digits[index] == 0) {
            int value = this.digits[index + 1];
            if (value > 0) {
                String temp = field[2][value - 1];
                if (value == 8 && index != 3) {
                    temp = temp + PLURAL;
                }
                this.syllables.add(temp);
            }
        } else {
            switch (this.digits[index + 1]) {
                case 0: {
                    this.syllables.add(field[0][this.digits[index] - 1]);
                    break;
                }
                case 1: {
                    this.syllables.add(field[1][this.digits[index] - 1]);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.syllables.add(field[2][this.digits[index + 1] - 1]);
                    if (this.digits[index] == 1 && this.digits[index + 1] != 8) {
                        this.syllables.add(ET);
                    } else {
                        this.syllables.add(DASH);
                    }
                    this.syllables.add(field[0][this.digits[index] - 1]);
                }
            }
        }
    }

    private void xtriple(int index, String singular) {
        if (this.digits[index] + this.digits[index + 1] + this.digits[index + 2] > 0) {
            this.triple(index);
            String temp = singular;
            int sum = this.digits[index] + this.digits[index + 1] * 10 + this.digits[index + 2] * 100;
            if (sum > 1 && index != 3) {
                temp = temp + PLURAL;
            }
            this.syllables.add(temp);
            this.syllables.add(" ");
        }
    }

    public static String toString(long number) throws Exception {
        return new FrenchBelgiumNumber(number).toString();
    }

    public static String toString(String number) throws Exception {
        return new FrenchBelgiumNumber(number).toString();
    }
}

