/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.misc;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import jonelo.sugar.util.ExtendedGregorianCalendar;

public class DateQueries {
    private static int yearView(int year, int factor) {
        int major = year / factor;
        int minor = year % factor;
        if (minor > 0) {
            ++major;
        }
        return major;
    }

    public static int decade(int year) {
        return DateQueries.yearView(year, 10);
    }

    public static int century(int year) {
        return DateQueries.yearView(year, 100);
    }

    public static int millennium(int year) {
        return DateQueries.yearView(year, 1000);
    }

    public static String season(GregorianCalendar gc, String[] seasons, String timeZone, boolean north) {
        Object season = null;
        int year = gc.get(1);
        ExtendedGregorianCalendar egc = new ExtendedGregorianCalendar();
        egc.setTimeZone(TimeZone.getTimeZone(timeZone));
        int index = 0;
        switch (gc.get(2)) {
            case 3: 
            case 4: {
                index = 0;
                break;
            }
            case 6: 
            case 7: {
                index = 1;
                break;
            }
            case 9: 
            case 10: {
                index = 2;
                break;
            }
            case 0: 
            case 1: {
                index = 3;
                break;
            }
            case 2: {
                egc.setEquinox(2, year);
                if (gc.get(5) >= egc.get(5)) {
                    index = 0;
                    break;
                }
                index = 3;
                break;
            }
            case 5: {
                egc.setSolstice(5, year);
                if (gc.get(5) >= egc.get(5)) {
                    index = 1;
                    break;
                }
                index = 0;
                break;
            }
            case 8: {
                egc.setEquinox(8, year);
                if (gc.get(5) >= egc.get(5)) {
                    index = 2;
                    break;
                }
                index = 1;
                break;
            }
            case 11: {
                egc.setSolstice(11, year);
                index = gc.get(5) >= egc.get(5) ? 3 : 2;
            }
        }
        if (!north) {
            switch (index) {
                case 0: {
                    return seasons[2];
                }
                case 1: {
                    return seasons[3];
                }
                case 2: {
                    return seasons[0];
                }
                case 3: {
                    return seasons[1];
                }
            }
        }
        return seasons[index];
    }

    public static String westernZodiacSign(int month, int day, String[] names) {
        if (names.length < 12) {
            throw new IllegalArgumentException("12 zodiac sign names expected");
        }
        int ref = (month + 1) * 100 + day;
        if (ref >= 321 && ref <= 420) {
            return names[0];
        }
        if (ref >= 421 && ref <= 520) {
            return names[1];
        }
        if (ref >= 521 && ref <= 621) {
            return names[2];
        }
        if (ref >= 622 && ref <= 723) {
            return names[3];
        }
        if (ref >= 724 && ref <= 823) {
            return names[4];
        }
        if (ref >= 824 && ref <= 923) {
            return names[5];
        }
        if (ref >= 924 && ref <= 1023) {
            return names[6];
        }
        if (ref >= 1024 && ref <= 1122) {
            return names[7];
        }
        if (ref >= 1123 && ref <= 1221) {
            return names[8];
        }
        if (ref >= 1222 || ref <= 120) {
            return names[9];
        }
        if (ref >= 121 && ref <= 218) {
            return names[10];
        }
        if (ref >= 219 && ref <= 320) {
            return names[11];
        }
        return null;
    }

    private static int identicalYear(int year, boolean inTheFuture) {
        ExtendedGregorianCalendar egc = new ExtendedGregorianCalendar();
        egc.set(year, 0, 1);
        int dow = egc.get(7);
        boolean leap = egc.isLeapYear();
        do {
            egc.set(inTheFuture ? ++year : --year, 0, 1);
        } while (egc.get(7) != dow || egc.isLeapYear() != leap);
        return year;
    }

    public static int identicalYearInTheFuture(int year) {
        return DateQueries.identicalYear(year, true);
    }

    public static int identicalYearInThePast(int year) {
        return DateQueries.identicalYear(year, false);
    }

    public static boolean isLeapYear(int year) {
        ExtendedGregorianCalendar egc = new ExtendedGregorianCalendar();
        egc.set(year, 0, 1);
        return egc.isLeapYear();
    }
}

