/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.calendarlistformats;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.numericalchameleon.info.ProgInfo;
import net.numericalchameleon.util.calendarlistformats.ListFormat;

public class XCalendarListFormat
extends ListFormat {
    private final DateFormat formatter = new SimpleDateFormat("yyyyMMdd");

    @Override
    public String getFormat() {
        return "  <vevent>\n    $TVALUE\n    <class>PUBLIC</class>\n    <summary>$TUNIT</summary>\n    <categories>HOLIDAY,Feiertag</categories>\n  </vevent>";
    }

    @Override
    public String getHeader() {
        return "<?xml version=\"1.0\"?>\n<iCalendar xmlns:xCal=\"urn:ietf:params:xml:ns:xcal\">\n  <vcalendar>\n    <version>2.0</version>\n    <prodid>-//" + ProgInfo.getInstance().getHomepage() + "//" + ProgInfo.getInstance().getProgramName() + " " + ProgInfo.getInstance().getVersion() + "//EN</prodid>\n";
    }

    @Override
    public String getFooter() {
        return "  </vcalendar>\n</iCalendar>";
    }

    @Override
    public String reformatDate(int dateformat, String date) throws ParseException {
        Date newdate = DateFormat.getDateInstance(dateformat).parse(date);
        GregorianCalendar local = new GregorianCalendar();
        local.setTime(newdate);
        ((Calendar)local).add(10, 24);
        String zulubegin = this.formatter.format(newdate);
        String zuluend = this.formatter.format(local.getTime());
        return "<dtstart value=\"DATE\">" + zulubegin + "</dtstart>\n    <dtend value=\"DATE\">" + zuluend + "</dtend>";
    }

    @Override
    public String reformatUnit(String unit) {
        return unit;
    }
}

