/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.util.calendarlistformats;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.info.ProgInfo;
import net.numericalchameleon.util.calendarlistformats.ListFormat;

public class ICalendarListFormat
extends ListFormat {
    private final DateFormat formatter = new SimpleDateFormat("yyyyMMdd");

    @Override
    public String getFormat() {
        return "BEGIN:VEVENT\n$TVALUE\nCLASS:PUBLIC\nSUMMARY:$TUNIT\nCATEGORIES:HOLIDAY,Feiertag\nEND:VEVENT";
    }

    @Override
    public String getHeader() {
        return "BEGIN:VCALENDAR\nVERSION:2.0\nPRODID:-//" + ProgInfo.getInstance().getHomepage() + "//NONSGML " + ProgInfo.getInstance().getProgramName() + " " + ProgInfo.getInstance().getVersion() + "//EN\n";
    }

    @Override
    public String getFooter() {
        return "END:VCALENDAR";
    }

    @Override
    public String reformatDate(int dateformat, String date) throws ParseException {
        Date newdate = DateFormat.getDateInstance(dateformat).parse(date);
        GregorianCalendar local = new GregorianCalendar();
        local.setTime(newdate);
        ((Calendar)local).add(10, 24);
        String zulubegin = this.formatter.format(newdate);
        String zuluend = this.formatter.format(local.getTime());
        return "DTSTART;VALUE=DATE:" + zulubegin + "\nDTEND;VALUE=DATE:" + zuluend;
    }

    @Override
    public String reformatUnit(String unit) {
        return GeneralString.replaceAllStrings(unit, ",", "\\,");
    }
}

