/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.update.modules;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Properties;
import net.numericalchameleon.update.UpdateStatus;
import net.numericalchameleon.update.modules.AbstractModule;

public class ExchangeRatesVersionModule
extends AbstractModule {
    public static final String LATEST_KNOWN_VERSION_PROPERTY_NAME = "latest_known_rates_version";
    public static final String VENDOR_PROPERTY_NAME = "rates_vendor";
    public static final String VENDOR_UNKNOWN = "unknown";

    public ExchangeRatesVersionModule() {
        this.name = "Exchange Rates";
        this.vendor = "?";
        this.installedVersion = "";
        this.setLatestKnownVersion();
    }

    public void setVendor(Properties props) {
        this.vendor = props.getProperty(VENDOR_PROPERTY_NAME, VENDOR_UNKNOWN);
    }

    public void setInstalledVersion(Properties props) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(Long.parseLong(props.getProperty("rates_updated")));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String date = sdf.format(gc.getTime());
        this.setInstalledVersion(date);
    }

    private void setLatestKnownVersion() {
        GregorianCalendar gc = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String date = sdf.format(gc.getTime());
        this.setLatestKnownVersion(date);
    }

    @Override
    public UpdateStatus getStatus() {
        UpdateStatus status;
        String a = this.getInstalledVersion();
        String b = this.getLatestKnownVersion();
        if (a == null || b == null || a.equals(VENDOR_UNKNOWN) || b.equals(VENDOR_UNKNOWN)) {
            return UpdateStatus.UNKNOWN;
        }
        UpdateStatus updateStatus = status = a.compareToIgnoreCase(b) < 0 ? UpdateStatus.OUTDATED : UpdateStatus.UPTODATE;
        if (status == UpdateStatus.OUTDATED && a.regionMatches(0, b, 0, 6)) {
            return UpdateStatus.OLDER;
        }
        return status;
    }
}

