/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.update;

import java.util.ResourceBundle;
import net.numericalchameleon.gui.common.interfaces.I18NInterface;

public class UpdateStatus {
    private int status;
    public static final int UPTODATE_ID = 0;
    public static final int OUTDATED_ID = 1;
    public static final int UNKNOWN_ID = 2;
    public static final int OLDER_ID = 3;
    public static final UpdateStatus UNKNOWN = new UpdateStatus(2);
    public static final UpdateStatus OUTDATED = new UpdateStatus(1);
    public static final UpdateStatus UPTODATE = new UpdateStatus(0);
    public static final UpdateStatus OLDER = new UpdateStatus(3);
    private static final String uptodate = "up to date";
    private static final String outdated = "outdated";
    private static final String unknown = "unknown";
    private static final String older = "older";

    public UpdateStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        switch (this.status) {
            case 0: {
                return uptodate;
            }
            case 1: {
                return outdated;
            }
            case 2: {
                return unknown;
            }
            case 3: {
                return older;
            }
        }
        return unknown;
    }

    public String toString(I18NInterface i18nInterface) {
        ResourceBundle rb = i18nInterface.getResourceBundle();
        switch (this.status) {
            case 0: {
                return rb.getString("GUI.UpdateCenter.UpdateStatus.UpToDate");
            }
            case 1: {
                return rb.getString("GUI.UpdateCenter.UpdateStatus.Outdated");
            }
            case 2: {
                return rb.getString("GUI.UpdateCenter.UpdateStatus.Unknown");
            }
            case 3: {
                return rb.getString("GUI.UpdateCenter.UpdateStatus.Older");
            }
        }
        return rb.getString("GUI.UpdateCenter.UpdateStatus.Unknown");
    }

    public boolean equals(UpdateStatus status) {
        return this.status == status.getStatus();
    }
}

